#
# Copyright (c), 2016-2020, SISSA (International School for Advanced Studies).
# All rights reserved.
# This file is distributed under the terms of the MIT License.
# See the file 'LICENSE' in the root directory of the present
# distribution, or http://opensource.org/licenses/MIT.
#
# @author Davide Brunato <brunato@sissa.it>
#


class XMLSchemaException(Exception):
    """The base exception that let you catch all the errors generated by the library."""


class XMLSchemaOSError(XMLSchemaException, OSError):
    pass


class XMLSchemaAttributeError(XMLSchemaException, AttributeError):
    pass


class XMLSchemaTypeError(XMLSchemaException, TypeError):
    pass


class XMLSchemaValueError(XMLSchemaException, ValueError):
    pass


class XMLSchemaSyntaxError(XMLSchemaException, SyntaxError):
    pass


class XMLSchemaKeyError(XMLSchemaException, KeyError):
    pass


class XMLSchemaIndexError(XMLSchemaException, ImportError):
    pass


class XMLSchemaResourceError(XMLSchemaException, OSError):
    """Raised when an error is found accessing an XML resource."""


class XMLSchemaRegexError(XMLSchemaException, ValueError):
    """Raised when an error is found when parsing an XML Schema regular expression."""


class XMLSchemaNamespaceError(XMLSchemaException, RuntimeError):
    """Raised when a wrong runtime condition is found with a namespace."""


class XMLSchemaWarning(Warning):
    """Base warning class for the XMLSchema package."""
