/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.control.ExtensionFactory;

public class OptionsExtensionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("options.ext.label.enabled"), Constant.messages.getString("options.ext.label.core"), Constant.messages.getString("options.ext.label.author"), Constant.messages.getString("options.ext.label.extension")};
    private List<Extension> extensions = ExtensionFactory.getAllExtensions();
    private static Logger log = Logger.getLogger(OptionsExtensionTableModel.class);
    private Map<String, Boolean> extensionsState = new HashMap<String, Boolean>();

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.extensions.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Extension ext = this.getExtension(row);
        if (ext != null) {
            try {
                switch (col) {
                    case 0: {
                        return this.getEnabledState(ext);
                    }
                    case 1: {
                        if (ext.isCore()) {
                            return Constant.messages.getString("options.ext.label.iscore");
                        }
                        return "";
                    }
                    case 2: {
                        return ext.getAuthor();
                    }
                    case 3: {
                        return ext.getUIName();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed on extension " + ext.getName()), (Throwable)e);
            }
        }
        return null;
    }

    private boolean getEnabledState(Extension extension) {
        Boolean enabledState = this.extensionsState.get(extension.getName());
        if (enabledState == null) {
            return true;
        }
        return enabledState;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Extension selectedExtension = this.getExtension(rowIndex);
            if (selectedExtension.isCore() && this.getEnabledState(selectedExtension)) {
                return false;
            }
            List<Class<? extends Extension>> deps = selectedExtension.getDependencies();
            for (Class<? extends Extension> dep : deps) {
                Extension ext = this.getExtension(dep);
                if (ext != null && this.getEnabledState(ext)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Extension getExtension(Class<? extends Extension> c) {
        for (Extension ext : this.extensions) {
            if (!ext.getClass().equals(c)) continue;
            return ext;
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.extensionsState.put(this.getExtension(row).getName(), (Boolean)value);
            this.fireTableCellUpdated(row, col);
            this.enableDependants(this.getExtension(row), (Boolean)value);
        }
    }

    private void enableDependants(Extension extension, Boolean enabled) {
        int row = 0;
        for (Extension ext : this.extensions) {
            if (ext.getDependencies().contains(extension.getClass())) {
                this.extensionsState.put(ext.getName(), enabled);
                this.fireTableCellUpdated(row, 0);
                this.enableDependants(ext, enabled);
            }
            ++row;
        }
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    protected Extension getExtension(int row) {
        return this.extensions.get(row);
    }

    void setExtensionsState(Map<String, Boolean> extensionsState) {
        this.extensionsState = extensionsState;
        this.fireTableDataChanged();
    }

    Map<String, Boolean> getExtensionsState() {
        return this.extensionsState;
    }
}

