/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.Int2IntHashEntry;

public class Int2IntHash {
    int entryCount;
    Int2IntHashEntry[] entries;

    public Int2IntHash(int initialCapacity) {
        this.entries = new Int2IntHashEntry[initialCapacity];
    }

    public synchronized int get(int key) {
        Int2IntHashEntry[] entries = this.entries;
        int hash = (key & Integer.MAX_VALUE) % entries.length;
        Int2IntHashEntry e = entries[hash];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return Integer.MIN_VALUE;
    }

    public synchronized void put(int key, int value) {
        Int2IntHashEntry[] entries = this.entries;
        int n = entries.length;
        int hash = (key & Integer.MAX_VALUE) % n;
        Int2IntHashEntry e = entries[hash];
        while (e != null) {
            if (e.key == key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (this.entryCount > n) {
            int oldSize = n;
            n += n + 1;
            Int2IntHashEntry[] newEntries = new Int2IntHashEntry[n];
            int i = oldSize;
            while (--i >= 0) {
                Int2IntHashEntry e2 = entries[i];
                while (e2 != null) {
                    Int2IntHashEntry t = e2;
                    e2 = e2.next;
                    hash = (t.key & Integer.MAX_VALUE) % n;
                    t.next = newEntries[hash];
                    newEntries[hash] = t;
                }
            }
            this.entries = newEntries;
            entries = newEntries;
            hash = (key & Integer.MAX_VALUE) % n;
        }
        entries[hash] = new Int2IntHashEntry(key, value, entries[hash]);
        ++this.entryCount;
    }
}

