/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayElement;
import org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrBackendUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019H\u0002J\r\u0010%\u001a\u00020\u0011*\u00020\u0019H\u0086\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilder;", "", "builder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "arrayType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getArrayType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getBuilder", "()Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "elementType", "getElementType", "elements", "", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayElement;", "hasSpread", "", "getHasSpread", "()Z", "isUnboxedInlineClassArray", "unwrappedArrayType", "getUnwrappedArrayType", "add", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "addSpread", "build", "buildComplexArray", "buildSimpleArray", "coerce", "irType", "copyArray", "spread", "newArray", "size", "", "unaryPlus", "backend.jvm"})
public final class IrArrayBuilder {
    @NotNull
    private final IrType unwrappedArrayType;
    @NotNull
    private final IrType elementType;
    private final List<IrArrayElement> elements;
    @NotNull
    private final JvmIrBuilder builder;
    @NotNull
    private final IrType arrayType;

    @NotNull
    public final IrType getUnwrappedArrayType() {
        return this.unwrappedArrayType;
    }

    public final boolean isUnboxedInlineClassArray() {
        return this.arrayType != this.unwrappedArrayType;
    }

    @NotNull
    public final IrType getElementType() {
        return this.elementType;
    }

    private final boolean getHasSpread() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrArrayElement it = (IrArrayElement)element$iv;
                    boolean bl2 = false;
                    if (!it.isSpread()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean unaryPlus(@NotNull IrExpression $this$unaryPlus) {
        Intrinsics.checkParameterIsNotNull($this$unaryPlus, "$this$unaryPlus");
        return this.add($this$unaryPlus);
    }

    public final boolean add(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return this.elements.add(new IrArrayElement(expression2, false));
    }

    public final boolean addSpread(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return this.elements.add(new IrArrayElement(expression2, true));
    }

    @NotNull
    public final IrExpression build() {
        IrExpression array = this.elements.isEmpty() ? this.newArray(0) : (!this.getHasSpread() ? this.buildSimpleArray() : (this.elements.size() == 1 ? this.copyArray(CollectionsKt.single(this.elements).getExpression()) : this.buildComplexArray()));
        return this.coerce(array, this.arrayType);
    }

    private final IrExpression newArray(int size) {
        return this.newArray(ExpressionHelpersKt.irInt(this.builder, size));
    }

    private final IrExpression newArray(IrExpression size) {
        IrSymbol irSymbol;
        if (IrUtilsKt.isBoxedArray(this.unwrappedArrayType)) {
            irSymbol = this.builder.getIrSymbols().getArrayOfNulls();
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.unwrappedArrayType);
            if (irClassSymbol == null) {
                Intrinsics.throwNpe();
            }
            Sequence<IrConstructorSymbol> $this$single$iv = org.jetbrains.kotlin.ir.util.IrUtilsKt.getConstructors(irClassSymbol);
            boolean $i$f$single = false;
            IrConstructorSymbol single$iv = null;
            boolean found$iv = false;
            Iterator<IrConstructorSymbol> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrConstructorSymbol element$iv;
                IrConstructorSymbol it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(((IrConstructor)it.getOwner()).getValueParameters().size() == 1)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            irSymbol = single$iv;
        }
        IrSymbol arrayConstructor = irSymbol;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)this.builder, (IrFunctionSymbol)arrayConstructor, this.unwrappedArrayType);
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl3 = false;
        if ($this$apply.getTypeArgumentsCount() != 0) {
            $this$apply.putTypeArgument(0, this.elementType);
        }
        $this$apply.putValueArgument(0, size);
        return irFunctionAccessExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildSimpleArray() {
        IrBuilderWithScope $this$irBlock$iv = this.builder;
        int startOffset$iv = $this$irBlock$iv.getStartOffset();
        int endOffset$iv = $this$irBlock$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv;
        boolean bl = false;
        IrVariable result2 = ExpressionHelpersKt.irTemporary$default($this$irBlock, this.newArray(this.elements.size()), null, null, null, 14, null);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.unwrappedArrayType);
        if (irClassSymbol == null) {
            Intrinsics.throwNpe();
        }
        Sequence<IrSimpleFunctionSymbol> $this$single$iv22 = org.jetbrains.kotlin.ir.util.IrUtilsKt.getFunctions(irClassSymbol);
        boolean $i$f$single = false;
        IrSimpleFunctionSymbol single$iv = null;
        boolean found$iv = false;
        Iterator<IrSimpleFunctionSymbol> iterator2 = $this$single$iv22.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunctionSymbol element$iv;
            IrSimpleFunctionSymbol it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "set")) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol set = single$iv;
        boolean $this$single$iv22 = false;
        for (IrArrayElement element : (Iterable)this.elements) {
            void index2;
            IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, set);
            IrBlockBuilder irBlockBuilder = $this$irBlock;
            boolean bl3 = false;
            boolean bl4 = false;
            IrCall $this$apply = irCall;
            boolean bl5 = false;
            $this$apply.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irBlock, result2));
            $this$apply.putValueArgument(0, ExpressionHelpersKt.irInt($this$irBlock, (int)index2));
            $this$apply.putValueArgument(1, this.coerce(element.getExpression(), this.elementType));
            IrCall irCall2 = irCall;
            irBlockBuilder.unaryPlus(irCall2);
            ++index2;
        }
        $this$irBlock.unaryPlus(ExpressionHelpersKt.irGet($this$irBlock, result2));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression copyArray(IrExpression spread) {
        if (spread instanceof IrConstructorCall || spread instanceof IrFunctionAccessExpression && Intrinsics.areEqual(((IrFunctionAccessExpression)spread).getSymbol(), this.builder.getIrSymbols().getArrayOfNulls())) {
            return spread;
        }
        IrBuilderWithScope $this$irBlock$iv = this.builder;
        int startOffset$iv = $this$irBlock$iv.getStartOffset();
        int endOffset$iv = $this$irBlock$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv;
        boolean bl = false;
        IrValueDeclaration spreadVar = spread instanceof IrGetValue ? ((IrGetValue)spread).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default($this$irBlock, spread, null, null, null, 14, null);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.unwrappedArrayType);
        if (irClassSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = IrBackendUtilsKt.getPropertyGetter(irClassSymbol, "size");
        if (irSimpleFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrSimpleFunctionSymbol size = irSimpleFunctionSymbol;
        Function0<IrCall> $fun$getSize$1 = new Function0<IrCall>($this$irBlock, size, spreadVar){
            final /* synthetic */ IrBlockBuilder $this_irBlock;
            final /* synthetic */ IrSimpleFunctionSymbol $size;
            final /* synthetic */ IrValueDeclaration $spreadVar;

            @NotNull
            public final IrCall invoke() {
                IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)this.$this_irBlock, this.$size);
                boolean bl = false;
                boolean bl2 = false;
                IrCall $this$apply = irCall;
                boolean bl3 = false;
                $this$apply.setDispatchReceiver(ExpressionHelpersKt.irGet(this.$this_irBlock, this.$spreadVar));
                return irCall;
            }
            {
                this.$this_irBlock = irBlockBuilder;
                this.$size = irSimpleFunctionSymbol;
                this.$spreadVar = irValueDeclaration;
                super(0);
            }
        };
        IrVariable result2 = ExpressionHelpersKt.irTemporary$default($this$irBlock, this.newArray((IrExpression)$fun$getSize$1.invoke()), null, null, null, 14, null);
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, this.builder.getIrSymbols().getSystemArraycopy());
        IrBlockBuilder irBlockBuilder = $this$irBlock;
        boolean bl2 = false;
        boolean bl3 = false;
        IrCall $this$apply = irCall;
        boolean bl4 = false;
        $this$apply.putValueArgument(0, this.coerce(ExpressionHelpersKt.irGet($this$irBlock, spreadVar), this.unwrappedArrayType));
        $this$apply.putValueArgument(1, ExpressionHelpersKt.irInt($this$irBlock, 0));
        $this$apply.putValueArgument(2, ExpressionHelpersKt.irGet($this$irBlock, result2));
        $this$apply.putValueArgument(3, ExpressionHelpersKt.irInt($this$irBlock, 0));
        $this$apply.putValueArgument(4, (IrExpression)$fun$getSize$1.invoke());
        IrCall irCall2 = irCall;
        irBlockBuilder.unaryPlus(irCall2);
        $this$irBlock.unaryPlus(ExpressionHelpersKt.irGet($this$irBlock, result2));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression buildComplexArray() {
        Object element$iv;
        Object element$iv2;
        IrClassSymbol spreadBuilder2 = IrUtilsKt.isBoxedArray(this.unwrappedArrayType) ? this.builder.getIrSymbols().getSpreadBuilder() : MapsKt.getValue(this.builder.getIrSymbols().getPrimitiveSpreadBuilders(), this.elementType);
        Sequence<IrSimpleFunctionSymbol> $this$single$iv = org.jetbrains.kotlin.ir.util.IrUtilsKt.getFunctions(spreadBuilder2);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        Iterator<IrSimpleFunctionSymbol> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv2 = iterator2.next();
            IrSimpleFunctionSymbol it = element$iv2;
            boolean bl = false;
            if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "add")) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv2;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol addElement = (IrSimpleFunctionSymbol)single$iv;
        Sequence<IrSimpleFunctionSymbol> $this$single$iv2 = org.jetbrains.kotlin.ir.util.IrUtilsKt.getFunctions(spreadBuilder2);
        boolean $i$f$single2 = false;
        Object single$iv2 = null;
        boolean found$iv2 = false;
        element$iv2 = $this$single$iv2.iterator();
        while (element$iv2.hasNext()) {
            element$iv = element$iv2.next();
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "addSpread")) continue;
            if (found$iv2) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv2 = element$iv;
            found$iv2 = true;
        }
        if (!found$iv2) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol addSpread = (IrSimpleFunctionSymbol)single$iv2;
        Sequence<IrSimpleFunctionSymbol> $this$single$iv3 = org.jetbrains.kotlin.ir.util.IrUtilsKt.getFunctions(spreadBuilder2);
        boolean $i$f$single3 = false;
        Object single$iv3 = null;
        boolean found$iv3 = false;
        element$iv = $this$single$iv3.iterator();
        while (element$iv.hasNext()) {
            Object element$iv3 = element$iv.next();
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv3;
            boolean bl = false;
            if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "toArray")) continue;
            if (found$iv3) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv3 = element$iv3;
            found$iv3 = true;
        }
        if (!found$iv3) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol toArray = single$iv3;
        IrBuilderWithScope $this$irBlock$iv = this.builder;
        int startOffset$iv = $this$irBlock$iv.getStartOffset();
        int endOffset$iv = $this$irBlock$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv;
        boolean bl = false;
        IrConstructorSymbol irConstructorSymbol = SequencesKt.single(org.jetbrains.kotlin.ir.util.IrUtilsKt.getConstructors(spreadBuilder2));
        Object object = $this$irBlock;
        IrStatementsBuilder irStatementsBuilder = $this$irBlock;
        boolean bl2 = false;
        List list2 = CollectionsKt.emptyList();
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilderWithScope)object, irConstructorSymbol, list2);
        boolean bl3 = false;
        boolean bl4 = false;
        IrConstructorCall $this$apply = irConstructorCall;
        boolean bl5 = false;
        $this$apply.putValueArgument(0, ExpressionHelpersKt.irInt($this$irBlock, this.elements.size()));
        object = irConstructorCall;
        IrVariable spreadBuilderVar = ExpressionHelpersKt.irTemporary$default(irStatementsBuilder, (IrExpression)object, null, null, null, 14, null);
        for (IrArrayElement element : this.elements) {
            IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, element.isSpread() ? addSpread : addElement);
            irStatementsBuilder = $this$irBlock;
            boolean bl6 = false;
            bl5 = false;
            IrCall $this$apply2 = irCall;
            boolean bl7 = false;
            $this$apply2.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irBlock, spreadBuilderVar));
            $this$apply2.putValueArgument(0, this.coerce(element.getExpression(), element.isSpread() ? this.unwrappedArrayType : this.elementType));
            object = irCall;
            irStatementsBuilder.unaryPlus((IrStatement)object);
        }
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, toArray);
        bl4 = false;
        boolean bl8 = false;
        Object $this$apply3 = irCall;
        boolean bl9 = false;
        $this$apply3.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irBlock, spreadBuilderVar));
        if (IrUtilsKt.isBoxedArray(this.unwrappedArrayType)) {
            Sequence<IrSimpleFunctionSymbol> $this$single$iv4 = org.jetbrains.kotlin.ir.util.IrUtilsKt.getFunctions(spreadBuilder2);
            boolean $i$f$single4 = false;
            IrSimpleFunctionSymbol single$iv4 = null;
            boolean found$iv4 = false;
            Iterator<IrSimpleFunctionSymbol> iterator3 = $this$single$iv4.iterator();
            while (iterator3.hasNext()) {
                IrSimpleFunctionSymbol element$iv4;
                IrSimpleFunctionSymbol it = element$iv4 = iterator3.next();
                boolean bl10 = false;
                if (!Intrinsics.areEqual(((IrSimpleFunction)it.getOwner()).getName().asString(), "size")) continue;
                if (found$iv4) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv4 = element$iv4;
                found$iv4 = true;
            }
            if (!found$iv4) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunctionSymbol size = single$iv4;
            IrCall irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, this.builder.getIrSymbols().getArrayOfNulls(), this.arrayType);
            int n = 0;
            Object object2 = $this$apply3;
            boolean bl11 = false;
            boolean bl12 = false;
            IrCall $this$apply4 = irCall2;
            boolean bl13 = false;
            $this$apply4.putTypeArgument(0, this.elementType);
            IrCall irCall3 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, size);
            int n2 = 0;
            IrCall irCall4 = $this$apply4;
            boolean bl14 = false;
            boolean bl15 = false;
            IrCall $this$apply5 = irCall3;
            boolean bl16 = false;
            $this$apply5.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irBlock, spreadBuilderVar));
            IrCall irCall5 = irCall3;
            irCall4.putValueArgument(n2, irCall5);
            IrCall irCall6 = irCall2;
            object2.putValueArgument(n, irCall6);
        }
        Object toArrayCall = irCall;
        if (IrUtilsKt.isBoxedArray(this.unwrappedArrayType)) {
            $this$irBlock.unaryPlus(ExpressionHelpersKt.irImplicitCast(this.builder, (IrExpression)toArrayCall, this.unwrappedArrayType));
        } else {
            $this$irBlock.unaryPlus((IrStatement)toArrayCall);
        }
        return this_$iv$iv.doBuild();
    }

    private final IrExpression coerce(IrExpression expression2, IrType irType) {
        IrExpression irExpression;
        if (this.isUnboxedInlineClassArray()) {
            IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)this.builder, this.builder.getIrSymbols().getUnsafeCoerceIntrinsic(), irType);
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$apply = irCall;
            boolean bl3 = false;
            $this$apply.putTypeArgument(0, expression2.getType());
            $this$apply.putTypeArgument(1, irType);
            $this$apply.putValueArgument(0, expression2);
            irExpression = irCall;
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }

    @NotNull
    public final JvmIrBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final IrType getArrayType() {
        return this.arrayType;
    }

    public IrArrayBuilder(@NotNull JvmIrBuilder builder, @NotNull IrType arrayType) {
        List list2;
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        Intrinsics.checkParameterIsNotNull(arrayType, "arrayType");
        this.builder = builder;
        this.arrayType = arrayType;
        this.unwrappedArrayType = InlineClassAbiKt.unboxInlineClass(this.arrayType);
        this.elementType = IrUtilsKt.getArrayElementType(this.unwrappedArrayType, this.builder.getContext().getIrBuiltIns());
        IrArrayBuilder irArrayBuilder = this;
        boolean bl = false;
        irArrayBuilder.elements = list2 = (List)new ArrayList();
    }
}

