/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.model.crf.Table;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureTemplate
implements ICacheAble {
    static final Pattern pattern = Pattern.compile("%x\\[(-?\\d*),(\\d*)]");
    String template;
    ArrayList<int[]> offsetList;
    List<String> delimiterList;

    public static FeatureTemplate create(String template) {
        FeatureTemplate featureTemplate = new FeatureTemplate();
        featureTemplate.delimiterList = new LinkedList<String>();
        featureTemplate.offsetList = new ArrayList(3);
        featureTemplate.template = template;
        Matcher matcher = pattern.matcher(template);
        int start = 0;
        while (matcher.find()) {
            featureTemplate.delimiterList.add(template.substring(start, matcher.start()));
            start = matcher.end();
            featureTemplate.offsetList.add(new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))});
        }
        return featureTemplate;
    }

    public char[] generateParameter(Table table, int current) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String d : this.delimiterList) {
            sb.append(d);
            int[] offset = this.offsetList.get(i++);
            sb.append(table.get(current + offset[0], offset[1]));
        }
        char[] o = new char[sb.length()];
        sb.getChars(0, sb.length(), o, 0);
        return o;
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.template);
        out.writeInt(this.offsetList.size());
        for (int[] offset : this.offsetList) {
            out.writeInt(offset[0]);
            out.writeInt(offset[1]);
        }
        out.writeInt(this.delimiterList.size());
        for (String s : this.delimiterList) {
            out.writeUTF(s);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        int i;
        this.template = byteArray.nextUTF();
        int size = byteArray.nextInt();
        this.offsetList = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            this.offsetList.add(new int[]{byteArray.nextInt(), byteArray.nextInt()});
        }
        size = byteArray.nextInt();
        this.delimiterList = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.delimiterList.add(byteArray.nextUTF());
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureTemplate{");
        sb.append("template='").append(this.template).append('\'');
        sb.append(", delimiterList=").append(this.delimiterList);
        sb.append('}');
        return sb.toString();
    }

    public String getTemplate() {
        return this.template;
    }
}

