/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.LeaderBoardItem;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class LeaderBoardTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Pane leaderBoardPane;
    private ChartDataEventListener updateHandler;
    private InvalidationListener paneSizeListener;
    private Map<LeaderBoardItem, EventHandler<MouseEvent>> handlerMap;

    public LeaderBoardTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.updateHandler = e -> {
            ChartDataEvent.EventType TYPE2 = e.getType();
            switch (TYPE2) {
                case UPDATE: {
                    this.updateChart();
                    break;
                }
                case FINISHED: {
                    this.sortItems();
                }
            }
        };
        this.paneSizeListener = o -> this.resizeItems();
        this.handlerMap = new HashMap<LeaderBoardItem, EventHandler<MouseEvent>>();
        List leaderBoardItems = this.tile.getLeaderBoardItems().stream().sorted(Comparator.comparing(LeaderBoardItem::getValue).reversed()).collect(Collectors.toList());
        this.registerItemListeners();
        this.leaderBoardPane = new Pane();
        this.leaderBoardPane.getChildren().addAll(leaderBoardItems);
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.text, this.leaderBoardPane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.pane.widthProperty().addListener(this.paneSizeListener);
        this.pane.heightProperty().addListener(this.paneSizeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
        } else if ("DATA".equals(EVENT_TYPE)) {
            this.registerItemListeners();
        }
    }

    private void registerItemListeners() {
        this.tile.getLeaderBoardItems().forEach(item -> {
            item.setFormatString(this.formatString);
            item.addChartDataEventListener(this.updateHandler);
            EventHandler<MouseEvent> clickHandler = e -> this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, item.getChartData()));
            this.handlerMap.put((LeaderBoardItem)item, clickHandler);
            item.addEventHandler(MouseEvent.MOUSE_PRESSED, clickHandler);
        });
        this.tile.getLeaderBoardItems().addListener(new WeakListChangeListener(change -> {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated()) continue;
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(addedItem -> {
                        addedItem.setFormatString(this.formatString);
                        addedItem.addChartDataEventListener(this.updateHandler);
                        EventHandler<MouseEvent> clickHandler = e -> this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, addedItem.getChartData()));
                        this.handlerMap.put((LeaderBoardItem)addedItem, clickHandler);
                        addedItem.addEventHandler(MouseEvent.MOUSE_PRESSED, clickHandler);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(removedItem -> {
                    removedItem.removeChartDataEventListener(this.updateHandler);
                    removedItem.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.handlerMap.get(removedItem));
                });
            }
        }));
    }

    private void sortItems() {
        ObservableList<LeaderBoardItem> items = this.tile.getLeaderBoardItems();
        items.sort(Comparator.comparing(LeaderBoardItem::getValue).reversed());
        items.forEach(i -> i.setIndex(items.indexOf(i)));
        this.updateChart();
    }

    @Override
    public void dispose() {
        this.pane.widthProperty().removeListener(this.paneSizeListener);
        this.pane.heightProperty().removeListener(this.paneSizeListener);
        this.tile.getLeaderBoardItems().forEach(item -> {
            item.removeChartDataEventListener(this.updateHandler);
            item.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.handlerMap.get(item));
        });
        this.handlerMap.clear();
        super.dispose();
    }

    private void updateChart() {
        Platform.runLater(() -> {
            ObservableList<LeaderBoardItem> items = this.tile.getLeaderBoardItems();
            int noOfItems = items.size();
            if (noOfItems == 0) {
                return;
            }
            double maxY = this.height - this.size * 0.25;
            for (int i = 0; i < noOfItems; ++i) {
                LeaderBoardItem item = (LeaderBoardItem)items.get(i);
                double y = (double)i * 0.175 * this.size;
                if (y < maxY) {
                    item.setManaged(true);
                    item.setVisible(true);
                    item.relocate(0.0, y);
                    continue;
                }
                item.setVisible(false);
                item.setManaged(false);
            }
        });
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    private void resizeItems() {
        this.leaderBoardPane.getChildren().forEach(node -> {
            LeaderBoardItem item = (LeaderBoardItem)node;
            item.setParentSize(this.width, this.height);
            item.setPrefSize(this.width, this.height * 0.12);
            item.setMaxSize(this.width, this.height * 0.12);
        });
    }

    @Override
    protected void resize() {
        super.resize();
        this.leaderBoardPane.setPrefSize(this.width, this.contentBounds.getHeight());
        this.leaderBoardPane.relocate(0.0, this.contentBounds.getY());
        this.resizeItems();
        this.updateChart();
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.tile.getLeaderBoardItems().forEach(item -> {
            item.setNameColor(this.tile.getTextColor());
            item.setValueColor(this.tile.getValueColor());
        });
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
    }
}

