/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.controller.starter.RuntimeExec;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialogEinstellungen.DialogImportPset;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Functions;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVHttpClient;
import mediathek.tool.MVMessageDialog;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GuiFunktionenProgramme
extends GuiFunktionen {
    private static final ArrayList<String> winPfade = new ArrayList();
    private static final Logger logger = LogManager.getLogger(GuiFunktionenProgramme.class);

    private static void setWinProgPfade() {
        String[] PFAD;
        String pfad;
        if (System.getenv("ProgramFiles") != null && new File(pfad = System.getenv("ProgramFiles")).exists() && !winPfade.contains(pfad)) {
            winPfade.add(pfad);
        }
        if (System.getenv("ProgramFiles(x86)") != null && new File(pfad = System.getenv("ProgramFiles(x86)")).exists() && !winPfade.contains(pfad)) {
            winPfade.add(pfad);
        }
        for (String s2 : PFAD = new String[]{"C:\\Program Files", "C:\\Programme", "C:\\Program Files (x86)"}) {
            if (!new File(s2).exists() || winPfade.contains(s2)) continue;
            winPfade.add(s2);
        }
    }

    public static String getMusterPfadVlc() {
        String PFAD_LINUX_VLC = "/usr/bin/vlc";
        String PFAD_FREEBSD = "/usr/local/bin/vlc";
        String PFAD_MAC_VLC = "/Applications/VLC.app/Contents/MacOS/VLC";
        String PFAD_WIN = "\\VideoLAN\\VLC\\vlc.exe";
        Object pfad = "";
        try {
            switch (Functions.getOs()) {
                case LINUX: {
                    if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                        pfad = "/usr/local/bin/vlc";
                        break;
                    }
                    pfad = "/usr/bin/vlc";
                    break;
                }
                case MAC: {
                    pfad = "/Applications/VLC.app/Contents/MacOS/VLC";
                    break;
                }
                default: {
                    String s2;
                    GuiFunktionenProgramme.setWinProgPfade();
                    Iterator<String> iterator2 = winPfade.iterator();
                    while (iterator2.hasNext() && !new File((String)(pfad = (s2 = iterator2.next()) + "\\VideoLAN\\VLC\\vlc.exe")).exists()) {
                    }
                    break;
                }
            }
            if (!new File((String)pfad).exists() && System.getenv("PATH_VLC") != null) {
                pfad = System.getenv("PATH_VLC");
            }
            if (!new File((String)pfad).exists()) {
                pfad = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pfad;
    }

    public static String getMusterPfadFFmpeg() {
        String PFAD_LINUX_FFMPEG = "/usr/bin/ffmpeg";
        String PFAD_FREEBSD_FFMPEG = "/usr/local/bin/ffmpeg";
        String PFAD_MAC_FFMPEG = "/Applications/MediathekView.app/Contents/Resources/ffmpeg";
        String PFAD_WINDOWS_FFMPEG = "bin\\ffmpeg.exe";
        String pfad = "";
        try {
            switch (Functions.getOs()) {
                case LINUX: {
                    if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                        pfad = "/usr/local/bin/ffmpeg";
                        break;
                    }
                    pfad = "/usr/bin/ffmpeg";
                    break;
                }
                case MAC: {
                    pfad = "/Applications/MediathekView.app/Contents/Resources/ffmpeg";
                    break;
                }
                default: {
                    pfad = "bin\\ffmpeg.exe";
                }
            }
            if (!new File(pfad).exists() && System.getenv("PATH_FFMPEG") != null) {
                pfad = System.getenv("PATH_FFMPEG");
            }
            if (!new File(pfad).exists()) {
                pfad = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pfad;
    }

    public static String getPfadScript() {
        String PFAD_LINUX_SCRIPT = "bin/flv.sh";
        String PFAD_WINDOWS_SCRIPT = "bin\\flv.bat";
        return switch (Functions.getOs()) {
            case Functions.OperatingSystemType.LINUX, Functions.OperatingSystemType.MAC -> GuiFunktionenProgramme.getPathJar() + "bin/flv.sh";
            default -> "bin\\flv.bat";
        };
    }

    public static void addSetVorlagen(JFrame parent, Daten daten, ListePset pSet, boolean setVersion) {
        if (pSet == null) {
            MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            return;
        }
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        for (DatenPset ps : pSet) {
            if (ps.arr[16].isEmpty() || GuiFunktionenProgramme.addOnZip(ps.arr[16])) continue;
            MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            return;
        }
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        DialogImportPset dialog = new DialogImportPset(parent, true, daten, pSet);
        dialog.setVisible(true);
        if (dialog.ok) {
            if (Daten.listePset.addPset(pSet)) {
                if (setVersion) {
                    MVConfig.add(MVConfig.Configs.SYSTEM_VERSION_PROGRAMMSET, pSet.version);
                }
                MVMessageDialog.showMessageDialog(null, pSet.size() + " Programmset importiert!", "Ok", 1);
            } else {
                MVMessageDialog.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addOnZip(String datei) {
        String zielPfad = GuiFunktionenProgramme.addsPfad(GuiFunktionenProgramme.getPathJar(), "bin");
        try {
            if (!GuiFunktionen.istUrl(datei)) {
                File zipFile = new File(datei);
                if (!zipFile.exists()) {
                    return false;
                }
                if (datei.endsWith(".zip")) {
                    if (GuiFunktionenProgramme.entpacken(zipFile, new File(zielPfad))) return true;
                    return false;
                }
                try (FileInputStream in = new FileInputStream(datei);
                     FileOutputStream fOut = new FileOutputStream(GuiFunktionen.addsPfad(zielPfad, datei));){
                    int n;
                    byte[] buffer = new byte[65536];
                    while ((n = in.read(buffer)) != -1) {
                        fOut.write(buffer, 0, n);
                    }
                    return true;
                }
            }
            Request request = new Request.Builder().url(datei).get().header("User-Agent", ApplicationConfiguration.getConfiguration().getString("application.user_agent")).get().build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (!response.isSuccessful()) return true;
                if (body == null) return true;
                try (InputStream is = body.byteStream();
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    byte[] buffer = new byte[65536];
                    if (datei.endsWith(".zip")) {
                        File tmpFile = File.createTempFile("mediathek", null);
                        tmpFile.deleteOnExit();
                        try (FileOutputStream fOut2 = new FileOutputStream(tmpFile);){
                            int n;
                            while ((n = bis.read(buffer)) != -1) {
                                fOut2.write(buffer, 0, n);
                            }
                        }
                        if (GuiFunktionenProgramme.entpacken(tmpFile, new File(zielPfad))) return true;
                        boolean fOut2 = false;
                        return fOut2;
                    }
                    String file = GuiFunktionen.getDateiName(datei);
                    File f = new File(GuiFunktionen.addsPfad(zielPfad, file));
                    try (FileOutputStream fOut = new FileOutputStream(f);){
                        int n;
                        while ((n = bis.read(buffer)) != -1) {
                            fOut.write(buffer, 0, n);
                        }
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean entpacken(File archive, File destDir) throws Exception {
        if (!destDir.exists()) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[16384];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryFileName = entry.getName();
                File dir = GuiFunktionenProgramme.buildDirectoryHierarchyFor(entryFileName, destDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (entry.isDirectory()) continue;
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(destDir, entryFileName)));
                     BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
                    int len;
                    while ((len = bis.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    bos.flush();
                }
            }
        }
        return true;
    }

    private static File buildDirectoryHierarchyFor(String entryName, File destDir) {
        int lastIndex = entryName.lastIndexOf(47);
        String internalPathToEntry = entryName.substring(0, lastIndex + 1);
        return new File(destDir, internalPathToEntry);
    }

    public static boolean praefixTesten(String str, String uurl, boolean praefix) {
        boolean ret = false;
        String url = uurl.toLowerCase();
        Object s1 = "";
        if (str.isEmpty()) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 = (String)s1 + str.charAt(i);
                }
                if (str.charAt(i) != ',' && i < str.length() - 1) continue;
                if (praefix) {
                    if (url.startsWith(((String)s1).toLowerCase())) {
                        ret = true;
                        break;
                    }
                } else if (url.endsWith(((String)s1).toLowerCase())) {
                    ret = true;
                    break;
                }
                s1 = "";
            }
        }
        return ret;
    }

    public static boolean checkPathWriteable(@NotNull String path) {
        boolean ret = false;
        if (path.isEmpty()) {
            return false;
        }
        File testFile = new File(path);
        try {
            if (!testFile.exists()) {
                testFile.mkdirs();
            }
            if (testFile.isDirectory() && testFile.canWrite()) {
                File tmpFile = File.createTempFile("mediathek", "tmp", testFile);
                ret = tmpFile.delete();
            }
        }
        catch (Exception e) {
            logger.error("checkPathWriteable()", (Throwable)e);
        }
        return ret;
    }

    public static boolean programmePruefen(JFrame jFrame) {
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        boolean ret = true;
        Object text = "";
        for (DatenPset datenPset : Daten.listePset) {
            ret = true;
            if (datenPset.isFreeLine() || datenPset.isLabel()) continue;
            text = (String)text + "++++++++++++++++++++++++++++++++++++++++++++\n";
            text = (String)text + "| Programmgruppe: " + datenPset.arr[0] + "\n";
            String zielPfad = datenPset.arr[4];
            if (datenPset.progsContainPath()) {
                if (zielPfad.isEmpty()) {
                    ret = false;
                    text = (String)text + "|       Zielpfad fehlt!\n";
                } else if (!GuiFunktionenProgramme.checkPathWriteable(zielPfad)) {
                    ret = false;
                    text = (String)text + "|       Falscher Zielpfad!\n";
                    text = (String)text + "|        -> Zielpfad \"" + zielPfad + "\" nicht beschreibbar!\n";
                }
            }
            for (DatenProg datenProg : datenPset.getListeProg()) {
                if (datenProg.arr[2].isEmpty()) {
                    ret = false;
                    text = (String)text + "|       Kein Programm angegeben!\n";
                    text = (String)text + "|        -> Programmname: " + datenProg.arr[0] + "\n";
                    text = (String)text + "|             Pfad: " + datenProg.arr[2] + "\n";
                    continue;
                }
                if (new File(datenProg.arr[2]).canExecute()) continue;
                RuntimeExec r = new RuntimeExec(datenProg.arr[2]);
                Process pr = r.exec(false);
                if (pr != null) {
                    pr.destroy();
                    continue;
                }
                ret = false;
                text = (String)text + "|       Falscher Programmpfad!\n";
                text = (String)text + "|        -> Programmname: " + datenProg.arr[0] + "\n";
                text = (String)text + "|             Pfad: " + datenProg.arr[2] + "\n";
                if (datenProg.arr[2].contains(File.separator)) continue;
                text = (String)text + "|        -> Wenn das Programm nicht im Systempfad liegt, \n";
                text = (String)text + "|             wird der Start nicht klappen!\n";
            }
            if (ret) {
                text = (String)text + "|  -> Ok!\n";
            }
            text = (String)text + "++++++++++++++++++++++++++++++++++++++++++++\n\n\n";
        }
        new DialogHilfe(jFrame, true, (String)text).setVisible(true);
        return ret;
    }
}

