/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.dns.DnsSelector;
import mediathek.tool.dns.DnsSelector$WhenMappings;
import mediathek.tool.dns.IPvPreferenceMode;
import okhttp3.Dns;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/tool/dns/DnsSelector;", "Lokhttp3/Dns;", "preferenceMode", "Lmediathek/tool/dns/IPvPreferenceMode;", "(Lmediathek/tool/dns/IPvPreferenceMode;)V", "lookup", "", "Ljava/net/InetAddress;", "hostname", "", "Companion", "MediathekView"})
public final class DnsSelector
implements Dns {
    private final IPvPreferenceMode preferenceMode;
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) {
        List<InetAddress> list;
        Intrinsics.checkParameterIsNotNull(hostname, "hostname");
        List<InetAddress> addresses = Dns.SYSTEM.lookup(hostname);
        switch (DnsSelector$WhenMappings.$EnumSwitchMapping$0[this.preferenceMode.ordinal()]) {
            case 1: {
                Iterable $this$sortedBy$iv = addresses;
                boolean $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        InetAddress it = (InetAddress)a;
                        boolean bl2 = false;
                        Comparable comparable = Boolean.valueOf(Inet4Address.class.isInstance(it));
                        it = (InetAddress)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Boolean bl3 = Inet4Address.class.isInstance(it);
                        return ComparisonsKt.compareValues(comparable2, (Comparable)bl3);
                    }
                };
                list = CollectionsKt.sortedWith(iterable, comparator);
                break;
            }
            case 2: {
                Iterable $this$sortedBy$iv = addresses;
                boolean $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        InetAddress it = (InetAddress)a;
                        boolean bl2 = false;
                        Comparable comparable = Boolean.valueOf(Inet6Address.class.isInstance(it));
                        it = (InetAddress)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Boolean bl3 = Inet6Address.class.isInstance(it);
                        return ComparisonsKt.compareValues(comparable2, (Comparable)bl3);
                    }
                };
                list = CollectionsKt.sortedWith(iterable, comparator);
                break;
            }
            case 3: {
                InetAddress it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = addresses;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InetAddress)element$iv$iv;
                    boolean bl = false;
                    if (!Inet6Address.class.isInstance(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 4: {
                InetAddress it;
                Iterable $this$filter$iv = addresses;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InetAddress)element$iv$iv;
                    boolean bl = false;
                    if (!Inet4Address.class.isInstance(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 5: {
                list = addresses;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        addresses = list;
        logger.trace("Dns (" + hostname + "): " + CollectionsKt.joinToString$default(addresses, ", ", null, null, 0, null, lookup.5.INSTANCE, 30, null));
        return addresses;
    }

    public DnsSelector(@NotNull IPvPreferenceMode preferenceMode) {
        Intrinsics.checkParameterIsNotNull((Object)preferenceMode, "preferenceMode");
        this.preferenceMode = preferenceMode;
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(DnsSelector.class.getName());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/tool/dns/DnsSelector$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

