/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.protege.editor.owl.ui.action.SelectedOWLClassAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class MakeInstancesOfClassDifferentIndividualsAction
extends SelectedOWLClassAction {
    @Override
    protected void initialiseAction() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        int ret;
        OWLClass selectedClass = this.getOWLClass();
        if (selectedClass == null) {
            return;
        }
        Set individuals = this.getOWLModelManager().getActiveOntologies().stream().flatMap(o -> o.getClassAssertionAxioms((OWLClassExpression)selectedClass).stream()).map(OWLClassAssertionAxiom::getIndividual).filter(i -> !i.isAnonymous()).map(OWLIndividual::asOWLNamedIndividual).collect(Collectors.toSet());
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        List removeExistingAxiomsChanges = activeOntology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS).stream().filter(ax -> individuals.containsAll(ax.getIndividuals())).map(ax -> new RemoveAxiom(activeOntology, (OWLAxiom)ax)).collect(Collectors.toList());
        ArrayList<Object> allChanges = new ArrayList<Object>();
        if (!removeExistingAxiomsChanges.isEmpty() && (ret = JOptionPane.showConfirmDialog((Component)this.getWorkspace(), "Do you want to remove existing Different Individuals axioms which assert that\nsome instances of the selected class are different?", "Remove existing axioms", 0, 3)) == 0) {
            allChanges.addAll(removeExistingAxiomsChanges);
        }
        OWLDifferentIndividualsAxiom ax2 = this.getOWLDataFactory().getOWLDifferentIndividualsAxiom(individuals);
        allChanges.add(new AddAxiom(activeOntology, (OWLAxiom)ax2));
        this.getOWLModelManager().applyChanges(allChanges);
    }
}

