/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;

class DisplayListRenderMethod
implements RenderMethod {
    final int bufferSize = 128;
    int[] buffer = new int[128];

    DisplayListRenderMethod() {
    }

    @Override
    public boolean render(RenderMolecule renderMolecule, Canvas3D canvas3D, RenderAtomListInfo renderAtomListInfo, int n) {
        if (renderMolecule.doInfinite || !VirtualUniverse.mc.viewFrustumCulling || renderMolecule.vwcBounds.intersect(canvas3D.viewFrustum)) {
            canvas3D.updateState(n);
            canvas3D.callDisplayList(canvas3D.ctx, renderMolecule.displayListId, renderMolecule.isNonUniformScale);
            return true;
        }
        return false;
    }

    public boolean renderSeparateDlists(RenderMolecule renderMolecule, Canvas3D canvas3D, RenderAtomListInfo renderAtomListInfo, int n) {
        if (renderMolecule.doInfinite) {
            canvas3D.updateState(n);
            while (renderAtomListInfo != null) {
                canvas3D.callDisplayList(canvas3D.ctx, ((GeometryArrayRetained)renderAtomListInfo.geometry()).dlistId, renderMolecule.isNonUniformScale);
                renderAtomListInfo = renderAtomListInfo.next;
            }
            return true;
        }
        boolean bl = false;
        while (renderAtomListInfo != null) {
            if (canvas3D.ra == renderAtomListInfo.renderAtom) {
                if (canvas3D.raIsVisible) {
                    canvas3D.updateState(n);
                    canvas3D.callDisplayList(canvas3D.ctx, ((GeometryArrayRetained)renderAtomListInfo.geometry()).dlistId, renderMolecule.isNonUniformScale);
                    bl = true;
                }
            } else {
                if (renderAtomListInfo.renderAtom.localeVwcBounds.intersect(canvas3D.viewFrustum)) {
                    canvas3D.updateState(n);
                    canvas3D.raIsVisible = true;
                    canvas3D.callDisplayList(canvas3D.ctx, ((GeometryArrayRetained)renderAtomListInfo.geometry()).dlistId, renderMolecule.isNonUniformScale);
                    bl = true;
                } else {
                    canvas3D.raIsVisible = false;
                }
                canvas3D.ra = renderAtomListInfo.renderAtom;
            }
            renderAtomListInfo = renderAtomListInfo.next;
        }
        return bl;
    }

    public boolean renderSeparateDlistPerRinfo(RenderMolecule renderMolecule, Canvas3D canvas3D, RenderAtomListInfo renderAtomListInfo, int n) {
        if (renderMolecule.doInfinite) {
            canvas3D.updateState(n);
            while (renderAtomListInfo != null) {
                canvas3D.callDisplayList(canvas3D.ctx, renderAtomListInfo.renderAtom.dlistIds[renderAtomListInfo.index], renderMolecule.isNonUniformScale);
                renderAtomListInfo = renderAtomListInfo.next;
            }
            return true;
        }
        boolean bl = false;
        while (renderAtomListInfo != null) {
            if (canvas3D.ra == renderAtomListInfo.renderAtom) {
                if (canvas3D.raIsVisible) {
                    canvas3D.updateState(n);
                    canvas3D.callDisplayList(canvas3D.ctx, renderAtomListInfo.renderAtom.dlistIds[renderAtomListInfo.index], renderMolecule.isNonUniformScale);
                    bl = true;
                }
            } else {
                if (renderAtomListInfo.renderAtom.localeVwcBounds.intersect(canvas3D.viewFrustum)) {
                    canvas3D.updateState(n);
                    canvas3D.raIsVisible = true;
                    canvas3D.callDisplayList(canvas3D.ctx, renderAtomListInfo.renderAtom.dlistIds[renderAtomListInfo.index], renderMolecule.isNonUniformScale);
                    bl = true;
                } else {
                    canvas3D.raIsVisible = false;
                }
                canvas3D.ra = renderAtomListInfo.renderAtom;
            }
            renderAtomListInfo = renderAtomListInfo.next;
        }
        return bl;
    }

    void buildDisplayList(RenderMolecule renderMolecule, Canvas3D canvas3D) {
        boolean bl = renderMolecule.useAlpha;
        if (renderMolecule.primaryRenderAtomList != null && renderMolecule.texCoordSetMapLen <= canvas3D.maxTexCoordSets) {
            canvas3D.newDisplayList(canvas3D.ctx, renderMolecule.displayListId);
            RenderAtomListInfo renderAtomListInfo = renderMolecule.primaryRenderAtomList;
            while (renderAtomListInfo != null) {
                Transform3D transform3D;
                Transform3D transform3D2;
                GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry();
                if (renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform == null) {
                    transform3D2 = null;
                    transform3D = null;
                } else {
                    transform3D2 = renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform.transform;
                    transform3D = (geometryArrayRetained.vertexFormat & 2) != 0 ? renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform.getNormalTransform() : null;
                }
                geometryArrayRetained.buildGA(canvas3D, renderAtomListInfo.renderAtom, false, bl && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, renderMolecule.textureBin.attributeBin.ignoreVertexColors, transform3D2, transform3D);
                renderAtomListInfo = renderAtomListInfo.next;
            }
            canvas3D.endDisplayList(canvas3D.ctx);
        }
    }

    void buildIndividualDisplayList(RenderAtomListInfo renderAtomListInfo, Canvas3D canvas3D, Context context) {
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry();
        if (geometryArrayRetained.texCoordSetMap != null && geometryArrayRetained.texCoordSetMap.length > canvas3D.maxTexCoordSets) {
            return;
        }
        canvas3D.newDisplayList(context, geometryArrayRetained.dlistId);
        geometryArrayRetained.buildGA(canvas3D, renderAtomListInfo.renderAtom, false, false, 1.0f, false, null, null);
        canvas3D.endDisplayList(context);
    }

    void buildDlistPerRinfo(RenderAtomListInfo renderAtomListInfo, RenderMolecule renderMolecule, Canvas3D canvas3D) {
        boolean bl = renderMolecule.useAlpha;
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry();
        if (renderMolecule.primaryRenderAtomList != null && renderMolecule.texCoordSetMapLen <= canvas3D.maxTexCoordSets) {
            Transform3D transform3D;
            Transform3D transform3D2;
            int n = renderAtomListInfo.renderAtom.dlistIds[renderAtomListInfo.index];
            canvas3D.newDisplayList(canvas3D.ctx, n);
            geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry();
            if (renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform == null) {
                transform3D2 = null;
                transform3D = null;
            } else {
                transform3D2 = renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform.transform;
                transform3D = (geometryArrayRetained.vertexFormat & 2) != 0 ? renderAtomListInfo.renderAtom.geometryAtom.source.staticTransform.getNormalTransform() : null;
            }
            geometryArrayRetained.buildGA(canvas3D, renderAtomListInfo.renderAtom, false, bl && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, renderMolecule.textureBin.attributeBin.ignoreVertexColors, transform3D2, transform3D);
            canvas3D.endDisplayList(canvas3D.ctx);
        }
    }
}

