/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public class ScannerParam
extends AbstractParam {
    private static final String ACTIVE_SCAN_BASE_KEY = "scanner";
    private static final String HOST_PER_SCAN = "scanner.hostPerScan";
    private static final String THREAD_PER_HOST = "scanner.threadPerHost";
    private static final String DELAY_IN_MS = "scanner.delayInMs";
    private static final String INJECT_PLUGIN_ID_IN_HEADER = "scanner.pluginHeader";
    private static final String HANDLE_ANTI_CSRF_TOKENS = "scanner.antiCSFR";
    private static final String PROMPT_IN_ATTACK_MODE = "scanner.attackPrompt";
    private static final String RESCAN_IN_ATTACK_MODE = "scanner.attackRescan";
    private static final String PROMPT_TO_CLEAR_FINISHED = "scanner.clearFinished";
    private static final String MAX_RESULTS_LIST = "scanner.maxResults";
    private static final String MAX_SCANS_IN_UI = "scanner.maxScansInUI";
    private static final String SHOW_ADV_DIALOG = "scanner.advDialog";
    private static final String DEFAULT_POLICY = "scanner.defaultPolicy";
    private static final String ATTACK_POLICY = "scanner.attackPolicy";
    private static final String ALLOW_ATTACK_ON_START = "scanner.attackOnStart";
    private static final String MAX_CHART_TIME_IN_MINS = "scanner.chartTimeInMins";
    private static final String MAX_RULE_DURATION_IN_MINS = "scanner.maxRuleDurationInMins";
    private static final String MAX_SCAN_DURATION_IN_MINS = "scanner.maxScanDurationInMins";
    private static final String EXCLUDED_PARAMS_KEY = "scanner.excludedParameters";
    private static final String EXCLUDED_PARAM_NAME = "name";
    private static final String EXCLUDED_PARAM_TYPE = "type";
    private static final String EXCLUDED_PARAM_URL = "url";
    private static final String TARGET_INJECTABLE = "scanner.injectable";
    private static final String TARGET_ENABLED_RPC = "scanner.enabledRPC";
    private static final String SCAN_HEADERS_ALL_REQUESTS = "scanner.scanHeadersAllRequests";
    private static final String SCAN_ADD_QUERY_PARAM = "scanner.addQueryParam";
    public static final int TARGET_QUERYSTRING = 1;
    public static final int TARGET_POSTDATA = 2;
    public static final int TARGET_COOKIE = 4;
    public static final int TARGET_HTTPHEADERS = 8;
    public static final int TARGET_URLPATH = 16;
    public static final int RPC_MULTIPART = 1;
    public static final int RPC_XML = 2;
    public static final int RPC_JSON = 4;
    public static final int RPC_GWT = 8;
    public static final int RPC_ODATA = 16;
    public static final int RPC_DWR = 32;
    public static final int RPC_CUSTOM = 128;
    public static final int RPC_USERDEF = 256;
    public static final int TARGET_INJECTABLE_DEFAULT = 3;
    public static final int TARGET_ENABLED_RPC_DEFAULT = 191;
    private static final int DEFAULT_MAX_CHART_TIME_IN_MINS = 10;
    private int hostPerScan = 2;
    private int threadPerHost = 2;
    private int delayInMs = 0;
    private int maxResultsToList = 1000;
    private int maxScansInUI = 5;
    private boolean injectPluginIdInHeader = false;
    private boolean handleAntiCSRFTokens = false;
    private boolean promptInAttackMode = true;
    private boolean rescanInAttackMode = true;
    private boolean promptToClearFinishedScans = true;
    private boolean showAdvancedDialog = false;
    private boolean allowAttackOnStart = false;
    private String defaultPolicy;
    private String attackPolicy;
    private int maxChartTimeInMins = 10;
    private int maxRuleDurationInMins = 0;
    private int maxScanDurationInMins = 0;
    private int targetParamsInjectable = 3;
    private int targetParamsEnabledRPC = 191;
    private boolean scanHeadersAllRequests;
    private boolean addQueryParam;
    private final List<ScannerParamFilter> excludedParams = new ArrayList<ScannerParamFilter>();
    private final Map<Integer, List<ScannerParamFilter>> excludedParamsMap = new HashMap<Integer, List<ScannerParamFilter>>();
    private static final Logger logger = Logger.getLogger(ScannerParam.class);

    @Override
    protected void parse() {
        this.removeOldOptions();
        this.threadPerHost = this.getInt(THREAD_PER_HOST, 2);
        this.hostPerScan = this.getInt(HOST_PER_SCAN, 2);
        this.delayInMs = this.getInt(DELAY_IN_MS, 0);
        this.maxResultsToList = this.getInt(MAX_RESULTS_LIST, 1000);
        this.maxRuleDurationInMins = this.getInt(MAX_RULE_DURATION_IN_MINS, 0);
        this.maxScanDurationInMins = this.getInt(MAX_SCAN_DURATION_IN_MINS, 0);
        this.maxScansInUI = this.getInt(MAX_SCANS_IN_UI, 5);
        this.injectPluginIdInHeader = this.getBoolean(INJECT_PLUGIN_ID_IN_HEADER, false);
        this.handleAntiCSRFTokens = this.getBoolean(HANDLE_ANTI_CSRF_TOKENS, false);
        this.promptInAttackMode = this.getBoolean(PROMPT_IN_ATTACK_MODE, true);
        this.rescanInAttackMode = this.getBoolean(RESCAN_IN_ATTACK_MODE, true);
        this.promptToClearFinishedScans = this.getBoolean(PROMPT_TO_CLEAR_FINISHED, true);
        this.showAdvancedDialog = this.getBoolean(SHOW_ADV_DIALOG, false);
        this.defaultPolicy = this.getString(DEFAULT_POLICY, null);
        this.attackPolicy = this.getString(ATTACK_POLICY, null);
        this.targetParamsInjectable = this.getInt(TARGET_INJECTABLE, 3);
        this.targetParamsEnabledRPC = this.getInt(TARGET_ENABLED_RPC, 191);
        this.allowAttackOnStart = this.getBoolean(ALLOW_ATTACK_ON_START, false);
        this.maxChartTimeInMins = this.getInt(MAX_CHART_TIME_IN_MINS, 10);
        this.scanHeadersAllRequests = this.getBoolean(SCAN_HEADERS_ALL_REQUESTS, false);
        this.addQueryParam = this.getBoolean(SCAN_ADD_QUERY_PARAM, false);
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(EXCLUDED_PARAMS_KEY);
            this.excludedParams.clear();
            this.excludedParamsMap.clear();
            ArrayList<String> tempParamNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(EXCLUDED_PARAM_NAME, "");
                if (name.isEmpty() || tempParamNames.contains(name)) continue;
                tempParamNames.add(name);
                this.addScannerParamFilter(name, sub.getInt(EXCLUDED_PARAM_TYPE, -1), sub.getString(EXCLUDED_PARAM_URL));
            }
        }
        catch (ConversionException e) {
            logger.error((Object)("Error while loading the excluded parameter list: " + e.getMessage()), (Throwable)e);
        }
        if (this.excludedParams.isEmpty()) {
            this.addScannerParamFilter("(?i)ASP.NET_SessionId", -1, "*");
            this.addScannerParamFilter("(?i)ASPSESSIONID.*", -1, "*");
            this.addScannerParamFilter("(?i)PHPSESSID", -1, "*");
            this.addScannerParamFilter("(?i)SITESERVER", -1, "*");
            this.addScannerParamFilter("(?i)sessid", -1, "*");
            this.addScannerParamFilter("__VIEWSTATE", 2, "*");
            this.addScannerParamFilter("__EVENTVALIDATION", 2, "*");
            this.addScannerParamFilter("__EVENTTARGET", 2, "*");
            this.addScannerParamFilter("__EVENTARGUMENT", 2, "*");
            this.addScannerParamFilter("javax.faces.ViewState", 2, "*");
            this.addScannerParamFilter("(?i)jsessionid", -1, "*");
            this.addScannerParamFilter("cfid", 4, "*");
            this.addScannerParamFilter("cftoken", 4, "*");
        }
    }

    private void removeOldOptions() {
        String oldKey = "scanner.deleteOnShutdown";
        if (this.getConfig().containsKey("scanner.deleteOnShutdown")) {
            this.getConfig().clearProperty("scanner.deleteOnShutdown");
        }
    }

    private void addScannerParamFilter(String paramName, int paramType, String url) {
        ScannerParamFilter filter = new ScannerParamFilter();
        filter.setParamName(paramName);
        filter.setType(paramType);
        filter.setWildcardedUrl(url);
        List<ScannerParamFilter> subList = this.excludedParamsMap.get(filter.getType());
        if (subList == null) {
            subList = new ArrayList<ScannerParamFilter>();
            this.excludedParamsMap.put(filter.getType(), subList);
        }
        this.excludedParams.add(filter);
        subList.add(filter);
    }

    @ZapApiIgnore
    public List<ScannerParamFilter> getExcludedParamList() {
        return this.excludedParams;
    }

    public List<ScannerParamFilter> getExcludedParamList(int paramType) {
        return this.excludedParamsMap.get(paramType);
    }

    public void setExcludedParamList(List<ScannerParamFilter> filters) {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(EXCLUDED_PARAMS_KEY);
        this.excludedParams.clear();
        this.excludedParamsMap.clear();
        int size = filters.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "scanner.excludedParameters(" + i + ").";
            ScannerParamFilter filter = filters.get(i);
            this.getConfig().setProperty(elementBaseKey + EXCLUDED_PARAM_NAME, (Object)filter.getParamName());
            this.getConfig().setProperty(elementBaseKey + EXCLUDED_PARAM_TYPE, (Object)filter.getType());
            this.getConfig().setProperty(elementBaseKey + EXCLUDED_PARAM_URL, (Object)filter.getWildcardedUrl());
            this.addScannerParamFilter(filter.getParamName(), filter.getType(), filter.getWildcardedUrl());
        }
    }

    public int getThreadPerHost() {
        return this.threadPerHost;
    }

    public void setThreadPerHost(int threadPerHost) {
        this.threadPerHost = threadPerHost;
        this.getConfig().setProperty(THREAD_PER_HOST, (Object)Integer.toString(this.threadPerHost));
    }

    public int getHostPerScan() {
        return this.hostPerScan;
    }

    public void setHostPerScan(int hostPerScan) {
        this.hostPerScan = hostPerScan;
        this.getConfig().setProperty(HOST_PER_SCAN, (Object)Integer.toString(this.hostPerScan));
    }

    public int getMaxResultsToList() {
        return this.maxResultsToList;
    }

    public void setMaxResultsToList(int maxResultsToList) {
        this.maxResultsToList = maxResultsToList;
        this.getConfig().setProperty(MAX_RESULTS_LIST, (Object)Integer.toString(this.maxResultsToList));
    }

    public int getMaxRuleDurationInMins() {
        return this.maxRuleDurationInMins;
    }

    public void setMaxRuleDurationInMins(int maxRuleDurationInMins) {
        this.maxRuleDurationInMins = maxRuleDurationInMins;
        this.getConfig().setProperty(MAX_RULE_DURATION_IN_MINS, (Object)Integer.toString(this.maxRuleDurationInMins));
    }

    public int getMaxScanDurationInMins() {
        return this.maxScanDurationInMins;
    }

    public void setMaxScanDurationInMins(int maxScanDurationInMins) {
        this.maxScanDurationInMins = maxScanDurationInMins;
        this.getConfig().setProperty(MAX_SCAN_DURATION_IN_MINS, (Object)Integer.toString(this.maxScanDurationInMins));
    }

    public void setDelayInMs(int delayInMs) {
        this.delayInMs = delayInMs;
        this.getConfig().setProperty(DELAY_IN_MS, (Object)Integer.toString(this.delayInMs));
    }

    public int getDelayInMs() {
        return this.delayInMs;
    }

    public boolean isInjectPluginIdInHeader() {
        return this.injectPluginIdInHeader;
    }

    public void setInjectPluginIdInHeader(boolean injectPluginIdInHeader) {
        this.injectPluginIdInHeader = injectPluginIdInHeader;
        this.getConfig().setProperty(INJECT_PLUGIN_ID_IN_HEADER, (Object)injectPluginIdInHeader);
    }

    public boolean getHandleAntiCSRFTokens() {
        return this.handleAntiCSRFTokens;
    }

    public void setHandleAntiCSRFTokens(boolean handleAntiCSRFTokens) {
        this.handleAntiCSRFTokens = handleAntiCSRFTokens;
        this.getConfig().setProperty(HANDLE_ANTI_CSRF_TOKENS, (Object)handleAntiCSRFTokens);
    }

    public boolean isRescanInAttackMode() {
        return this.rescanInAttackMode;
    }

    public void setRescanInAttackMode(boolean rescanInAttackMode) {
        this.rescanInAttackMode = rescanInAttackMode;
        this.getConfig().setProperty(RESCAN_IN_ATTACK_MODE, (Object)rescanInAttackMode);
    }

    public boolean isPromptInAttackMode() {
        return this.promptInAttackMode;
    }

    public void setPromptInAttackMode(boolean promptInAttackMode) {
        this.promptInAttackMode = promptInAttackMode;
        this.getConfig().setProperty(PROMPT_IN_ATTACK_MODE, (Object)promptInAttackMode);
    }

    public int getTargetParamsInjectable() {
        return this.targetParamsInjectable;
    }

    public void setTargetParamsInjectable(int targetParamsInjectable) {
        this.targetParamsInjectable = targetParamsInjectable;
        this.getConfig().setProperty(TARGET_INJECTABLE, (Object)this.targetParamsInjectable);
    }

    public int getTargetParamsEnabledRPC() {
        return this.targetParamsEnabledRPC;
    }

    public void setTargetParamsEnabledRPC(int targetParamsEnabledRPC) {
        this.targetParamsEnabledRPC = targetParamsEnabledRPC;
        this.getConfig().setProperty(TARGET_ENABLED_RPC, (Object)this.targetParamsEnabledRPC);
    }

    public boolean isPromptToClearFinishedScans() {
        return this.promptToClearFinishedScans;
    }

    public void setPromptToClearFinishedScans(boolean promptToClearFinishedScans) {
        this.promptToClearFinishedScans = promptToClearFinishedScans;
        this.getConfig().setProperty(PROMPT_TO_CLEAR_FINISHED, (Object)this.promptToClearFinishedScans);
    }

    public int getMaxScansInUI() {
        return this.maxScansInUI;
    }

    public void setMaxScansInUI(int maxScansInUI) {
        this.maxScansInUI = maxScansInUI;
        this.getConfig().setProperty(MAX_SCANS_IN_UI, (Object)this.maxScansInUI);
    }

    public boolean isShowAdvancedDialog() {
        return this.showAdvancedDialog;
    }

    public void setShowAdvancedDialog(boolean showAdvancedDialog) {
        this.showAdvancedDialog = showAdvancedDialog;
        this.getConfig().setProperty(SHOW_ADV_DIALOG, (Object)this.showAdvancedDialog);
    }

    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public String getAttackPolicy() {
        return this.attackPolicy;
    }

    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
        this.getConfig().setProperty(DEFAULT_POLICY, (Object)this.defaultPolicy);
    }

    public void setAttackPolicy(String attackPolicy) {
        this.attackPolicy = attackPolicy;
        this.getConfig().setProperty(ATTACK_POLICY, (Object)this.attackPolicy);
    }

    public boolean isAllowAttackOnStart() {
        return this.allowAttackOnStart;
    }

    public void setAllowAttackOnStart(boolean allowAttackOnStart) {
        this.allowAttackOnStart = allowAttackOnStart;
        this.getConfig().setProperty(ALLOW_ATTACK_ON_START, (Object)this.allowAttackOnStart);
    }

    public int getMaxChartTimeInMins() {
        return this.maxChartTimeInMins;
    }

    public void setMaxChartTimeInMins(int maxChartTimeInMins) {
        this.maxChartTimeInMins = maxChartTimeInMins;
        this.getConfig().setProperty(MAX_CHART_TIME_IN_MINS, (Object)this.maxChartTimeInMins);
    }

    public boolean isScanHeadersAllRequests() {
        return this.scanHeadersAllRequests;
    }

    public void setScanHeadersAllRequests(boolean scanAllRequests) {
        if (scanAllRequests == this.scanHeadersAllRequests) {
            return;
        }
        this.scanHeadersAllRequests = scanAllRequests;
        this.getConfig().setProperty(SCAN_HEADERS_ALL_REQUESTS, (Object)this.scanHeadersAllRequests);
    }

    public boolean isAddQueryParam() {
        return this.addQueryParam;
    }

    public void setAddQueryParam(boolean addQueryParam) {
        this.addQueryParam = addQueryParam;
        this.getConfig().setProperty(SCAN_ADD_QUERY_PARAM, (Object)this.addQueryParam);
    }
}

