/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.TreeNode;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.extension.ascan.filters.GenericFilterUtility;
import org.zaproxy.zap.extension.ascan.filters.ScanFilter;
import org.zaproxy.zap.extension.ascan.filters.impl.HttpStatusCodeScanFilter;
import org.zaproxy.zap.extension.ascan.filters.impl.MethodScanFilter;
import org.zaproxy.zap.extension.ascan.filters.impl.TagScanFilter;
import org.zaproxy.zap.extension.ascan.filters.impl.UrlPatternScanFilter;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.ZapLabel;
import org.zaproxy.zap.view.LayoutHelper;

class FilterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel1 = null;
    private JButton btnReset = null;
    private JPanel jPanel2 = null;
    private JList<String> methodList = null;
    private JList<Integer> codeList = null;
    private JList<String> incTagList = null;
    private JList<String> excTagList = null;
    private JTextArea regexInc = null;
    private JTextArea regexExc = null;
    private DefaultListModel<String> tagModel = null;
    private JScrollPane methodScroller = null;
    private JScrollPane codeScroller = null;
    private JScrollPane incTagScroller = null;
    private JScrollPane excTagScroller = null;
    private JScrollPane urlRegxIncScroller = null;
    private JScrollPane urlRegxExcScroller = null;

    public FilterPanel() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        ZapLabel descLabel = new ZapLabel();
        descLabel.setLineWrap(true);
        descLabel.setWrapStyleWord(true);
        descLabel.setText(Constant.messages.getString("scan.filter.label.desc"));
        this.setLayout(new GridBagLayout());
        gridBagConstraints6.gridwidth = 3;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.insets = new Insets(5, 2, 5, 2);
        gridBagConstraints6.ipadx = 3;
        gridBagConstraints6.ipady = 3;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.gridwidth = 3;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.ipadx = 3;
        gridBagConstraints11.ipady = 3;
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.gridwidth = 3;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints12.ipadx = 0;
        gridBagConstraints12.ipady = 1;
        this.add((Component)descLabel, gridBagConstraints11);
        this.add((Component)this.getJPanel2(), gridBagConstraints12);
        this.add((Component)this.getJPanel1(), gridBagConstraints6);
    }

    private List<Pattern> strToRegexList(String str) throws PatternSyntaxException {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (String s : str.split("\n")) {
            if (s.length() <= 0) continue;
            list.add(Pattern.compile(s));
        }
        return list;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getBtnReset(), null);
        }
        return this.jPanel1;
    }

    public void resetFilterPanel(Target target) {
        this.methodList.setSelectedIndices(new int[0]);
        this.codeList.setSelectedIndices(new int[0]);
        this.incTagList.setSelectedIndices(new int[0]);
        this.excTagList.setSelectedIndices(new int[0]);
        this.regexInc.setText("");
        this.regexExc.setText("");
        if (target != null) {
            this.populateTagsInFilterPanel(target);
        }
    }

    private JButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new JButton();
            this.btnReset.setText(Constant.messages.getString("scan.filter.button.clear"));
            this.btnReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterPanel.this.resetFilterPanel(null);
                }
            });
        }
        return this.btnReset;
    }

    private Insets stdInset() {
        return new Insets(5, 5, 1, 5);
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gbc00 = LayoutHelper.getGBC(0, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc01 = LayoutHelper.getGBC(1, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc02 = LayoutHelper.getGBC(2, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc03 = LayoutHelper.getGBC(3, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gbc10 = LayoutHelper.getGBC(0, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc11 = LayoutHelper.getGBC(1, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc12 = LayoutHelper.getGBC(2, 1, 1, 1, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc22 = LayoutHelper.getGBC(2, 2, 1, 1, 0.0, 0.0, 0, 18, this.stdInset());
            GridBagConstraints gbc32 = LayoutHelper.getGBC(2, 3, 1, 1, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc13 = LayoutHelper.getGBC(3, 1, 1, 1, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gbc23 = LayoutHelper.getGBC(3, 2, 1, 1, 0.0, 0.0, 0, 18, this.stdInset());
            GridBagConstraints gbc33 = LayoutHelper.getGBC(3, 3, 1, 1, 0.0, 0.0, 1, 18, this.stdInset());
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("scan.filter.label.methods")), gbc00);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("scan.filter.label.codes")), gbc01);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("scan.filter.label.incTags")), gbc02);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("scan.filter.label.excTags")), gbc22);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("scan.filter.label.urlincregex")), gbc03);
            this.jPanel2.add((Component)this.getMethodScroller(), gbc10);
            this.jPanel2.add((Component)this.getCodeScroller(), gbc11);
            this.jPanel2.add((Component)this.getIncTagScroller(), gbc12);
            this.jPanel2.add((Component)this.getExcTagScroller(), gbc32);
            this.jPanel2.add((Component)this.getUrlRegxIncScroller(), gbc13);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("scan.filter.label.urlexcregex")), gbc23);
            this.jPanel2.add((Component)this.getUrlRegxExcScroller(), gbc33);
            this.getUrlRegxExcScroller();
        }
        return this.jPanel2;
    }

    private JScrollPane getMethodScroller() {
        if (this.methodScroller == null) {
            this.methodList = new JList<String>(HttpRequestHeader.METHODS);
            this.methodList.setSelectionMode(2);
            this.methodList.setLayoutOrientation(0);
            this.methodList.setVisibleRowCount(HttpRequestHeader.METHODS.length);
            this.methodScroller = new JScrollPane(this.methodList);
        }
        return this.methodScroller;
    }

    private JScrollPane getCodeScroller() {
        if (this.codeScroller == null) {
            Vector<Integer> codeInts = new Vector<Integer>(HttpStatusCode.CODES.length);
            for (int i : HttpStatusCode.CODES) {
                codeInts.add(i);
            }
            this.codeList = new JList(codeInts);
            this.codeList.setSelectionMode(2);
            this.codeList.setLayoutOrientation(0);
            this.codeScroller = new JScrollPane(this.codeList);
        }
        return this.codeScroller;
    }

    private JScrollPane getUrlRegxIncScroller() {
        if (this.urlRegxIncScroller == null) {
            this.regexInc = new JTextArea();
            this.regexInc.setRows(4);
            this.urlRegxIncScroller = new JScrollPane(this.regexInc);
        }
        return this.urlRegxIncScroller;
    }

    private JScrollPane getUrlRegxExcScroller() {
        if (this.urlRegxExcScroller == null) {
            this.regexExc = new JTextArea();
            this.regexExc.setRows(5);
            this.urlRegxExcScroller = new JScrollPane(this.regexExc);
        }
        return this.urlRegxExcScroller;
    }

    private DefaultListModel<String> getTagModel() {
        if (this.tagModel == null) {
            this.tagModel = new DefaultListModel();
        }
        return this.tagModel;
    }

    private JScrollPane getIncTagScroller() {
        if (this.incTagScroller == null) {
            this.incTagList = new JList<String>(this.getTagModel());
            this.incTagList.setPrototypeCellValue("Tags are short...");
            this.incTagScroller = new JScrollPane(this.incTagList);
            this.incTagScroller.setHorizontalScrollBarPolicy(30);
            this.incTagScroller.setVerticalScrollBarPolicy(20);
        }
        return this.incTagScroller;
    }

    private JScrollPane getExcTagScroller() {
        if (this.excTagScroller == null) {
            this.excTagList = new JList<String>(this.getTagModel());
            this.excTagList.setPrototypeCellValue("Tags are short...");
            this.excTagScroller = new JScrollPane(this.excTagList);
            this.excTagScroller.setHorizontalScrollBarPolicy(30);
            this.excTagScroller.setVerticalScrollBarPolicy(20);
        }
        return this.excTagScroller;
    }

    public void setAllTags(List<String> allTags) {
        List<String> selected = this.incTagList.getSelectedValuesList();
        int[] inds = new int[allTags.size()];
        Arrays.fill(inds, -1);
        this.getTagModel().clear();
        int i = 0;
        for (String tag : allTags) {
            this.getTagModel().addElement(tag);
        }
        for (String sel : selected) {
            if (this.getTagModel().contains(sel)) {
                inds[i] = this.getTagModel().indexOf(sel);
            }
            ++i;
        }
        this.incTagList.setSelectedIndices(inds);
    }

    private void addTagsInFilterPanel(SiteNode siteNode, Collection<String> tags) {
        if (siteNode != null) {
            if (siteNode.getHistoryReference() != null && siteNode.getHistoryReference().getTags() != null) {
                tags.addAll(siteNode.getHistoryReference().getTags());
            }
            Enumeration<TreeNode> childEnumeration = siteNode.children();
            while (childEnumeration.hasMoreElements()) {
                TreeNode node = childEnumeration.nextElement();
                if (!(node instanceof SiteNode)) continue;
                this.addTagsInFilterPanel((SiteNode)node, tags);
            }
        }
    }

    private void populateTagsInFilterPanel(Target target) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (target != null) {
            SiteNode siteNode = target.getStartNode();
            if (siteNode != null) {
                this.addTagsInFilterPanel(siteNode, tags);
            } else if (target.getContext() != null || target.isInScopeOnly()) {
                List<Object> nodes = Collections.emptyList();
                if (target.isInScopeOnly()) {
                    nodes = Model.getSingleton().getSession().getTopNodesInScopeFromSiteTree();
                } else if (target.getContext() != null) {
                    nodes = target.getContext().getTopNodesInContextFromSiteTree();
                }
                for (SiteNode siteNode2 : nodes) {
                    this.addTagsInFilterPanel(siteNode2, tags);
                }
            }
        }
        this.setAllTags(new ArrayList<String>(tags));
    }

    public String validateFields() {
        try {
            this.strToRegexList(this.regexInc.getText());
            this.strToRegexList(this.regexExc.getText());
        }
        catch (PatternSyntaxException e1) {
            return Constant.messages.getString("scan.filter.badregex.warning", e1.getMessage());
        }
        return null;
    }

    public List<ScanFilter> getScanFilters() {
        ArrayList<ScanFilter> scanFilterList = new ArrayList<ScanFilter>();
        scanFilterList.addAll(GenericFilterUtility.createScanFilter(this.incTagList.getSelectedValuesList(), this.excTagList.getSelectedValuesList(), TagScanFilter::new));
        scanFilterList.addAll(GenericFilterUtility.createScanFilter(this.methodList.getSelectedValuesList(), null, MethodScanFilter::new));
        scanFilterList.addAll(GenericFilterUtility.createScanFilter(this.codeList.getSelectedValuesList(), null, HttpStatusCodeScanFilter::new));
        scanFilterList.addAll(GenericFilterUtility.createScanFilter(this.strToRegexList(this.regexInc.getText()), this.strToRegexList(this.regexExc.getText()), UrlPatternScanFilter::new));
        return scanFilterList;
    }
}

