/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;

public class Http1FieldPreEncoder
implements HttpFieldPreEncoder {
    @Override
    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_0;
    }

    @Override
    public byte[] getEncodedField(HttpHeader header, String headerString, String value) {
        if (header != null) {
            int cbl = header.getBytesColonSpace().length;
            byte[] bytes2 = Arrays.copyOf(header.getBytesColonSpace(), cbl + value.length() + 2);
            System.arraycopy(value.getBytes(StandardCharsets.ISO_8859_1), 0, bytes2, cbl, value.length());
            bytes2[bytes2.length - 2] = 13;
            bytes2[bytes2.length - 1] = 10;
            return bytes2;
        }
        byte[] n = headerString.getBytes(StandardCharsets.ISO_8859_1);
        byte[] v = value.getBytes(StandardCharsets.ISO_8859_1);
        byte[] bytes3 = Arrays.copyOf(n, n.length + 2 + v.length + 2);
        bytes3[n.length] = 58;
        bytes3[n.length] = 32;
        bytes3[bytes3.length - 2] = 13;
        bytes3[bytes3.length - 1] = 10;
        return bytes3;
    }
}

