/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.DType;

public class DResolvedType
extends DType {
    protected final Class<?> type;
    protected final boolean checkInLookup;

    public DResolvedType(Location location, Class<?> type) {
        this(location, type, true);
    }

    public DResolvedType(Location location, Class<?> type, boolean checkInLookup) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.checkInLookup = checkInLookup;
    }

    @Override
    public DResolvedType resolveType(PainlessLookup painlessLookup) {
        if (!this.checkInLookup) {
            return this;
        }
        if (!painlessLookup.getClasses().contains(this.type)) {
            throw this.location.createError(new IllegalArgumentException("cannot resolve type [" + PainlessLookupUtility.typeToCanonicalTypeName(this.type) + "]"));
        }
        return new DResolvedType(this.location, this.type, false);
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "(DResolvedType [" + PainlessLookupUtility.typeToCanonicalTypeName(this.type) + "])";
    }
}

