/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;

public class JobDispatcher {
    private static final JobDispatcher instance = new JobDispatcher();
    protected BlockingDeque<TileJob> jobQueue = new LinkedBlockingDeque<TileJob>();
    protected static int workerThreadMaxCount = 8;
    protected static int workerThreadTimeout = 30;
    protected boolean modeLIFO = false;
    protected int workerThreadCount = 0;
    protected int workerThreadIdleCount = 0;
    protected int workerThreadId = 0;

    public static JobDispatcher getInstance() {
        return instance;
    }

    private JobDispatcher() {
        this.addWorkerThread().firstThread = true;
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
    }

    public static void setMaxWorkers(int workers) {
        workerThreadMaxCount = workers;
    }

    public void setLIFO(boolean lifo) {
        this.modeLIFO = lifo;
    }

    public void addJob(TileJob job) {
        try {
            if (job.getTile() != null) {
                for (TileJob oldJob : this.jobQueue) {
                    if (oldJob.getTile() != job.getTile()) continue;
                    return;
                }
            }
            this.jobQueue.put(job);
            if (this.workerThreadIdleCount == 0 && this.workerThreadCount < workerThreadMaxCount) {
                this.addWorkerThread();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobThread addWorkerThread() {
        JobThread jobThread = new JobThread(++this.workerThreadId);
        JobDispatcher jobDispatcher = this;
        synchronized (jobDispatcher) {
            ++this.workerThreadCount;
        }
        jobThread.start();
        return jobThread;
    }

    public class JobThread
    extends Thread {
        Runnable job;
        boolean firstThread;

        public JobThread(int threadId) {
            super("OSMJobThread " + threadId);
            this.firstThread = false;
            this.setDaemon(true);
            this.job = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.executeJobs();
            JobDispatcher jobDispatcher = instance;
            synchronized (jobDispatcher) {
                --JobDispatcher.this.workerThreadCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeJobs() {
            while (!this.isInterrupted()) {
                JobDispatcher jobDispatcher;
                try {
                    jobDispatcher = instance;
                    synchronized (jobDispatcher) {
                        ++JobDispatcher.this.workerThreadIdleCount;
                    }
                    this.job = JobDispatcher.this.modeLIFO ? (this.firstThread ? (Runnable)JobDispatcher.this.jobQueue.takeLast() : (Runnable)JobDispatcher.this.jobQueue.pollLast(workerThreadTimeout, TimeUnit.SECONDS)) : (this.firstThread ? (Runnable)JobDispatcher.this.jobQueue.take() : (Runnable)JobDispatcher.this.jobQueue.poll(workerThreadTimeout, TimeUnit.SECONDS));
                }
                catch (InterruptedException e1) {
                    return;
                }
                finally {
                    jobDispatcher = instance;
                    synchronized (jobDispatcher) {
                        --JobDispatcher.this.workerThreadIdleCount;
                    }
                }
                if (this.job == null) {
                    return;
                }
                try {
                    this.job.run();
                    this.job = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

