/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.web.mime;

import grails.config.Config;
import grails.core.GrailsApplication;
import grails.web.mime.MimeType;
import grails.web.mime.MimeTypeProvider;
import grails.web.mime.MimeTypeResolver;
import grails.web.mime.MimeUtility;
import io.micronaut.context.BeanDefinitionRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.grails.web.mime.DefaultMimeTypeResolver;
import org.grails.web.mime.DefaultMimeUtility;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class MimeTypesConfiguration {
    private final GrailsApplication grailsApplication;
    private final ApplicationContext applicationContext;
    private final List<MimeTypeProvider> mimeTypeProviders;

    public MimeTypesConfiguration(GrailsApplication grailsApplication, List<MimeTypeProvider> mimeTypeProviders) {
        this.grailsApplication = grailsApplication;
        this.applicationContext = grailsApplication.getMainContext();
        this.mimeTypeProviders = mimeTypeProviders;
    }

    @Bean(value={"mimeTypesHolder"})
    @Primary
    MimeTypesHolder mimeTypesHolder(BeanDefinitionRegistry registry) {
        MimeType[] mimeTypes = this.mimeTypes();
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().registerSingleton("mimeTypes", (Object)mimeTypes);
        }
        return new MimeTypesHolder(mimeTypes);
    }

    @Bean(value={"mimeTypes"})
    @Primary
    protected MimeType[] mimeTypes() {
        Config config = this.grailsApplication.getConfig();
        Map<CharSequence, Object> mimeConfig = this.getMimeConfig(config);
        if (mimeConfig == null || mimeConfig.isEmpty()) {
            MimeType[] mimeTypes = MimeType.createDefaults();
            return mimeTypes;
        }
        ArrayList<MimeType> mimes = new ArrayList<MimeType>();
        for (Map.Entry<CharSequence, Object> entry : mimeConfig.entrySet()) {
            String key = entry.getKey().toString();
            Object v = entry.getValue();
            if (v instanceof List) {
                List list = (List)v;
                for (Object i : list) {
                    mimes.add(new MimeType(i.toString(), key));
                }
                continue;
            }
            mimes.add(new MimeType(v.toString(), key));
        }
        List<MimeTypeProvider> mimeTypeProviders = this.mimeTypeProviders;
        this.processProviders(mimes, mimeTypeProviders);
        Map childTypes = this.applicationContext.getBeansOfType(MimeTypeProvider.class);
        this.processProviders(mimes, childTypes.values());
        MimeType[] mimeTypes = mimes.toArray(new MimeType[0]);
        return mimeTypes;
    }

    @Bean(value={"grailsMimeUtility"})
    @Primary
    protected MimeUtility mimeUtility(MimeTypesHolder mimeTypesHolder) {
        return new DefaultMimeUtility(mimeTypesHolder.mimeTypes);
    }

    @Bean(value={"mimeTypeResolver"})
    @Primary
    protected MimeTypeResolver mimeTypeResolver() {
        return new DefaultMimeTypeResolver();
    }

    protected Map<CharSequence, Object> getMimeConfig(Config config) {
        return (Map)config.getProperty("grails.mime.types", Map.class);
    }

    private void processProviders(List<MimeType> mimes, Iterable<MimeTypeProvider> mimeTypeProviders) {
        for (MimeTypeProvider mimeTypeProvider : mimeTypeProviders) {
            for (MimeType mimeType : mimeTypeProvider.getMimeTypes()) {
                if (mimes.contains(mimeType)) continue;
                mimes.add(mimeType);
            }
        }
    }

    static class MimeTypesHolder {
        final MimeType[] mimeTypes;

        public MimeTypesHolder(MimeType[] mimeTypes) {
            this.mimeTypes = mimeTypes;
        }
    }
}

