/**
 * Append the old error message to the new one and keep its stack trace.
 * Example:
 *     throw wrap(e, HighLevelError, "This error is more specific");
 */
export function wrap(oldError: any, newErrorType: any, ...args: any[]): any;
/**
 * Base Error for when the bride can not handle the event.
 */
export class EventNotHandledError extends Error {
    constructor(...args: any[]);
    reason: string;
}
/**
 * The bridge decides that the event is too old to be sent.
 */
export class EventTooOldError extends EventNotHandledError {
    constructor(...args: any[]);
}
/**
 * An unexpected internal error occured while the bridge handled the event.
 */
export class BridgeInternalError extends EventNotHandledError {
    constructor(...args: any[]);
}
/**
 * The foreign network errored and the event couldn't be delivered.
 */
export class ForeignNetworkError extends EventNotHandledError {
    constructor(...args: any[]);
}
/**
 * The event is not understood by the bridge.
 */
export class EventUnknownError extends EventNotHandledError {
    constructor(...args: any[]);
}
