/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm;

import com.zaxxer.sansorm.OrmElf;
import com.zaxxer.sansorm.SqlClosure;
import com.zaxxer.sansorm.internal.OrmReader;
import com.zaxxer.sansorm.internal.OrmWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class SqlClosureElf {
    private SqlClosureElf() {
    }

    public static <T> T getObjectById(Class<T> type, Object ... ids) {
        return (T)SqlClosure.sqlExecute(c -> OrmElf.objectById(c, type, ids));
    }

    public static <T> T objectFromClause(Class<T> type, String clause, Object ... args2) {
        return (T)SqlClosure.sqlExecute(c -> OrmElf.objectFromClause(c, type, clause, args2));
    }

    public static <T> T insertObject(T object) {
        return (T)SqlClosure.sqlExecute(c -> OrmElf.insertObject(c, object));
    }

    public static <T> T updateObject(T object) {
        return (T)SqlClosure.sqlExecute(c -> OrmElf.updateObject(c, object));
    }

    public static <T> int deleteObject(T object) {
        return SqlClosure.sqlExecute(c -> OrmElf.deleteObject(c, object));
    }

    public static <T> int deleteObjectById(Class<T> clazz, Object ... args2) {
        return SqlClosure.sqlExecute(c -> OrmElf.deleteObjectById(c, clazz, args2));
    }

    public static <T> List<T> listFromClause(Class<T> clazz, String clause, Object ... args2) {
        return SqlClosure.sqlExecute(c -> OrmElf.listFromClause(c, clazz, clause, args2));
    }

    public static <T> int countObjectsFromClause(Class<T> clazz, String clause, Object ... args2) {
        return SqlClosure.sqlExecute(c -> OrmElf.countObjectsFromClause(c, clazz, clause, args2));
    }

    public static Number numberFromSql(String sql, Object ... args2) {
        return SqlClosure.sqlExecute(c -> SqlClosureElf.numberFromSql(c, sql, args2));
    }

    public static int executeUpdate(String sql, Object ... args2) {
        return SqlClosure.sqlExecute(c -> SqlClosureElf.executeUpdate(c, sql, args2));
    }

    @SafeVarargs
    public static <T> String getInClausePlaceholders(T ... items) {
        return SqlClosureElf.getInClausePlaceholdersForCount(items.length);
    }

    public static String getInClausePlaceholdersForCount(int placeholderCount) {
        if (placeholderCount < 0) {
            throw new IllegalArgumentException("Placeholder count must be greater than or equal to zero");
        }
        if (placeholderCount == 0) {
            return " ('s0me n0n-ex1st4nt v4luu') ";
        }
        StringBuilder sb = new StringBuilder(3 + placeholderCount * 2);
        sb.append(" (?");
        for (int i = 1; i < placeholderCount; ++i) {
            sb.append(",?");
        }
        return sb.append(") ").toString();
    }

    public static Number numberFromSql(Connection connection, String sql, Object ... args2) throws SQLException {
        return OrmReader.numberFromSql(connection, sql, args2);
    }

    public static ResultSet executeQuery(Connection connection, String sql, Object ... args2) throws SQLException {
        return OrmReader.statementToResultSet(connection.prepareStatement(sql), args2);
    }

    public static int executeUpdate(Connection connection, String sql, Object ... args2) throws SQLException {
        return OrmWriter.executeUpdate(connection, sql, args2);
    }
}

