/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.transaction;

import com.zaxxer.sansorm.transaction.TxThreadContext;
import com.zaxxer.sansorm.transaction.TxTransaction;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import javax.sql.DataSource;

class TxDataSource
implements InvocationHandler {
    private final DataSource delegate;

    private TxDataSource(DataSource delegate) {
        this.delegate = delegate;
    }

    static DataSource getWrappedDataSource(DataSource dataSource) {
        TxDataSource handler = new TxDataSource(dataSource);
        return (DataSource)Proxy.newProxyInstance(TxDataSource.class.getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        if ("getConnection".equals(method.getName())) {
            TxThreadContext context = TxThreadContext.getThreadContext();
            TxTransaction transaction = context.getTransaction();
            if (transaction != null && transaction.getConnection() != null && transaction.getStatus() == 0) {
                return transaction.getConnection();
            }
            Connection wrappedConnection = ConnectionProxy.getWrappedConnection(this.delegate.getConnection());
            if (transaction != null) {
                transaction.setConnection(wrappedConnection);
            }
            return wrappedConnection;
        }
        return method.invoke((Object)this.delegate, args2);
    }

    static class ConnectionProxy
    implements InvocationHandler {
        private final Connection delegate;

        private ConnectionProxy(Connection delegate) {
            this.delegate = delegate;
        }

        static Connection getWrappedConnection(Connection delegate) {
            ConnectionProxy handler = new ConnectionProxy(delegate);
            return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)handler);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            TxTransaction transaction = TxThreadContext.getThreadContext().getTransaction();
            if (transaction != null) {
                switch (method.getName()) {
                    case "close": {
                        return null;
                    }
                    case "commit": {
                        throw new IllegalStateException("Calling Connection.commit() is not legal during a transaction.");
                    }
                    case "rollback": {
                        throw new IllegalStateException("Calling Connection.commit() is not legal during a transaction.");
                    }
                }
            }
            return method.invoke((Object)this.delegate, args2);
        }
    }
}

