/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.model.Polyline;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;

public class ShapeTools {
    private static final Map<String, Shape> parsedShapes = new WeakHashMap<String, Shape>();

    private ShapeTools() {
    }

    public static Stroke getStroke(float f, Polyline.CapStyle capStyle, Polyline.JoinStyle joinStyle, float[] fArray, float f2) {
        int n;
        int n2;
        switch (capStyle) {
            case ROUND: {
                n2 = 1;
                break;
            }
            case SQUARE: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        switch (joinStyle) {
            case ROUND: 
            case CURVED: {
                n = 1;
                break;
            }
            case BEVEL: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        float f3 = 0.0f;
        if (fArray != null) {
            fArray = (float[])fArray.clone();
            for (int i = 0; i < fArray.length; ++i) {
                int n3 = i;
                fArray[n3] = fArray[n3] * f;
                f3 += fArray[i];
            }
            f3 *= f2;
        }
        return new BasicStroke(f, n2, n, 10.0f, fArray, f3);
    }

    public static Shape getPolylineShape(float[][] fArray, boolean bl, boolean bl2) {
        if (bl) {
            int n;
            GeneralPath generalPath = new GeneralPath();
            int n2 = n = bl2 ? fArray.length : fArray.length - 1;
            for (int i = 0; i < n; ++i) {
                CubicCurve2D.Float float_ = new CubicCurve2D.Float();
                float[] fArray2 = fArray[i == 0 ? fArray.length - 1 : i - 1];
                float[] fArray3 = fArray[i];
                float[] fArray4 = fArray[i == fArray.length - 1 ? 0 : i + 1];
                float[] fArray5 = new float[]{fArray4[0] - fArray2[0], fArray4[1] - fArray2[1]};
                float[] fArray6 = fArray[(i + 2) % fArray.length];
                float[] fArray7 = new float[]{fArray3[0] - fArray6[0], fArray3[1] - fArray6[1]};
                float_.setCurve(fArray3[0], fArray3[1], fArray3[0] + (i != 0 || bl2 ? fArray5[0] / 3.625f : 0.0f), fArray3[1] + (i != 0 || bl2 ? fArray5[1] / 3.625f : 0.0f), fArray4[0] + (i != fArray.length - 2 || bl2 ? fArray7[0] / 3.625f : 0.0f), fArray4[1] + (i != fArray.length - 2 || bl2 ? fArray7[1] / 3.625f : 0.0f), fArray4[0], fArray4[1]);
                generalPath.append(float_, true);
            }
            return generalPath;
        }
        return ShapeTools.getShape(fArray, bl2, null);
    }

    public static Shape getShape(float[][] fArray, boolean bl, AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        if (bl) {
            generalPath.closePath();
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public static Shape getShape(String string) {
        Shape shape = parsedShapes.get(string);
        if (shape == null) {
            try {
                shape = SVGPathSupport.parsePathShape(string);
            }
            catch (LinkageError linkageError) {
                shape = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
            }
            parsedShapes.put(string, shape);
        }
        return shape;
    }

    private static class SVGPathSupport {
        private SVGPathSupport() {
        }

        public static Shape parsePathShape(String string) {
            try {
                AWTPathProducer aWTPathProducer = new AWTPathProducer();
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler((PathHandler)aWTPathProducer);
                pathParser.parse(string);
                return aWTPathProducer.getShape();
            }
            catch (ParseException parseException) {
                return new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }
}

