/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.OBJWriter;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardStepsView;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ImportedFurnitureWizardStepsPanel
extends JPanel
implements ImportedFurnitureWizardStepsView {
    private final ImportedFurnitureWizardController controller;
    private CardLayout cardLayout;
    private JLabel modelChoiceOrChangeLabel;
    private JButton modelChoiceOrChangeButton;
    private JButton findModelsButton;
    private JLabel modelChoiceErrorLabel;
    private ModelPreviewComponent modelPreviewComponent;
    private JLabel orientationLabel;
    private JButton defaultOrientationButton;
    private JButton turnLeftButton;
    private JButton turnRightButton;
    private JButton turnUpButton;
    private JButton turnDownButton;
    private int horizontalAngle;
    private int verticalAngle;
    private JToolTip orientationToolTip;
    private JWindow orientationToolTipWindow;
    private RotationPreviewComponent rotationPreviewComponent;
    private JLabel backFaceShownLabel;
    private JCheckBox backFaceShownCheckBox;
    private JLabel attributesLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JCheckBox addToCatalogCheckBox;
    private JLabel categoryLabel;
    private JComboBox categoryComboBox;
    private JLabel creatorLabel;
    private JTextField creatorTextField;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel depthLabel;
    private JSpinner depthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox keepProportionsCheckBox;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private AttributesPreviewComponent attributesPreviewComponent;
    private JCheckBox movableCheckBox;
    private JCheckBox doorOrWindowCheckBox;
    private JCheckBox staircaseCheckBox;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private JButton clearColorButton;
    private JLabel iconLabel;
    private IconPreviewComponent iconPreviewComponent;
    private Cursor defaultCursor;
    private Executor modelLoader;

    public ImportedFurnitureWizardStepsPanel(CatalogPieceOfFurniture catalogPieceOfFurniture, String string, boolean bl, UserPreferences userPreferences, final ImportedFurnitureWizardController importedFurnitureWizardController) {
        this.controller = importedFurnitureWizardController;
        this.modelLoader = Executors.newSingleThreadExecutor();
        this.createComponents(bl, userPreferences, importedFurnitureWizardController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        this.updateController(catalogPieceOfFurniture, userPreferences);
        if (string != null) {
            this.updateController(string, userPreferences, importedFurnitureWizardController.getContentManager(), bl ? null : userPreferences.getFurnitureCatalog().getCategories().get(0), true);
        }
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.STEP, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.updateStep(importedFurnitureWizardController);
            }
        });
    }

    private void createComponents(boolean bl, final UserPreferences userPreferences, final ImportedFurnitureWizardController importedFurnitureWizardController) {
        String string;
        String string2 = userPreferences.getLengthUnit().getName();
        this.modelChoiceOrChangeLabel = new JLabel();
        this.modelChoiceOrChangeButton = new JButton();
        final FurnitureCategory furnitureCategory = bl || userPreferences.getFurnitureCatalog().getCategories().size() == 0 ? null : userPreferences.getFurnitureCatalog().getCategories().get(0);
        this.modelChoiceOrChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImportedFurnitureWizardStepsPanel.this.showModelChoiceDialog(userPreferences, importedFurnitureWizardController.getContentManager());
                if (string != null) {
                    ImportedFurnitureWizardStepsPanel.this.updateController(string, userPreferences, importedFurnitureWizardController.getContentManager(), furnitureCategory, false);
                }
            }
        });
        try {
            this.findModelsButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "findModelsButton.text", new Object[0]));
            string = userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsButton.url", new Object[0]);
            this.findModelsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    try {
                        bl = SwingTools.showDocumentInBrowser(new URL(string));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (!bl) {
                        JTextArea jTextArea = new JTextArea(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsMessage.text", new Object[0]));
                        String string2 = userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsMessage.title", new Object[0]);
                        jTextArea.setEditable(false);
                        jTextArea.setOpaque(false);
                        JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), jTextArea, string2, 1);
                    }
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.modelChoiceErrorLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceErrorLabel.text", new Object[0]));
        this.modelChoiceErrorLabel.setVisible(false);
        this.modelPreviewComponent = new ModelPreviewComponent(true);
        this.modelPreviewComponent.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(JComponent jComponent, Transferable transferable) {
                boolean bl = false;
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : list) {
                        final String string = file.getAbsolutePath();
                        if (!importedFurnitureWizardController.getContentManager().isAcceptable(string, ContentManager.ContentType.MODEL)) continue;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImportedFurnitureWizardStepsPanel.this.updateController(string, userPreferences, importedFurnitureWizardController.getContentManager(), furnitureCategory, false);
                            }
                        });
                        bl = true;
                        break;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceErrorLabel.text", new Object[0]));
                        }
                    });
                }
                return bl;
            }
        });
        this.modelPreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
        this.orientationLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "orientationLabel.text", new Object[0]));
        this.defaultOrientationButton = new JButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "DEFAULT_ORIENTATION", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(new Transform3D());
                ImportedFurnitureWizardStepsPanel.this.horizontalAngle = 0;
                ImportedFurnitureWizardStepsPanel.this.verticalAngle = 0;
            }
        });
        string = userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "angleTooltipFeedback", new Object[0]);
        this.orientationToolTip = new JToolTip();
        this.turnLeftButton = new AutoRepeatButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_LEFT", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                int n = (actionEvent.getModifiers() & 1) == 0 ? -90 : -1;
                transform3D2.rotY(Math.toRadians(n));
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
                ImportedFurnitureWizardStepsPanel.this.horizontalAngle = (ImportedFurnitureWizardStepsPanel.this.horizontalAngle + n) % 360;
                ImportedFurnitureWizardStepsPanel.this.orientationToolTip.setTipText(String.format(string, ImportedFurnitureWizardStepsPanel.this.horizontalAngle));
                ImportedFurnitureWizardStepsPanel.this.verticalAngle = 0;
            }
        });
        this.turnRightButton = new AutoRepeatButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_RIGHT", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                int n = (actionEvent.getModifiers() & 1) == 0 ? 90 : 1;
                transform3D2.rotY(Math.toRadians(n));
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
                ImportedFurnitureWizardStepsPanel.this.horizontalAngle = (ImportedFurnitureWizardStepsPanel.this.horizontalAngle + n) % 360;
                ImportedFurnitureWizardStepsPanel.this.orientationToolTip.setTipText(String.format(string, ImportedFurnitureWizardStepsPanel.this.horizontalAngle));
                ImportedFurnitureWizardStepsPanel.this.verticalAngle = 0;
            }
        });
        this.turnUpButton = new AutoRepeatButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_UP", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                int n = (actionEvent.getModifiers() & 1) == 0 ? -90 : -1;
                transform3D2.rotX(Math.toRadians(n));
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
                ImportedFurnitureWizardStepsPanel.this.verticalAngle = (ImportedFurnitureWizardStepsPanel.this.verticalAngle + n) % 360;
                ImportedFurnitureWizardStepsPanel.this.orientationToolTip.setTipText(String.format(string, ImportedFurnitureWizardStepsPanel.this.verticalAngle));
                ImportedFurnitureWizardStepsPanel.this.horizontalAngle = 0;
            }
        });
        this.turnDownButton = new AutoRepeatButton(new ResourceAction(userPreferences, ImportedFurnitureWizardStepsPanel.class, "TURN_DOWN", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Transform3D transform3D = ImportedFurnitureWizardStepsPanel.this.getModelRotationTransform();
                Transform3D transform3D2 = new Transform3D();
                int n = (actionEvent.getModifiers() & 1) == 0 ? 90 : 1;
                transform3D2.rotX(Math.toRadians(n));
                transform3D2.mul(transform3D);
                ImportedFurnitureWizardStepsPanel.this.updateModelRotation(transform3D2);
                ImportedFurnitureWizardStepsPanel.this.verticalAngle = (ImportedFurnitureWizardStepsPanel.this.verticalAngle + n) % 360;
                ImportedFurnitureWizardStepsPanel.this.orientationToolTip.setTipText(String.format(string, ImportedFurnitureWizardStepsPanel.this.verticalAngle));
                ImportedFurnitureWizardStepsPanel.this.horizontalAngle = 0;
            }
        });
        this.backFaceShownLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "backFaceShownLabel.text", new Object[0]));
        this.backFaceShownCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "backFaceShownCheckBox.text", new Object[0]));
        this.backFaceShownCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setBackFaceShown(ImportedFurnitureWizardStepsPanel.this.backFaceShownCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.backFaceShownCheckBox.setSelected(importedFurnitureWizardController.isBackFaceShown());
            }
        });
        this.rotationPreviewComponent = new RotationPreviewComponent(userPreferences, importedFurnitureWizardController);
        this.attributesLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "attributesLabel.text", new Object[0]));
        this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "nameLabel.text", new Object[0]));
        this.nameTextField = new JTextField(10);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
        }
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ImportedFurnitureWizardStepsPanel.this.nameTextField.getDocument().removeDocumentListener(this);
                importedFurnitureWizardController.setName(ImportedFurnitureWizardStepsPanel.this.nameTextField.getText().trim());
                ImportedFurnitureWizardStepsPanel.this.nameTextField.getDocument().addDocumentListener(this);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.NAME, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ImportedFurnitureWizardStepsPanel.this.nameTextField.getText().trim().equals(importedFurnitureWizardController.getName())) {
                    ImportedFurnitureWizardStepsPanel.this.nameTextField.setText(importedFurnitureWizardController.getName());
                }
            }
        });
        this.addToCatalogCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "addToCatalogCheckBox.text", new Object[0]));
        this.addToCatalogCheckBox.setVisible(bl);
        this.addToCatalogCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ImportedFurnitureWizardStepsPanel.this.addToCatalogCheckBox.isSelected()) {
                    ImportedFurnitureWizardStepsPanel.this.categoryComboBox.setEnabled(true);
                    importedFurnitureWizardController.setCategory((FurnitureCategory)ImportedFurnitureWizardStepsPanel.this.categoryComboBox.getSelectedItem());
                } else {
                    ImportedFurnitureWizardStepsPanel.this.categoryComboBox.setEnabled(false);
                    importedFurnitureWizardController.setCategory(null);
                }
            }
        });
        this.categoryLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "categoryLabel.text", new Object[0]));
        this.categoryComboBox = new JComboBox<Object>(userPreferences.getFurnitureCatalog().getCategories().toArray());
        this.categoryComboBox.setEnabled(!bl);
        this.categoryComboBox.setEditable(true);
        final ComboBoxEditor comboBoxEditor = this.categoryComboBox.getEditor();
        this.categoryComboBox.setEditor(new ComboBoxEditor(){

            @Override
            public Object getItem() {
                String string = (String)comboBoxEditor.getItem();
                if ((string = string.trim()).length() == 0) {
                    Object object = ImportedFurnitureWizardStepsPanel.this.categoryComboBox.getSelectedItem();
                    this.setItem(object);
                    return object;
                }
                FurnitureCategory furnitureCategory = new FurnitureCategory(string);
                List<FurnitureCategory> list = userPreferences.getFurnitureCatalog().getCategories();
                int n = Collections.binarySearch(list, furnitureCategory);
                if (n >= 0) {
                    return list.get(n);
                }
                return furnitureCategory;
            }

            @Override
            public void setItem(Object object) {
                if (object != null) {
                    FurnitureCategory furnitureCategory = (FurnitureCategory)object;
                    comboBoxEditor.setItem(furnitureCategory.getName());
                }
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
                comboBoxEditor.addActionListener(actionListener);
            }

            @Override
            public Component getEditorComponent() {
                return comboBoxEditor.getEditorComponent();
            }

            @Override
            public void removeActionListener(ActionListener actionListener) {
                comboBoxEditor.removeActionListener(actionListener);
            }

            @Override
            public void selectAll() {
                comboBoxEditor.selectAll();
            }
        });
        this.categoryComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                FurnitureCategory furnitureCategory = (FurnitureCategory)object;
                return super.getListCellRendererComponent((JList<?>)jList, furnitureCategory.getName(), n, bl, bl2);
            }
        });
        this.categoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setCategory((FurnitureCategory)itemEvent.getItem());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.CATEGORY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureCategory furnitureCategory = importedFurnitureWizardController.getCategory();
                if (furnitureCategory != null) {
                    ImportedFurnitureWizardStepsPanel.this.categoryComboBox.setSelectedItem(furnitureCategory);
                }
            }
        });
        if (this.categoryComboBox.getItemCount() > 0) {
            this.categoryComboBox.setSelectedIndex(0);
        }
        this.creatorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "creatorLabel.text", new Object[0]));
        this.creatorTextField = new JTextField(10);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.creatorTextField);
        }
        DocumentListener documentListener2 = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ImportedFurnitureWizardStepsPanel.this.creatorTextField.getDocument().removeDocumentListener(this);
                importedFurnitureWizardController.setCreator(ImportedFurnitureWizardStepsPanel.this.creatorTextField.getText().trim());
                ImportedFurnitureWizardStepsPanel.this.creatorTextField.getDocument().addDocumentListener(this);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.creatorTextField.getDocument().addDocumentListener(documentListener2);
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.CREATOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ImportedFurnitureWizardStepsPanel.this.creatorTextField.getText().trim().equals(importedFurnitureWizardController.getCreator())) {
                    ImportedFurnitureWizardStepsPanel.this.creatorTextField.setText(importedFurnitureWizardController.getCreator());
                }
            }
        });
        this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "widthLabel.text", string2));
        final float f = userPreferences.getLengthUnit().getMinimumLength();
        float f2 = userPreferences.getLengthUnit().getMaximumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, Math.min(importedFurnitureWizardController.getWidth(), f), f2);
        this.widthSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel.removeChangeListener(this);
                importedFurnitureWizardController.setWidth(nullableSpinnerLengthModel.getLength().floatValue());
                nullableSpinnerLengthModel.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.WIDTH, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength(Float.valueOf(importedFurnitureWizardController.getWidth()));
                nullableSpinnerLengthModel.setMinimumLength(Math.min(importedFurnitureWizardController.getWidth(), f));
            }
        });
        this.depthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "depthLabel.text", string2));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, Math.min(importedFurnitureWizardController.getDepth(), f), f2);
        this.depthSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel2.removeChangeListener(this);
                importedFurnitureWizardController.setDepth(nullableSpinnerLengthModel2.getLength().floatValue());
                nullableSpinnerLengthModel2.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.DEPTH, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength(Float.valueOf(importedFurnitureWizardController.getDepth()));
                nullableSpinnerLengthModel2.setMinimumLength(Math.min(importedFurnitureWizardController.getDepth(), f));
            }
        });
        this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "heightLabel.text", string2));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, Math.min(importedFurnitureWizardController.getHeight(), f), f2);
        this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel3.removeChangeListener(this);
                importedFurnitureWizardController.setHeight(nullableSpinnerLengthModel3.getLength().floatValue());
                nullableSpinnerLengthModel3.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.HEIGHT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setLength(Float.valueOf(importedFurnitureWizardController.getHeight()));
                nullableSpinnerLengthModel3.setMinimumLength(Math.min(importedFurnitureWizardController.getHeight(), f));
            }
        });
        this.keepProportionsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.text", new Object[0]));
        this.keepProportionsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setProportional(ImportedFurnitureWizardStepsPanel.this.keepProportionsCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.PROPORTIONAL, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.keepProportionsCheckBox.setSelected(importedFurnitureWizardController.isProportional());
            }
        });
        this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "elevationLabel.text", string2));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, userPreferences.getLengthUnit().getMaximumElevation());
        this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel4);
        nullableSpinnerLengthModel4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel4.removeChangeListener(this);
                importedFurnitureWizardController.setElevation(nullableSpinnerLengthModel4.getLength().floatValue());
                nullableSpinnerLengthModel4.addChangeListener(this);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.ELEVATION, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel4.setLength(Float.valueOf(importedFurnitureWizardController.getElevation()));
            }
        });
        this.movableCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "movableCheckBox.text", new Object[0]));
        this.movableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setMovable(ImportedFurnitureWizardStepsPanel.this.movableCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MOVABLE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.movableCheckBox.setSelected(importedFurnitureWizardController.isMovable());
            }
        });
        this.doorOrWindowCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "doorOrWindowCheckBox.text", new Object[0]));
        this.doorOrWindowCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setDoorOrWindow(ImportedFurnitureWizardStepsPanel.this.doorOrWindowCheckBox.isSelected());
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.DOOR_OR_WINDOW, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = importedFurnitureWizardController.isDoorOrWindow();
                ImportedFurnitureWizardStepsPanel.this.doorOrWindowCheckBox.setSelected(bl);
                ImportedFurnitureWizardStepsPanel.this.movableCheckBox.setEnabled(!bl && importedFurnitureWizardController.getStaircaseCutOutShape() == null);
            }
        });
        this.staircaseCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "staircaseCheckBox.text", new Object[0]));
        this.staircaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                importedFurnitureWizardController.setStaircaseCutOutShape(ImportedFurnitureWizardStepsPanel.this.staircaseCheckBox.isSelected() ? "M0,0 v1 h1 v-1 z" : null);
            }
        });
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.STAIRCASE_CUT_OUT_SHAPE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = importedFurnitureWizardController.getStaircaseCutOutShape();
                ImportedFurnitureWizardStepsPanel.this.staircaseCheckBox.setSelected(string != null);
                ImportedFurnitureWizardStepsPanel.this.movableCheckBox.setEnabled(!importedFurnitureWizardController.isDoorOrWindow() && string == null);
            }
        });
        this.colorLabel = new JLabel(String.format(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "colorLabel.text", new Object[0]), string2));
        this.colorButton = new ColorButton(userPreferences);
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                importedFurnitureWizardController.setColor(ImportedFurnitureWizardStepsPanel.this.colorButton.getColor());
            }
        });
        this.clearColorButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "clearColorButton.text", new Object[0]));
        this.clearColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                importedFurnitureWizardController.setColor(null);
            }
        });
        this.clearColorButton.setEnabled(false);
        importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedFurnitureWizardStepsPanel.this.colorButton.setColor(importedFurnitureWizardController.getColor());
                ImportedFurnitureWizardStepsPanel.this.clearColorButton.setEnabled(importedFurnitureWizardController.getColor() != null);
            }
        });
        this.attributesPreviewComponent = new AttributesPreviewComponent(importedFurnitureWizardController);
        this.iconLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "iconLabel.text", new Object[0]));
        this.iconPreviewComponent = new IconPreviewComponent(this.controller);
    }

    private void showOrientationToolTip() {
        if (this.orientationToolTipWindow == null) {
            this.orientationToolTipWindow = new JWindow(SwingUtilities.getWindowAncestor(this));
            this.orientationToolTipWindow.setFocusableWindowState(false);
            this.orientationToolTipWindow.add(this.orientationToolTip);
        } else {
            this.orientationToolTip.revalidate();
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        Dimension dimension = this.getToolkit().getBestCursorSize(16, 16);
        if (dimension.width != 0) {
            point.x += dimension.width + 2;
            point.y += dimension.height + 2;
        } else {
            point.x += 18;
            point.y += 18;
        }
        this.orientationToolTipWindow.setLocation(point);
        this.orientationToolTipWindow.pack();
        this.orientationToolTipWindow.setVisible(true);
        this.orientationToolTip.paintImmediately(this.orientationToolTip.getBounds());
    }

    private void deleteOrientationToolTip() {
        if (this.orientationToolTipWindow != null) {
            this.orientationToolTipWindow.setVisible(false);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.findModelsButton != null) {
                this.findModelsButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "findModelsButton.mnemonic", new Object[0])).getKeyCode());
            }
            this.backFaceShownCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "backFaceShownCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setLabelFor(this.nameTextField);
            this.addToCatalogCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "addToCatalogCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.categoryLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "categoryLabel.mnemonic", new Object[0])).getKeyCode());
            this.categoryLabel.setLabelFor(this.categoryComboBox);
            this.creatorLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "creatorLabel.mnemonic", new Object[0])).getKeyCode());
            this.creatorLabel.setLabelFor(this.creatorTextField);
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.depthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "depthLabel.mnemonic", new Object[0])).getKeyCode());
            this.depthLabel.setLabelFor(this.depthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
            this.keepProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setLabelFor(this.elevationSpinner);
            this.movableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "movableCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.doorOrWindowCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "doorOrWindowCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.staircaseCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "staircaseCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.colorLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "colorLabel.mnemonic", new Object[0])).getKeyCode());
            this.colorLabel.setLabelFor(this.colorButton);
            this.clearColorButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "clearColorButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents() {
        Serializable serializable;
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        int n = Math.round(5.0f * SwingTools.getResolutionScale());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.modelChoiceOrChangeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(n, 0, n, 0), 0, 0));
        if (this.findModelsButton != null) {
            jPanel.add((Component)this.modelChoiceOrChangeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 22, 0, new Insets(0, 0, 0, 10), 0, 0));
            jPanel.add((Component)this.findModelsButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            jPanel.add((Component)this.modelChoiceOrChangeButton, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        jPanel.add((Component)this.modelChoiceErrorLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(n, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.modelPreviewComponent, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 10, 0, new Insets(n, 0, n, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.orientationLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(n, 0, n, 0), 0, 0));
        jPanel2.add((Component)this.rotationPreviewComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 22, 0, new Insets(0, 0, n, 15), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout()){

            @Override
            public void applyComponentOrientation(ComponentOrientation componentOrientation) {
            }
        };
        if (!OperatingSystem.isMacOSX()) {
            serializable = this.turnUpButton.getPreferredSize();
            ((Dimension)serializable).width = ((Dimension)serializable).height += 4;
            this.turnUpButton.setPreferredSize((Dimension)serializable);
            this.turnLeftButton.setPreferredSize((Dimension)serializable);
            this.turnRightButton.setPreferredSize((Dimension)serializable);
            this.turnDownButton.setPreferredSize((Dimension)serializable);
            this.defaultOrientationButton.setPreferredSize((Dimension)serializable);
        }
        jPanel3.add((Component)this.turnUpButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, n, 0), 0, 0));
        jPanel3.add((Component)this.turnLeftButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, n, n), 0, 0));
        jPanel3.add((Component)this.defaultOrientationButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, n, 0), 0, 0));
        jPanel3.add((Component)this.turnRightButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, n, n, 0), 0, 0));
        jPanel3.add((Component)this.turnDownButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, n, 0), 0, 0));
        jPanel2.add((Component)jPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
        jPanel2.add((Component)this.backFaceShownLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(n, 0, n, 0), 0, 0));
        jPanel2.add((Component)this.backFaceShownCheckBox, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, n, 0), 0, 0));
        serializable = new JPanel(new GridBagLayout());
        ((Container)serializable).add(this.attributesLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(n, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.attributesPreviewComponent, new GridBagConstraints(0, 1, 1, 14, 1.0, 0.0, 10, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.nameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.nameTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.addToCatalogCheckBox, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.categoryLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.categoryComboBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.creatorLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.creatorTextField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.widthLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.widthSpinner, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.depthLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.depthSpinner, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.heightLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.heightSpinner, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.keepProportionsCheckBox, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
        ((Container)serializable).add(this.elevationLabel, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.elevationSpinner, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.movableCheckBox, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.doorOrWindowCheckBox, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.staircaseCheckBox, new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.colorLabel, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
        ((Container)serializable).add(this.colorButton, new GridBagConstraints(2, 13, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(this.clearColorButton, new GridBagConstraints(2, 14, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n, 0), 0, 0));
        ((Container)serializable).add(new JLabel(), new GridBagConstraints(1, 15, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(n, 0, n, 0), 0, 0));
        jPanel4.add((Component)this.iconPreviewComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(n, 0, n, 0), 0, 0));
        this.add((Component)jPanel, ImportedFurnitureWizardController.Step.MODEL.name());
        this.add((Component)jPanel2, ImportedFurnitureWizardController.Step.ROTATION.name());
        this.add((Component)serializable, ImportedFurnitureWizardController.Step.ATTRIBUTES.name());
        this.add((Component)jPanel4, ImportedFurnitureWizardController.Step.ICON.name());
    }

    private void updateStep(ImportedFurnitureWizardController importedFurnitureWizardController) {
        ImportedFurnitureWizardController.Step step = importedFurnitureWizardController.getStep();
        this.cardLayout.show(this, step.name());
        switch (step) {
            case MODEL: {
                this.modelChoiceOrChangeButton.requestFocusInWindow();
                break;
            }
            case ATTRIBUTES: {
                this.nameTextField.requestFocusInWindow();
            }
        }
    }

    private Transform3D getModelRotationTransform() {
        float[][] fArray = this.controller.getModelRotation();
        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
        Transform3D transform3D = new Transform3D();
        transform3D.setRotation(matrix3f);
        return transform3D;
    }

    private void updateModelRotation(Transform3D transform3D) {
        Matrix3f matrix3f = new Matrix3f();
        transform3D.getRotationScale(matrix3f);
        this.controller.setModelRotation(new float[][]{{matrix3f.m00, matrix3f.m01, matrix3f.m02}, {matrix3f.m10, matrix3f.m11, matrix3f.m12}, {matrix3f.m20, matrix3f.m21, matrix3f.m22}});
    }

    private void updateController(final CatalogPieceOfFurniture catalogPieceOfFurniture, final UserPreferences userPreferences) {
        this.updatePreviewComponentsModel(null);
        if (catalogPieceOfFurniture == null) {
            this.setModelChoiceTexts(userPreferences);
        } else {
            this.setModelChangeTexts(userPreferences);
            this.setReadingState();
            ModelManager.getInstance().loadModel(catalogPieceOfFurniture.getModel(), new ModelManager.ModelObserver(){

                @Override
                public void modelUpdated(BranchGroup branchGroup) {
                    ImportedFurnitureWizardStepsPanel.this.updatePreviewComponentsModel(catalogPieceOfFurniture.getModel());
                    ImportedFurnitureWizardStepsPanel.this.setDefaultState();
                    ImportedFurnitureWizardStepsPanel.this.controller.setModel(catalogPieceOfFurniture.getModel());
                    ImportedFurnitureWizardStepsPanel.this.controller.setModelSize(catalogPieceOfFurniture.getModelSize());
                    ImportedFurnitureWizardStepsPanel.this.controller.setModelRotation(catalogPieceOfFurniture.getModelRotation());
                    ImportedFurnitureWizardStepsPanel.this.controller.setBackFaceShown(catalogPieceOfFurniture.isBackFaceShown());
                    ImportedFurnitureWizardStepsPanel.this.controller.setName(catalogPieceOfFurniture.getName());
                    ImportedFurnitureWizardStepsPanel.this.controller.setCreator(catalogPieceOfFurniture.getCreator());
                    ImportedFurnitureWizardStepsPanel.this.controller.setCategory(catalogPieceOfFurniture.getCategory());
                    ImportedFurnitureWizardStepsPanel.this.controller.setWidth(catalogPieceOfFurniture.getWidth());
                    ImportedFurnitureWizardStepsPanel.this.controller.setDepth(catalogPieceOfFurniture.getDepth());
                    ImportedFurnitureWizardStepsPanel.this.controller.setHeight(catalogPieceOfFurniture.getHeight());
                    ImportedFurnitureWizardStepsPanel.this.controller.setMovable(catalogPieceOfFurniture.isMovable());
                    ImportedFurnitureWizardStepsPanel.this.controller.setDoorOrWindow(catalogPieceOfFurniture.isDoorOrWindow());
                    ImportedFurnitureWizardStepsPanel.this.controller.setStaircaseCutOutShape(catalogPieceOfFurniture.getStaircaseCutOutShape());
                    ImportedFurnitureWizardStepsPanel.this.controller.setElevation(catalogPieceOfFurniture.getElevation());
                    ImportedFurnitureWizardStepsPanel.this.controller.setColor(catalogPieceOfFurniture.getColor());
                    ImportedFurnitureWizardStepsPanel.this.controller.setIconYaw(catalogPieceOfFurniture.getIconYaw());
                    ImportedFurnitureWizardStepsPanel.this.controller.setProportional(catalogPieceOfFurniture.isProportional());
                }

                @Override
                public void modelError(Exception exception) {
                    ImportedFurnitureWizardStepsPanel.this.controller.setModel(null);
                    ImportedFurnitureWizardStepsPanel.this.setModelChoiceTexts(userPreferences);
                    ImportedFurnitureWizardStepsPanel.this.modelChoiceErrorLabel.setVisible(true);
                    if (ImportedFurnitureWizardStepsPanel.this.isShowing()) {
                        SwingUtilities.getWindowAncestor(ImportedFurnitureWizardStepsPanel.this.modelChoiceErrorLabel).pack();
                    }
                    ImportedFurnitureWizardStepsPanel.this.setDefaultState();
                }
            });
        }
    }

    private void updateController(final String string, final UserPreferences userPreferences, final ContentManager contentManager, final FurnitureCategory furnitureCategory, final boolean bl) {
        this.controller.setModel(null);
        this.updatePreviewComponentsModel(null);
        this.setReadingState();
        this.modelLoader.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block37: {
                    Content content = null;
                    try {
                        content = contentManager.getContent(string);
                    }
                    catch (RecorderException recorderException) {
                        ImportedFurnitureWizardStepsPanel.this.setDefaultStateAndShowModelChoiceError(string, userPreferences, !bl);
                    }
                    try {
                        BranchGroup branchGroup = ModelManager.getInstance().loadModel(content);
                        final Vector3f vector3f = ModelManager.getInstance().getSize((Node)branchGroup);
                        final Content content2 = ImportedFurnitureWizardStepsPanel.this.copyToTemporaryOBJContent(branchGroup, string);
                        ModelManager.getInstance().loadModel(content2, true, new ModelManager.ModelObserver(){

                            @Override
                            public void modelUpdated(BranchGroup branchGroup) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ImportedFurnitureWizardStepsPanel.this.setDefaultStateAndInitializeReadModel(content2, string, furnitureCategory, vector3f, userPreferences, contentManager);
                                    }
                                });
                            }

                            @Override
                            public void modelError(Exception exception) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ImportedFurnitureWizardStepsPanel.this.setDefaultStateAndShowModelChoiceError(string, userPreferences, !bl);
                                    }
                                });
                            }
                        });
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        content = TemporaryURLContent.copyToTemporaryURLContent(content);
                    }
                    catch (IOException iOException) {
                        ImportedFurnitureWizardStepsPanel.this.setDefaultStateAndShowModelChoiceError(string, userPreferences, !bl);
                        return;
                    }
                    ZipInputStream zipInputStream = null;
                    try {
                        AtomicReference atomicReference;
                        TemporaryURLContent temporaryURLContent;
                        URLContent uRLContent = (URLContent)content;
                        zipInputStream = new ZipInputStream(uRLContent.openStream());
                        while (true) {
                            String string3;
                            ZipEntry zipEntry;
                            try {
                                zipEntry = zipInputStream.getNextEntry();
                                if (zipEntry == null) {
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            break block37;
                            String string2 = zipEntry.getName();
                            if (string2.endsWith("/")) continue;
                            int n = string2.lastIndexOf(47);
                            if ((string3 = string2.substring(++n)).startsWith(".")) continue;
                            URL uRL = new URL("jar:" + uRLContent.getURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20").replace("%2F", "/"));
                            temporaryURLContent = new TemporaryURLContent(uRL);
                            atomicReference = new AtomicReference();
                            ModelManager.getInstance().loadModel(temporaryURLContent, true, new ModelManager.ModelObserver(){

                                @Override
                                public void modelUpdated(BranchGroup branchGroup) {
                                    try {
                                        atomicReference.set(ModelManager.getInstance().getSize((Node)branchGroup));
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        // empty catch block
                                    }
                                }

                                @Override
                                public void modelError(Exception exception) {
                                }
                            });
                            if (atomicReference.get() == null) continue;
                            do {
                                try {
                                    zipEntry = zipInputStream.getNextEntry();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    break;
                                }
                            } while (zipEntry != null);
                            if (zipEntry == null) break;
                        }
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ImportedFurnitureWizardStepsPanel.this.setDefaultStateAndInitializeReadModel(temporaryURLContent, string, furnitureCategory, (Vector3f)atomicReference.get(), userPreferences, contentManager);
                            }
                        });
                        return;
                    }
                    catch (IOException iOException) {
                        ImportedFurnitureWizardStepsPanel.this.setDefaultStateAndShowModelChoiceError(string, userPreferences, !bl);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        ImportedFurnitureWizardStepsPanel.this.setDefaultState();
                        return;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        try {
                            if (zipInputStream != null) {
                                zipInputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    finally {
                        try {
                            if (zipInputStream != null) {
                                zipInputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ImportedFurnitureWizardStepsPanel.this.isShowing()) {
                            ImportedFurnitureWizardStepsPanel.this.setDefaultState();
                            ImportedFurnitureWizardStepsPanel.this.setModelChoiceTexts(userPreferences);
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceFormatError", new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private void setDefaultStateAndInitializeReadModel(Content content, String string, FurnitureCategory furnitureCategory, Vector3f vector3f, UserPreferences userPreferences, ContentManager contentManager) {
        this.setDefaultState();
        this.updatePreviewComponentsModel(content);
        this.controller.setModel(content);
        this.controller.setModelSize(content instanceof URLContent ? Long.valueOf(((URLContent)content).getSize()) : null);
        this.setModelChangeTexts(userPreferences);
        this.modelChoiceErrorLabel.setVisible(false);
        this.controller.setModelRotation(new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
        this.controller.setBackFaceShown(false);
        this.controller.setName(contentManager.getPresentationName(string, ContentManager.ContentType.MODEL));
        this.controller.setCreator(null);
        this.controller.setCategory(furnitureCategory);
        this.controller.setWidth(vector3f.x);
        this.controller.setDepth(vector3f.z);
        this.controller.setHeight(vector3f.y);
        this.controller.setMovable(true);
        this.controller.setDoorOrWindow(false);
        this.controller.setStaircaseCutOutShape(null);
        this.controller.setColor(null);
        this.controller.setIconYaw(0.3926991f);
        this.controller.setProportional(true);
    }

    private void setDefaultStateAndShowModelChoiceError(final String string, final UserPreferences userPreferences, boolean bl) {
        this.setDefaultState();
        if (bl) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedFurnitureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceError", string));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content copyToTemporaryOBJContent(BranchGroup branchGroup, String string) throws IOException {
        try {
            this.setReadingState();
            String string2 = new File(string).getName();
            if (!string2.toLowerCase().endsWith(".obj")) {
                string2 = string2 + ".obj";
            }
            if (string2.matches(".*[^a-zA-Z0-9_\\.\\-\\ ].*")) {
                string2 = "model.obj";
            }
            File file = OperatingSystem.createTemporaryFile("import", ".zip");
            OBJWriter.writeNodeInZIPFile((Node)branchGroup, file, 0, string2, "3D model import " + string);
            TemporaryURLContent temporaryURLContent = new TemporaryURLContent(new URL("jar:" + file.toURI().toURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20")));
            return temporaryURLContent;
        }
        finally {
            this.setDefaultState();
        }
    }

    private void setReadingState() {
        this.modelChoiceOrChangeButton.setEnabled(false);
        Component component = SwingUtilities.getRoot(this);
        if (component != null) {
            if (this.defaultCursor == null) {
                this.defaultCursor = component.getCursor();
            }
            component.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    ImportedFurnitureWizardStepsPanel.this.removeAncestorListener(this);
                    if (!ImportedFurnitureWizardStepsPanel.this.modelChoiceOrChangeButton.isEnabled()) {
                        ImportedFurnitureWizardStepsPanel.this.setReadingState();
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        }
    }

    private void setDefaultState() {
        if (EventQueue.isDispatchThread()) {
            this.modelChoiceOrChangeButton.setEnabled(true);
            Component component = SwingUtilities.getRoot(this);
            if (component != null) {
                component.setCursor(this.defaultCursor);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportedFurnitureWizardStepsPanel.this.setDefaultState();
                }
            });
        }
    }

    private void updatePreviewComponentsModel(Content content) {
        this.modelPreviewComponent.setModel(content);
        this.rotationPreviewComponent.setModel(content);
        this.attributesPreviewComponent.setModel(content);
        this.iconPreviewComponent.setModel(content);
    }

    private void setModelChangeTexts(UserPreferences userPreferences) {
        this.modelChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChangeLabel.text", new Object[0]));
        this.modelChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "modelChangeButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.modelChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChangeButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void setModelChoiceTexts(UserPreferences userPreferences) {
        this.modelChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceLabel.text", new Object[0]));
        this.modelChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "modelChoiceButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.modelChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private String showModelChoiceDialog(UserPreferences userPreferences, ContentManager contentManager) {
        return contentManager.showOpenDialog(this, userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "modelChoiceDialog.title", new Object[0]), ContentManager.ContentType.MODEL);
    }

    @Override
    public Content getIcon() {
        try {
            return this.iconPreviewComponent.getIcon(400);
        }
        catch (IOException iOException) {
            try {
                return new URLContent(new URL("file:/dummySweetHome3DContent"));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    private class AutoRepeatButton
    extends JButton {
        private boolean shiftPressed;

        public AutoRepeatButton(final Action action) {
            super(action);
            final Timer timer = new Timer(40, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    action.actionPerformed(new ActionEvent(this, 1001, null, actionEvent.getWhen(), 1));
                    ImportedFurnitureWizardStepsPanel.this.showOrientationToolTip();
                }
            });
            timer.setInitialDelay(250);
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (AutoRepeatButton.this.shiftPressed) {
                                if (AutoRepeatButton.this.getModel().isArmed() && !timer.isRunning()) {
                                    timer.restart();
                                } else if (!AutoRepeatButton.this.getModel().isArmed() && timer.isRunning()) {
                                    timer.stop();
                                }
                            }
                        }
                    });
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    AutoRepeatButton.this.shiftPressed = mouseEvent.isShiftDown();
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ImportedFurnitureWizardStepsPanel.this.showOrientationToolTip();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ImportedFurnitureWizardStepsPanel.this.deleteOrientationToolTip();
                            ((Timer)actionEvent.getSource()).stop();
                        }
                    }).start();
                }
            });
        }
    }

    private static class RotationPreviewComponent
    extends JPanel {
        private static final int COMPONENT_PREFERRED_WIDTH = Math.round(200.0f * SwingTools.getResolutionScale());
        private ModelPreviewComponent perspectiveViewComponent3D;
        private JLabel frontViewLabel;
        private ModelPreviewComponent frontViewComponent3D;
        private JLabel sideViewLabel;
        private ModelPreviewComponent sideViewComponent3D;
        private JLabel topViewLabel;
        private ModelPreviewComponent topViewComponent3D;
        private JLabel perspectiveViewLabel;
        private BranchGroup modelNode;

        public RotationPreviewComponent(UserPreferences userPreferences, ImportedFurnitureWizardController importedFurnitureWizardController) {
            this.createComponents(userPreferences, importedFurnitureWizardController);
            this.layoutComponents();
        }

        public void setModel(Content content) {
            this.perspectiveViewComponent3D.setModel(content);
            this.frontViewComponent3D.setModel(content);
            this.sideViewComponent3D.setModel(content);
            this.topViewComponent3D.setModel(content);
        }

        private void createComponents(UserPreferences userPreferences, ImportedFurnitureWizardController importedFurnitureWizardController) {
            Color color = new Color(0xE5E5E5);
            this.perspectiveViewComponent3D = new ModelPreviewComponent(true);
            this.perspectiveViewComponent3D.setBackground(color);
            this.addRotationListener(this.perspectiveViewComponent3D, importedFurnitureWizardController, true);
            this.frontViewComponent3D = new ModelPreviewComponent(false, false, false);
            this.frontViewComponent3D.setViewYaw(0.0f);
            this.frontViewComponent3D.setViewPitch(0.0f);
            this.frontViewComponent3D.setParallelProjection(true);
            this.frontViewComponent3D.setBackground(color);
            this.addRotationListener(this.frontViewComponent3D, importedFurnitureWizardController, false);
            this.sideViewComponent3D = new ModelPreviewComponent(false, false, false);
            this.sideViewComponent3D.setViewYaw(Locale.getDefault().equals(Locale.US) ? -1.5707964f : 1.5707964f);
            this.sideViewComponent3D.setViewPitch(0.0f);
            this.sideViewComponent3D.setParallelProjection(true);
            this.sideViewComponent3D.setBackground(color);
            this.addRotationListener(this.sideViewComponent3D, importedFurnitureWizardController, false);
            this.topViewComponent3D = new ModelPreviewComponent(false, false, false);
            this.topViewComponent3D.setViewYaw(0.0f);
            this.topViewComponent3D.setViewPitch(-1.5707964f);
            this.topViewComponent3D.setParallelProjection(true);
            this.topViewComponent3D.setBackground(color);
            this.addRotationListener(this.topViewComponent3D, importedFurnitureWizardController, false);
            this.frontViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "frontViewLabel.text", new Object[0]));
            this.sideViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "sideViewLabel.text", new Object[0]));
            this.topViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "topViewLabel.text", new Object[0]));
            this.perspectiveViewLabel = new JLabel(userPreferences.getLocalizedString(ImportedFurnitureWizardStepsPanel.class, "perspectiveViewLabel.text", new Object[0]));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(COMPONENT_PREFERRED_WIDTH, COMPONENT_PREFERRED_WIDTH + 4 + this.frontViewLabel.getPreferredSize().height * 2);
        }

        protected void addRotationListener(final ModelPreviewComponent modelPreviewComponent, final ImportedFurnitureWizardController importedFurnitureWizardController, final boolean bl) {
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    modelPreviewComponent.setBackFaceShown(importedFurnitureWizardController.isBackFaceShown());
                }
            });
            if (bl) {
                importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MODEL, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        modelNode = null;
                    }
                });
            }
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                    modelPreviewComponent.setModelRotation(importedFurnitureWizardController.getModelRotation());
                    if (bl && propertyChangeEvent.getOldValue() != null && modelPreviewComponent.getModel() != null) {
                        if (modelNode == null) {
                            ModelManager.getInstance().loadModel(modelPreviewComponent.getModel(), new ModelManager.ModelObserver(){

                                @Override
                                public void modelUpdated(BranchGroup branchGroup) {
                                    modelNode = branchGroup;
                                    this.updateSize(importedFurnitureWizardController, (float[][])propertyChangeEvent.getOldValue(), (float[][])propertyChangeEvent.getNewValue());
                                }

                                @Override
                                public void modelError(Exception exception) {
                                }
                            });
                        } else {
                            this.updateSize(importedFurnitureWizardController, (float[][])propertyChangeEvent.getOldValue(), (float[][])propertyChangeEvent.getNewValue());
                        }
                    }
                }

                private void updateSize(ImportedFurnitureWizardController importedFurnitureWizardController2, float[][] fArray, float[][] fArray2) {
                    try {
                        Transform3D transform3D = ModelManager.getInstance().getNormalizedTransform((Node)modelNode, fArray, 1.0f);
                        Transform3D transform3D2 = new Transform3D();
                        transform3D2.setScale(new Vector3d((double)importedFurnitureWizardController2.getWidth(), (double)importedFurnitureWizardController2.getHeight(), (double)importedFurnitureWizardController2.getDepth()));
                        transform3D2.mul(transform3D);
                        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                        matrix3f.invert();
                        Transform3D transform3D3 = new Transform3D();
                        transform3D3.setRotation(matrix3f);
                        transform3D3.mul(transform3D2);
                        Matrix3f matrix3f2 = new Matrix3f(fArray2[0][0], fArray2[0][1], fArray2[0][2], fArray2[1][0], fArray2[1][1], fArray2[1][2], fArray2[2][0], fArray2[2][1], fArray2[2][2]);
                        Transform3D transform3D4 = new Transform3D();
                        transform3D4.setRotation(matrix3f2);
                        transform3D4.mul(transform3D3);
                        Vector3f vector3f = ModelManager.getInstance().getSize((Node)modelNode, transform3D4);
                        importedFurnitureWizardController2.setWidth(vector3f.x);
                        importedFurnitureWizardController2.setHeight(vector3f.y);
                        importedFurnitureWizardController2.setDepth(vector3f.z);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MODEL_ROTATION, propertyChangeListener);
        }

        private void layoutComponents() {
            this.setLayout(new GridBagLayout());
            if (Locale.getDefault().equals(Locale.US)) {
                this.add((Component)this.perspectiveViewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.perspectiveViewComponent3D, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.topViewLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.topViewComponent3D, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
                this.add((Component)this.sideViewLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.sideViewComponent3D, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                this.add((Component)this.frontViewLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.frontViewComponent3D, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)this.sideViewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.sideViewComponent3D, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
                this.add((Component)this.frontViewLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.frontViewComponent3D, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
                this.add((Component)this.perspectiveViewLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 5), 0, 0));
                this.add((Component)this.perspectiveViewComponent3D, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                this.add((Component)this.topViewLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
                this.add((Component)this.topViewComponent3D, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }

    private static class AttributesPreviewComponent
    extends AbstractModelPreviewComponent {
        public AttributesPreviewComponent(ImportedFurnitureWizardController importedFurnitureWizardController) {
            super(true);
            this.addSizeListeners(importedFurnitureWizardController);
            this.addColorListener(importedFurnitureWizardController);
        }
    }

    private static class IconPreviewComponent
    extends AbstractModelPreviewComponent {
        private static final int ICON_SIZE = Math.round(128.0f * SwingTools.getResolutionScale());
        private ImportedFurnitureWizardController controller;

        public IconPreviewComponent(ImportedFurnitureWizardController importedFurnitureWizardController) {
            super(false);
            this.controller = importedFurnitureWizardController;
            this.addSizeListeners(importedFurnitureWizardController);
            this.addColorListener(importedFurnitureWizardController);
            this.addIconYawListener(importedFurnitureWizardController);
            Color color = UIManager.getColor("window");
            if (color == null) {
                color = Color.LIGHT_GRAY;
            }
            this.setBackground(color);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(ICON_SIZE + insets.left + insets.right, ICON_SIZE + insets.top + insets.bottom);
        }

        @Override
        protected void setViewYaw(float f) {
            super.setViewYaw(f);
            this.controller.setIconYaw(f);
        }
    }

    private static abstract class AbstractModelPreviewComponent
    extends ModelPreviewComponent {
        public AbstractModelPreviewComponent(boolean bl) {
            super(bl);
        }

        protected void addSizeListeners(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.setBackFaceShown(importedFurnitureWizardController.isBackFaceShown());
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.setModelRotationAndSize(importedFurnitureWizardController.getModelRotation(), importedFurnitureWizardController.getWidth(), importedFurnitureWizardController.getDepth(), importedFurnitureWizardController.getHeight());
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.MODEL_ROTATION, propertyChangeListener);
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.WIDTH, propertyChangeListener);
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.DEPTH, propertyChangeListener);
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.HEIGHT, propertyChangeListener);
        }

        protected void addColorListener(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.setModelColor(importedFurnitureWizardController.getColor());
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.COLOR, propertyChangeListener);
        }

        protected void addIconYawListener(final ImportedFurnitureWizardController importedFurnitureWizardController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.setViewYaw(importedFurnitureWizardController.getIconYaw());
                }
            };
            importedFurnitureWizardController.addPropertyChangeListener(ImportedFurnitureWizardController.Property.ICON_YAW, propertyChangeListener);
        }
    }
}

