/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.GeometryInfo;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Vector3f;

class GeometryInfoGenerator {
    GeometryInfoGenerator() {
    }

    public static void create(GeometryInfo geometryInfo, GeometryArray geometryArray) {
        if (geometryArray instanceof GeometryStripArray) {
            GeometryInfoGenerator.create(geometryInfo, (GeometryStripArray)geometryArray);
        } else if (geometryArray instanceof TriangleArray) {
            geometryInfo.reset(1);
            GeometryInfoGenerator.processGeometryArray(geometryInfo, geometryArray);
        } else if (geometryArray instanceof QuadArray) {
            geometryInfo.reset(2);
            GeometryInfoGenerator.processGeometryArray(geometryInfo, geometryArray);
        } else if (geometryArray instanceof IndexedGeometryArray) {
            GeometryInfoGenerator.create(geometryInfo, (IndexedGeometryArray)geometryArray);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
    }

    private static void create(GeometryInfo geometryInfo, GeometryStripArray geometryStripArray) {
        if (geometryStripArray instanceof TriangleFanArray) {
            geometryInfo.reset(3);
        } else if (geometryStripArray instanceof TriangleStripArray) {
            geometryInfo.reset(4);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
        GeometryInfoGenerator.processGeometryArray(geometryInfo, (GeometryArray)geometryStripArray);
        GeometryInfoGenerator.processStripArray(geometryInfo, geometryStripArray);
    }

    private static void create(GeometryInfo geometryInfo, IndexedGeometryArray indexedGeometryArray) {
        if (indexedGeometryArray instanceof IndexedQuadArray) {
            geometryInfo.reset(2);
        } else if (indexedGeometryArray instanceof IndexedTriangleArray) {
            geometryInfo.reset(1);
        } else if (indexedGeometryArray instanceof IndexedTriangleFanArray) {
            geometryInfo.reset(3);
            GeometryInfoGenerator.processIndexStripArray(geometryInfo, (IndexedGeometryStripArray)indexedGeometryArray);
        } else if (indexedGeometryArray instanceof IndexedTriangleStripArray) {
            geometryInfo.reset(4);
            GeometryInfoGenerator.processIndexStripArray(geometryInfo, (IndexedGeometryStripArray)indexedGeometryArray);
        }
        GeometryInfoGenerator.processGeometryArray(geometryInfo, (GeometryArray)indexedGeometryArray);
        GeometryInfoGenerator.processIndexedArray(geometryInfo, indexedGeometryArray);
    }

    private static void processGeometryArray(GeometryInfo geometryInfo, GeometryArray geometryArray) {
        block153: {
            Object[] objectArray;
            Object object;
            Object[] objectArray2;
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            int n3;
            int n4;
            block161: {
                Color3f[] color3fArray;
                block164: {
                    int n5;
                    block162: {
                        block163: {
                            block157: {
                                Color4f[] color4fArray;
                                block160: {
                                    int n6;
                                    block158: {
                                        block159: {
                                            Point3f[] point3fArray;
                                            block156: {
                                                int n7;
                                                block154: {
                                                    Object[] objectArray3;
                                                    block155: {
                                                        block152: {
                                                            int n8;
                                                            TexCoord2f[] texCoord2fArray;
                                                            float[] fArray;
                                                            Color4f[] color4fArray2;
                                                            n4 = geometryArray.getVertexFormat();
                                                            n3 = geometryArray.getTexCoordSetCount();
                                                            if (geometryArray instanceof GeometryStripArray) {
                                                                GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
                                                                int[] nArray = new int[geometryStripArray.getNumStrips()];
                                                                geometryStripArray.getStripVertexCounts(nArray);
                                                                n2 = 0;
                                                                for (n = 0; n < nArray.length; ++n) {
                                                                    n2 += nArray[n];
                                                                }
                                                            } else {
                                                                n2 = geometryArray instanceof IndexedGeometryArray ? geometryArray.getVertexCount() : geometryArray.getValidVertexCount();
                                                            }
                                                            if ((n4 & 0x100) == 0) break block152;
                                                            int n9 = 3;
                                                            if ((n4 & 2) != 0) {
                                                                n9 += 3;
                                                            }
                                                            if ((n4 & 0xC) == 12) {
                                                                n9 += 4;
                                                            } else if ((n4 & 4) != 0) {
                                                                n9 += 3;
                                                            }
                                                            if ((n4 & 0x20) != 0) {
                                                                n9 += 2 * n3;
                                                            } else if ((n4 & 0x40) != 0) {
                                                                n9 += 3 * n3;
                                                            } else if ((n4 & 0x400) != 0) {
                                                                n9 += 4 * n3;
                                                            }
                                                            int n10 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                                            if ((n4 & 0x800) != 0) {
                                                                J3DBuffer j3DBuffer = geometryArray.getInterleavedVertexBuffer();
                                                                color4fArray2 = (FloatBuffer)j3DBuffer.getBuffer();
                                                                fArray = new float[color4fArray2.limit()];
                                                                color4fArray2.position(0);
                                                                color4fArray2.get(fArray);
                                                            } else {
                                                                fArray = geometryArray.getInterleavedVertices();
                                                            }
                                                            int n11 = 0;
                                                            if ((n4 & 0x20) != 0) {
                                                                geometryInfo.setTextureCoordinateParams(n3, 2);
                                                                color4fArray2 = (Color4f[])new int[geometryArray.getTexCoordSetMapLength()];
                                                                geometryArray.getTexCoordSetMap((int[])color4fArray2);
                                                                geometryInfo.setTexCoordSetMap((int[])color4fArray2);
                                                                for (n = 0; n < n3; ++n) {
                                                                    texCoord2fArray = new TexCoord2f[n2];
                                                                    for (n8 = 0; n8 < n2; ++n8) {
                                                                        texCoord2fArray[n8] = new TexCoord2f(fArray[n9 * (n8 + n10) + n11], fArray[n9 * (n8 + n10) + n11 + 1]);
                                                                    }
                                                                    geometryInfo.setTextureCoordinates(n, texCoord2fArray);
                                                                    n11 += 2;
                                                                }
                                                            } else if ((n4 & 0x40) != 0) {
                                                                geometryInfo.setTextureCoordinateParams(n3, 3);
                                                                color4fArray2 = (Color4f[])new int[geometryArray.getTexCoordSetMapLength()];
                                                                geometryArray.getTexCoordSetMap((int[])color4fArray2);
                                                                geometryInfo.setTexCoordSetMap((int[])color4fArray2);
                                                                for (n = 0; n < n3; ++n) {
                                                                    texCoord2fArray = new TexCoord3f[n2];
                                                                    for (n8 = 0; n8 < n2; ++n8) {
                                                                        texCoord2fArray[n8] = new TexCoord3f(fArray[n9 * (n8 + n10) + n11], fArray[n9 * (n8 + n10) + n11 + 1], fArray[n9 * (n8 + n10) + n11 + 2]);
                                                                    }
                                                                    geometryInfo.setTextureCoordinates(n, (TexCoord3f[])texCoord2fArray);
                                                                    n11 += 3;
                                                                }
                                                            } else if ((n4 & 0x400) != 0) {
                                                                geometryInfo.setTextureCoordinateParams(n3, 4);
                                                                color4fArray2 = (Color4f[])new int[geometryArray.getTexCoordSetMapLength()];
                                                                geometryArray.getTexCoordSetMap((int[])color4fArray2);
                                                                geometryInfo.setTexCoordSetMap((int[])color4fArray2);
                                                                for (n = 0; n < n3; ++n) {
                                                                    texCoord2fArray = new TexCoord4f[n2];
                                                                    for (n8 = 0; n8 < n2; ++n8) {
                                                                        texCoord2fArray[n8] = new TexCoord4f(fArray[n9 * (n8 + n10) + n11], fArray[n9 * (n8 + n10) + n11 + 1], fArray[n9 * (n8 + n10) + n11 + 2], fArray[n9 * (n8 + n10) + n11 + 3]);
                                                                    }
                                                                    geometryInfo.setTextureCoordinates(n, (TexCoord4f[])texCoord2fArray);
                                                                    n11 += 4;
                                                                }
                                                            }
                                                            if ((n4 & 0xC) == 12) {
                                                                color4fArray2 = new Color4f[n2];
                                                                for (n = 0; n < n2; ++n) {
                                                                    color4fArray2[n] = new Color4f(fArray[n9 * (n + n10) + n11], fArray[n9 * (n + n10) + n11 + 1], fArray[n9 * (n + n10) + n11 + 2], fArray[n9 * (n + n10) + n11 + 3]);
                                                                }
                                                                geometryInfo.setColors(color4fArray2);
                                                                n11 += 4;
                                                            } else if ((n4 & 4) != 0) {
                                                                color4fArray2 = new Color3f[n2];
                                                                for (n = 0; n < n2; ++n) {
                                                                    color4fArray2[n] = new Color3f(fArray[n9 * (n + n10) + n11], fArray[n9 * (n + n10) + n11 + 1], fArray[n9 * (n + n10) + n11 + 2]);
                                                                }
                                                                geometryInfo.setColors((Color3f[])color4fArray2);
                                                                n11 += 3;
                                                            }
                                                            if ((n4 & 2) != 0) {
                                                                color4fArray2 = new Vector3f[n2];
                                                                for (n = 0; n < n2; ++n) {
                                                                    color4fArray2[n] = new Vector3f(fArray[n9 * (n + n10) + n11], fArray[n9 * (n + n10) + n11 + 1], fArray[n9 * (n + n10) + n11 + 2]);
                                                                }
                                                                geometryInfo.setNormals((Vector3f[])color4fArray2);
                                                                n11 += 3;
                                                            }
                                                            color4fArray2 = new Point3f[n2];
                                                            for (n = 0; n < n2; ++n) {
                                                                color4fArray2[n] = new Point3f(fArray[n9 * (n + n10) + n11], fArray[n9 * (n + n10) + n11 + 1], fArray[n9 * (n + n10) + n11 + 2]);
                                                            }
                                                            geometryInfo.setCoordinates((Point3f[])color4fArray2);
                                                            break block153;
                                                        }
                                                        bl2 = (n4 & 0x80) != 0;
                                                        bl = (n4 & 0x800) != 0;
                                                        point3fArray = null;
                                                        if (!bl2) break block154;
                                                        n7 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialCoordIndex() : 0;
                                                        if (!bl) break block155;
                                                        objectArray3 = geometryArray.getCoordRefBuffer();
                                                        switch (BufferWrapper.getBufferType((J3DBuffer)objectArray3)) {
                                                            case 3: {
                                                                objectArray2 = (FloatBuffer)objectArray3.getBuffer();
                                                                object = new float[n2 * 3];
                                                                objectArray2.position(n7 * 3);
                                                                objectArray2.get((float[])object, 0, n2 * 3);
                                                                point3fArray = new Point3f[n2];
                                                                for (n = 0; n < n2; ++n) {
                                                                    point3fArray[n] = new Point3f((float)object[n * 3 + 0], (float)object[n * 3 + 1], (float)object[n * 3 + 2]);
                                                                }
                                                                break block156;
                                                            }
                                                            case 4: {
                                                                objectArray2 = (DoubleBuffer)objectArray3.getBuffer();
                                                                object = new double[n2 * 3];
                                                                objectArray2.position(n7 * 3);
                                                                objectArray2.get((double[])object, 0, n2 * 3);
                                                                point3fArray = new Point3f[n2];
                                                                for (n = 0; n < n2; ++n) {
                                                                    point3fArray[n] = new Point3f((float)object[n * 3 + 0], (float)object[n * 3 + 1], (float)object[n * 3 + 2]);
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        break block156;
                                                    }
                                                    if (geometryArray.getCoordRef3f() != null) {
                                                        if (n7 != 0) {
                                                            objectArray3 = geometryArray.getCoordRef3f();
                                                            point3fArray = new Point3f[n2];
                                                            for (n = 0; n < n2; ++n) {
                                                                point3fArray[n] = new Point3f(objectArray3[n + n7]);
                                                            }
                                                        } else {
                                                            point3fArray = geometryArray.getCoordRef3f();
                                                        }
                                                    } else if (geometryArray.getCoordRef3d() != null) {
                                                        objectArray3 = geometryArray.getCoordRef3d();
                                                        point3fArray = new Point3f[n2];
                                                        for (n = 0; n < n2; ++n) {
                                                            point3fArray[n] = new Point3f((Point3d)objectArray3[n + n7]);
                                                        }
                                                    } else if (geometryArray.getCoordRefFloat() != null) {
                                                        objectArray3 = geometryArray.getCoordRefFloat();
                                                        point3fArray = new Point3f[n2];
                                                        for (n = 0; n < n2; ++n) {
                                                            point3fArray[n] = new Point3f((float)objectArray3[(n + n7) * 3], (float)objectArray3[(n + n7) * 3 + 1], (float)objectArray3[(n + n7) * 3 + 2]);
                                                        }
                                                    } else if (geometryArray.getCoordRefDouble() != null) {
                                                        objectArray3 = geometryArray.getCoordRefDouble();
                                                        point3fArray = new Point3f[n2];
                                                        for (n = 0; n < n2; ++n) {
                                                            point3fArray[n] = new Point3f((float)objectArray3[(n + n7) * 3], (float)objectArray3[(n + n7) * 3 + 1], (float)objectArray3[(n + n7) * 3 + 2]);
                                                        }
                                                    }
                                                    break block156;
                                                }
                                                n7 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                                point3fArray = new Point3f[n2];
                                                for (n = 0; n < n2; ++n) {
                                                    point3fArray[n] = new Point3f();
                                                }
                                                geometryArray.getCoordinates(n7, point3fArray);
                                            }
                                            geometryInfo.setCoordinates(point3fArray);
                                            if ((n4 & 2) != 0) {
                                                int n12;
                                                Vector3f[] vector3fArray = null;
                                                if (bl2) {
                                                    n12 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialNormalIndex() : 0;
                                                    if (bl) {
                                                        objectArray2 = geometryArray.getNormalRefBuffer();
                                                        if (BufferWrapper.getBufferType((J3DBuffer)objectArray2) == 3) {
                                                            object = (FloatBuffer)objectArray2.getBuffer();
                                                            objectArray = new float[n2 * 3];
                                                            ((FloatBuffer)object).position(n12 * 3);
                                                            ((FloatBuffer)object).get((float[])objectArray, 0, n2 * 3);
                                                            vector3fArray = new Vector3f[n2];
                                                            for (n = 0; n < n2; ++n) {
                                                                vector3fArray[n] = new Vector3f(objectArray[n * 3 + 0], objectArray[n * 3 + 1], objectArray[n * 3 + 2]);
                                                            }
                                                        }
                                                    } else if (geometryArray.getNormalRef3f() != null) {
                                                        if (n12 != 0) {
                                                            objectArray2 = geometryArray.getNormalRef3f();
                                                            vector3fArray = new Vector3f[n2];
                                                            for (n = 0; n < n2; ++n) {
                                                                vector3fArray[n] = new Vector3f((Vector3f)objectArray2[n + n12]);
                                                            }
                                                        } else {
                                                            vector3fArray = geometryArray.getNormalRef3f();
                                                        }
                                                    } else if (geometryArray.getNormalRefFloat() != null) {
                                                        objectArray2 = geometryArray.getNormalRefFloat();
                                                        vector3fArray = new Vector3f[n2];
                                                        for (n = 0; n < n2; ++n) {
                                                            vector3fArray[n] = new Vector3f((float)objectArray2[(n + n12) * 3], (float)objectArray2[(n + n12) * 3 + 1], (float)objectArray2[(n + n12) * 3 + 2]);
                                                        }
                                                    }
                                                } else {
                                                    n12 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                                    vector3fArray = new Vector3f[n2];
                                                    for (n = 0; n < n2; ++n) {
                                                        vector3fArray[n] = new Vector3f();
                                                    }
                                                    geometryArray.getNormals(n12, vector3fArray);
                                                }
                                                geometryInfo.setNormals(vector3fArray);
                                            }
                                            if ((n4 & 0xC) != 12) break block157;
                                            color4fArray = null;
                                            if (!bl2) break block158;
                                            n6 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialColorIndex() : 0;
                                            if (!bl) break block159;
                                            objectArray2 = geometryArray.getColorRefBuffer();
                                            switch (BufferWrapper.getBufferType((J3DBuffer)objectArray2)) {
                                                case 3: {
                                                    object = (FloatBuffer)objectArray2.getBuffer();
                                                    objectArray = new float[n2 * 4];
                                                    ((FloatBuffer)object).position(n6 * 4);
                                                    ((FloatBuffer)object).get((float[])objectArray, 0, n2 * 4);
                                                    color4fArray = new Color4f[n2];
                                                    for (n = 0; n < n2; ++n) {
                                                        color4fArray[n] = new Color4f(objectArray[n * 4 + 0], objectArray[n * 4 + 1], objectArray[n * 4 + 2], objectArray[n * 4 + 3]);
                                                    }
                                                    break block160;
                                                }
                                                case 2: {
                                                    object = (ByteBuffer)objectArray2.getBuffer();
                                                    objectArray = new byte[n2 * 4];
                                                    ((ByteBuffer)object).position(n6 * 4);
                                                    ((ByteBuffer)object).get((byte[])objectArray, 0, n2 * 4);
                                                    color4fArray = new Color4f[n2];
                                                    for (n = 0; n < n2; ++n) {
                                                        color4fArray[n] = new Color4f((float)(objectArray[n * 4 + 0] & 0xFF) / 255.0f, (float)(objectArray[n * 4 + 1] & 0xFF) / 255.0f, (float)(objectArray[n * 4 + 2] & 0xFF) / 255.0f, (float)(objectArray[n * 4 + 3] & 0xFF) / 255.0f);
                                                    }
                                                    break;
                                                }
                                            }
                                            break block160;
                                        }
                                        if (geometryArray.getColorRef4f() != null) {
                                            if (n6 != 0) {
                                                objectArray2 = geometryArray.getColorRef4f();
                                                color4fArray = new Color4f[n2];
                                                for (n = 0; n < n2; ++n) {
                                                    color4fArray[n] = new Color4f(objectArray2[n + n6]);
                                                }
                                            } else {
                                                color4fArray = geometryArray.getColorRef4f();
                                            }
                                        } else if (geometryArray.getColorRefFloat() != null) {
                                            objectArray2 = geometryArray.getColorRefFloat();
                                            color4fArray = new Color4f[n2];
                                            for (n = 0; n < n2; ++n) {
                                                color4fArray[n] = new Color4f((float)objectArray2[(n + n6) * 4 + 0], (float)objectArray2[(n + n6) * 4 + 1], (float)objectArray2[(n + n6) * 4 + 2], (float)objectArray2[(n + n6) * 4 + 3]);
                                            }
                                        } else if (geometryArray.getColorRefByte() != null) {
                                            objectArray2 = geometryArray.getColorRefByte();
                                            color4fArray = new Color4f[n2];
                                            for (n = 0; n < n2; ++n) {
                                                color4fArray[n] = new Color4f((float)(objectArray2[(n + n6) * 4 + 0] & 0xFF) / 255.0f, (float)(objectArray2[(n + n6) * 4 + 1] & 0xFF) / 255.0f, (float)(objectArray2[(n + n6) * 4 + 2] & 0xFF) / 255.0f, (float)(objectArray2[(n + n6) * 4 + 3] & 0xFF) / 255.0f);
                                            }
                                        } else if (geometryArray.getColorRef4b() != null) {
                                            objectArray2 = geometryArray.getColorRef4b();
                                            color4fArray = new Color4f[n2];
                                            for (n = 0; n < n2; ++n) {
                                                color4fArray[n] = new Color4f((float)(objectArray2[n + n6].x & 0xFF) / 255.0f, (float)(objectArray2[n + n6].y & 0xFF) / 255.0f, (float)(objectArray2[n + n6].z & 0xFF) / 255.0f, (float)(objectArray2[n + n6].w & 0xFF) / 255.0f);
                                            }
                                        }
                                        break block160;
                                    }
                                    n6 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                                    color4fArray = new Color4f[n2];
                                    for (n = 0; n < n2; ++n) {
                                        color4fArray[n] = new Color4f();
                                    }
                                    geometryArray.getColors(n6, color4fArray);
                                }
                                geometryInfo.setColors(color4fArray);
                                break block161;
                            }
                            if ((n4 & 4) == 0) break block161;
                            color3fArray = null;
                            if (!bl2) break block162;
                            n5 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialColorIndex() : 0;
                            if (!bl) break block163;
                            objectArray2 = geometryArray.getColorRefBuffer();
                            switch (BufferWrapper.getBufferType((J3DBuffer)objectArray2)) {
                                case 3: {
                                    object = (FloatBuffer)objectArray2.getBuffer();
                                    objectArray = new float[n2 * 3];
                                    ((FloatBuffer)object).position(n5 * 3);
                                    ((FloatBuffer)object).get((float[])objectArray, 0, n2 * 3);
                                    color3fArray = new Color3f[n2];
                                    for (n = 0; n < n2; ++n) {
                                        color3fArray[n] = new Color3f(objectArray[n * 3 + 0], objectArray[n * 3 + 1], objectArray[n * 3 + 2]);
                                    }
                                    break block164;
                                }
                                case 2: {
                                    object = (ByteBuffer)objectArray2.getBuffer();
                                    objectArray = new byte[n2 * 3];
                                    ((ByteBuffer)object).position(n5 * 3);
                                    ((ByteBuffer)object).get((byte[])objectArray, 0, n2 * 3);
                                    color3fArray = new Color3f[n2];
                                    for (n = 0; n < n2; ++n) {
                                        color3fArray[n] = new Color3f((float)(objectArray[n * 3 + 0] & 0xFF) / 255.0f, (float)(objectArray[n * 3 + 1] & 0xFF) / 255.0f, (float)(objectArray[n * 3 + 2] & 0xFF) / 255.0f);
                                    }
                                    break;
                                }
                            }
                            break block164;
                        }
                        if (geometryArray.getColorRef3f() != null) {
                            if (n5 != 0) {
                                objectArray2 = geometryArray.getColorRef3f();
                                color3fArray = new Color3f[n2];
                                for (n = 0; n < n2; ++n) {
                                    color3fArray[n] = new Color3f((Color3f)objectArray2[n + n5]);
                                }
                            } else {
                                color3fArray = geometryArray.getColorRef3f();
                            }
                        } else if (geometryArray.getColorRefFloat() != null) {
                            objectArray2 = geometryArray.getColorRefFloat();
                            color3fArray = new Color3f[n2];
                            for (n = 0; n < n2; ++n) {
                                color3fArray[n] = new Color3f((float)objectArray2[(n + n5) * 3 + 0], (float)objectArray2[(n + n5) * 3 + 1], (float)objectArray2[(n + n5) * 3 + 2]);
                            }
                        } else if (geometryArray.getColorRefByte() != null) {
                            objectArray2 = geometryArray.getColorRefByte();
                            color3fArray = new Color3f[n2];
                            for (n = 0; n < n2; ++n) {
                                color3fArray[n] = new Color3f((float)(objectArray2[(n + n5) * 3 + 0] & 0xFF) / 255.0f, (float)(objectArray2[(n + n5) * 3 + 1] & 0xFF) / 255.0f, (float)(objectArray2[(n + n5) * 3 + 2] & 0xFF) / 255.0f);
                            }
                        } else if (geometryArray.getColorRef3b() != null) {
                            objectArray2 = geometryArray.getColorRef3b();
                            color3fArray = new Color3f[n2];
                            for (n = 0; n < n2; ++n) {
                                color3fArray[n] = new Color3f((float)(objectArray2[n + n5].x & 0xFF) / 255.0f, (float)(objectArray2[n + n5].y & 0xFF) / 255.0f, (float)(objectArray2[n + n5].z & 0xFF) / 255.0f);
                            }
                        }
                        break block164;
                    }
                    n5 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                    color3fArray = new Color3f[n2];
                    for (n = 0; n < n2; ++n) {
                        color3fArray[n] = new Color3f();
                    }
                    geometryArray.getColors(n5, color3fArray);
                }
                geometryInfo.setColors(color3fArray);
            }
            if ((n4 & 0x400) != 0) {
                geometryInfo.setTextureCoordinateParams(n3, 4);
                for (n = 0; n < n3; ++n) {
                    int n13;
                    int n14;
                    TexCoord4f[] texCoord4fArray = null;
                    if (bl2) {
                        n14 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialTexCoordIndex(n) : 0;
                        if (bl) {
                            objectArray2 = geometryArray.getTexCoordRefBuffer(n);
                            if (BufferWrapper.getBufferType((J3DBuffer)objectArray2) == 3) {
                                object = (FloatBuffer)objectArray2.getBuffer();
                                objectArray = new float[n2 * 4];
                                ((FloatBuffer)object).position(n14 * 4);
                                ((FloatBuffer)object).get((float[])objectArray, 0, n2 * 4);
                                texCoord4fArray = new TexCoord4f[n2];
                                for (n13 = 0; n13 < n2; ++n13) {
                                    texCoord4fArray[n13] = new TexCoord4f(objectArray[n13 * 4 + 0], objectArray[n13 * 4 + 1], objectArray[n13 * 4 + 2], objectArray[n13 * 4 + 3]);
                                }
                            }
                        } else {
                            objectArray2 = geometryArray.getTexCoordRefFloat(n);
                            texCoord4fArray = new TexCoord4f[n2];
                            for (n13 = 0; n13 < n2; ++n13) {
                                texCoord4fArray[n13] = new TexCoord4f((float)objectArray2[(n13 + n14) * 4], (float)objectArray2[(n13 + n14) * 4 + 1], (float)objectArray2[(n13 + n14) * 4 + 2], (float)objectArray2[(n13 + n14) * 4 + 3]);
                            }
                        }
                    } else {
                        n14 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                        texCoord4fArray = new TexCoord4f[n2];
                        for (n13 = 0; n13 < n2; ++n13) {
                            texCoord4fArray[n13] = new TexCoord4f();
                        }
                        geometryArray.getTextureCoordinates(n, n14, texCoord4fArray);
                    }
                    geometryInfo.setTextureCoordinates(n, texCoord4fArray);
                }
                int[] nArray = new int[geometryArray.getTexCoordSetMapLength()];
                geometryArray.getTexCoordSetMap(nArray);
                geometryInfo.setTexCoordSetMap(nArray);
            } else if ((n4 & 0x40) != 0) {
                geometryInfo.setTextureCoordinateParams(n3, 3);
                for (n = 0; n < n3; ++n) {
                    int n15;
                    int n16;
                    TexCoord3f[] texCoord3fArray = null;
                    if (bl2) {
                        n16 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialTexCoordIndex(n) : 0;
                        if (bl) {
                            objectArray2 = geometryArray.getTexCoordRefBuffer(n);
                            if (BufferWrapper.getBufferType((J3DBuffer)objectArray2) == 3) {
                                object = (FloatBuffer)objectArray2.getBuffer();
                                objectArray = new float[n2 * 3];
                                ((FloatBuffer)object).position(n16 * 3);
                                ((FloatBuffer)object).get((float[])objectArray, 0, n2 * 3);
                                texCoord3fArray = new TexCoord3f[n2];
                                for (n15 = 0; n15 < n2; ++n15) {
                                    texCoord3fArray[n15] = new TexCoord3f(objectArray[n15 * 3 + 0], objectArray[n15 * 3 + 1], objectArray[n15 * 3 + 2]);
                                }
                            }
                        } else if (geometryArray.getTexCoordRef3f(n) != null) {
                            if (n16 != 0) {
                                objectArray2 = geometryArray.getTexCoordRef3f(n);
                                texCoord3fArray = new TexCoord3f[n2];
                                for (n15 = 0; n15 < n2; ++n15) {
                                    texCoord3fArray[n15] = new TexCoord3f(objectArray2[n15 + n16]);
                                }
                            } else {
                                texCoord3fArray = geometryArray.getTexCoordRef3f(n);
                            }
                        } else if (geometryArray.getTexCoordRefFloat(n) != null) {
                            objectArray2 = geometryArray.getTexCoordRefFloat(n);
                            texCoord3fArray = new TexCoord3f[n2];
                            for (n15 = 0; n15 < n2; ++n15) {
                                texCoord3fArray[n15] = new TexCoord3f((float)objectArray2[(n15 + n16) * 3], (float)objectArray2[(n15 + n16) * 3 + 1], (float)objectArray2[(n15 + n16) * 3 + 2]);
                            }
                        }
                    } else {
                        n16 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                        texCoord3fArray = new TexCoord3f[n2];
                        for (n15 = 0; n15 < n2; ++n15) {
                            texCoord3fArray[n15] = new TexCoord3f();
                        }
                        geometryArray.getTextureCoordinates(n, n16, texCoord3fArray);
                    }
                    geometryInfo.setTextureCoordinates(n, texCoord3fArray);
                }
                int[] nArray = new int[geometryArray.getTexCoordSetMapLength()];
                geometryArray.getTexCoordSetMap(nArray);
                geometryInfo.setTexCoordSetMap(nArray);
            } else if ((n4 & 0x20) != 0) {
                geometryInfo.setTextureCoordinateParams(n3, 2);
                for (n = 0; n < n3; ++n) {
                    int n17;
                    int n18;
                    TexCoord2f[] texCoord2fArray = null;
                    if (bl2) {
                        n18 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialTexCoordIndex(n) : 0;
                        if (bl) {
                            objectArray2 = geometryArray.getTexCoordRefBuffer(n);
                            if (BufferWrapper.getBufferType((J3DBuffer)objectArray2) == 3) {
                                object = (FloatBuffer)objectArray2.getBuffer();
                                objectArray = new float[n2 * 2];
                                ((FloatBuffer)object).position(n18 * 2);
                                ((FloatBuffer)object).get((float[])objectArray, 0, n2 * 2);
                                texCoord2fArray = new TexCoord2f[n2];
                                for (n17 = 0; n17 < n2; ++n17) {
                                    texCoord2fArray[n17] = new TexCoord2f(objectArray[n17 * 2 + 0], objectArray[n17 * 2 + 1]);
                                }
                            }
                        } else if (geometryArray.getTexCoordRefFloat(n) != null) {
                            objectArray2 = geometryArray.getTexCoordRefFloat(n);
                            texCoord2fArray = new TexCoord2f[n2];
                            for (n17 = 0; n17 < n2; ++n17) {
                                texCoord2fArray[n17] = new TexCoord2f((float)objectArray2[(n17 + n18) * 2 + 0], (float)objectArray2[(n17 + n18) * 2 + 1]);
                            }
                        } else if (geometryArray.getTexCoordRef2f(n) != null) {
                            if (n18 != 0) {
                                objectArray2 = geometryArray.getTexCoordRef2f(n);
                                texCoord2fArray = new TexCoord2f[n2];
                                for (n17 = 0; n17 < n2; ++n17) {
                                    texCoord2fArray[n17] = new TexCoord2f((TexCoord2f)objectArray2[n17 + n18]);
                                }
                            } else {
                                texCoord2fArray = geometryArray.getTexCoordRef2f(n);
                            }
                        }
                    } else {
                        n18 = !(geometryArray instanceof IndexedGeometryArray) ? geometryArray.getInitialVertexIndex() : 0;
                        texCoord2fArray = new TexCoord2f[n2];
                        for (n17 = 0; n17 < n2; ++n17) {
                            texCoord2fArray[n17] = new TexCoord2f();
                        }
                        geometryArray.getTextureCoordinates(n, n18, texCoord2fArray);
                    }
                    geometryInfo.setTextureCoordinates(n, texCoord2fArray);
                }
                int[] nArray = new int[geometryArray.getTexCoordSetMapLength()];
                geometryArray.getTexCoordSetMap(nArray);
                geometryInfo.setTexCoordSetMap(nArray);
            }
        }
    }

    private static void processIndexedArray(GeometryInfo geometryInfo, IndexedGeometryArray indexedGeometryArray) {
        block11: {
            int n;
            int[] nArray;
            int n2;
            int n3;
            int n4;
            block10: {
                Object object;
                n4 = indexedGeometryArray.getInitialIndexIndex();
                n3 = indexedGeometryArray.getVertexFormat();
                n2 = indexedGeometryArray.getTexCoordSetCount();
                if (indexedGeometryArray instanceof IndexedGeometryStripArray) {
                    object = (IndexedGeometryStripArray)indexedGeometryArray;
                    nArray = new int[object.getNumStrips()];
                    object.getStripIndexCounts(nArray);
                    n = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        n += nArray[i];
                    }
                } else {
                    n = indexedGeometryArray.getValidIndexCount();
                }
                object = new int[n];
                indexedGeometryArray.getCoordinateIndices(n4, (int[])object);
                geometryInfo.setCoordinateIndices((int[])object);
                if ((n3 & 0x200) == 0) break block10;
                if ((n3 & 2) != 0) {
                    geometryInfo.setNormalIndices((int[])object);
                }
                if ((n3 & 4) != 0 || (n3 & 0xC) != 0) {
                    geometryInfo.setColorIndices((int[])object);
                }
                if ((n3 & 0x20) == 0 && (n3 & 0x40) == 0 && (n3 & 0x400) == 0) break block11;
                for (int i = 0; i < n2; ++i) {
                    geometryInfo.setTextureCoordinateIndices(i, (int[])object);
                }
                break block11;
            }
            if ((n3 & 2) != 0) {
                nArray = new int[n];
                indexedGeometryArray.getNormalIndices(n4, nArray);
                geometryInfo.setNormalIndices(nArray);
            }
            if ((n3 & 4) != 0 || (n3 & 0xC) != 0) {
                nArray = new int[n];
                indexedGeometryArray.getColorIndices(n4, nArray);
                geometryInfo.setColorIndices(nArray);
            }
            if ((n3 & 0x20) != 0 || (n3 & 0x40) != 0 || (n3 & 0x400) != 0) {
                for (int i = 0; i < n2; ++i) {
                    int[] nArray2 = new int[n];
                    indexedGeometryArray.getTextureCoordinateIndices(i, n4, nArray2);
                    geometryInfo.setTextureCoordinateIndices(i, nArray2);
                }
            }
        }
    }

    private static void processStripArray(GeometryInfo geometryInfo, GeometryStripArray geometryStripArray) {
        int[] nArray = new int[geometryStripArray.getNumStrips()];
        geometryStripArray.getStripVertexCounts(nArray);
        geometryInfo.setStripCounts(nArray);
    }

    private static void processIndexStripArray(GeometryInfo geometryInfo, IndexedGeometryStripArray indexedGeometryStripArray) {
        int[] nArray = new int[indexedGeometryStripArray.getNumStrips()];
        indexedGeometryStripArray.getStripIndexCounts(nArray);
        geometryInfo.setStripCounts(nArray);
    }
}

