/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Vector3d;

public class PositionInterpolator
extends TransformInterpolator {
    private Transform3D translation = new Transform3D();
    private Vector3d transv = new Vector3d();
    float startPosition;
    float endPosition;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    PositionInterpolator() {
    }

    public PositionInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha, transformGroup);
        this.startPosition = 0.0f;
        this.endPosition = 1.0f;
    }

    public PositionInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f, float f2) {
        super(alpha, transformGroup, transform3D);
        this.startPosition = f;
        this.endPosition = f2;
    }

    public void setStartPosition(float f) {
        this.startPosition = f;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public void setEndPosition(float f) {
        this.endPosition = f;
    }

    public float getEndPosition() {
        return this.endPosition;
    }

    public void setAxisOfTranslation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfTranslation() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f, Transform3D transform3D) {
        double d = (1.0 - (double)f) * (double)this.startPosition + (double)(f * this.endPosition);
        this.transv.set(d, 0.0, 0.0);
        this.translation.setTranslation(this.transv);
        transform3D.mul(this.axis, this.translation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        PositionInterpolator positionInterpolator = new PositionInterpolator();
        positionInterpolator.duplicateNode(this, bl);
        return positionInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PositionInterpolator positionInterpolator = (PositionInterpolator)node;
        this.setStartPosition(positionInterpolator.getStartPosition());
        this.setEndPosition(positionInterpolator.getEndPosition());
    }
}

