/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;

public abstract class BufferedEncoder
extends AudioCodec {
    protected int[] readBytes = new int[1];
    protected int[] writeBytes = new int[1];
    protected int[] frameNumber = new int[1];
    protected Buffer history = new Buffer();
    protected int[] regions;
    protected int[] regionsTypes;
    protected int pendingFrames;
    protected int packetSize = -1;
    protected int historySize;

    public int getPacketSize() {
        return this.packetSize;
    }

    public int setPacketSize(int newPacketSize) {
        this.packetSize = newPacketSize;
        return this.packetSize;
    }

    public void reset() {
        this.history.setLength(0);
        this.codecReset();
    }

    protected abstract void codecReset();

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (this.pendingFrames > 0) {
            return 0;
        }
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int inpOffset = inputBuffer.getOffset();
        int inpLength = inputBuffer.getLength();
        int outLength = 0;
        int outOffset = 0;
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, this.calculateOutputSize(inpData.length + this.historySize));
        int historyLength = this.history.getLength();
        byte[] historyData = this.validateByteArraySize(this.history, this.historySize);
        int framesNumber = this.calculateFramesNumber(inpData.length + this.historySize);
        if (this.regions == null || this.regions.length < framesNumber + 1) {
            this.regions = new int[framesNumber + 1];
        }
        if (this.regionsTypes == null || this.regionsTypes.length < framesNumber) {
            this.regionsTypes = new int[framesNumber];
        }
        if (historyLength != 0) {
            int bytesToCopy = historyData.length - historyLength;
            if (bytesToCopy > inpLength) {
                bytesToCopy = inpLength;
            }
            System.arraycopy(inpData, inpOffset, historyData, historyLength, bytesToCopy);
            this.codecProcess(historyData, 0, outData, outOffset, historyLength + bytesToCopy, this.readBytes, this.writeBytes, this.frameNumber, this.regions, this.regionsTypes);
            if (this.readBytes[0] <= 0) {
                if (this.writeBytes[0] <= 0) {
                    return 4;
                }
                this.updateOutput(outputBuffer, this.outputFormat, this.writeBytes[0], 0);
                return 0;
            }
            outOffset += this.writeBytes[0];
            outLength += this.writeBytes[0];
            inpOffset += this.readBytes[0] - historyLength;
            inpLength += historyLength - this.readBytes[0];
        }
        this.codecProcess(inpData, inpOffset, outData, outOffset, inpLength, this.readBytes, this.writeBytes, this.frameNumber, this.regions, this.regionsTypes);
        System.arraycopy(inpData, inpOffset += this.readBytes[0], historyData, 0, inpLength -= this.readBytes[0]);
        this.history.setLength(inpLength);
        this.updateOutput(outputBuffer, this.outputFormat, outLength += this.writeBytes[0], 0);
        return 0;
    }

    protected abstract int calculateOutputSize(int var1);

    protected abstract int calculateFramesNumber(int var1);

    protected abstract boolean codecProcess(byte[] var1, int var2, byte[] var3, int var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10);
}

