/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicModule;
import com.sun.media.BasicMuxModule;
import com.sun.media.BasicProcessor;
import com.sun.media.BasicSinkModule;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphNode;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.OutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.SlowPlugIn;
import com.sun.media.codec.video.colorspace.RGBScaler;
import com.sun.media.controls.ProgressControl;
import com.sun.media.util.Resource;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessEngine
extends PlaybackEngine {
    protected BasicMuxModule muxModule;
    protected ContentDescriptor outputContentDes = null;
    String prefetchError = "Failed to prefetch: " + this;
    protected Vector targetMuxNames = null;
    protected GraphNode[] targetMuxes = null;
    protected GraphNode targetMux = null;
    protected Format[] targetMuxFormats = null;

    public ProcessEngine(BasicProcessor p) {
        super(p);
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] names = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        int i = 0;
        while (i < this.tracks.length) {
            this.trackControls[i] = new ProcTControl(this, this.tracks[i], this.source.getOutputConnector(names[i]));
            ++i;
        }
        if (!this.doConfigure2()) {
            return false;
        }
        this.outputContentDes = new ContentDescriptor("raw");
        this.reenableHintTracks();
        return true;
    }

    protected synchronized boolean doRealize() {
        this.targetMuxes = null;
        if (!super.doRealize1()) {
            return false;
        }
        if (this.targetMux != null && !this.connectMux()) {
            Log.error(this.realizeError);
            Log.error("  Cannot connect the multiplexer\n");
            this.player.processError = this.genericProcessorError;
            return false;
        }
        return super.doRealize2();
    }

    boolean isRTPFormat(Format fmt) {
        return fmt != null && fmt.getEncoding() != null && fmt.getEncoding().endsWith("rtp") || fmt.getEncoding().endsWith("RTP");
    }

    void reenableHintTracks() {
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.isRTPFormat(this.trackControls[i].getOriginalFormat())) {
                this.trackControls[i].setEnabled(true);
                break;
            }
            ++i;
        }
    }

    BasicMuxModule getMuxModule() {
        return this.muxModule;
    }

    boolean connectMux() {
        BasicTrackControl[] tcs = new BasicTrackControl[this.trackControls.length];
        int total = 0;
        Multiplexer mux = (Multiplexer)this.targetMux.plugin;
        int i = 0;
        while (i < this.trackControls.length) {
            if (this.trackControls[i].isEnabled()) {
                tcs[total++] = this.trackControls[i];
            }
            ++i;
        }
        try {
            mux.setContentDescriptor(this.outputContentDes);
        }
        catch (Exception e) {
            Log.comment("Failed to set the output content descriptor on the multiplexer.");
            return false;
        }
        boolean failed = false;
        if (mux.setNumTracks(this.targetMuxFormats.length) != this.targetMuxFormats.length) {
            Log.comment("Failed  to set number of tracks on the multiplexer.");
            return false;
        }
        int mf = 0;
        while (mf < this.targetMuxFormats.length) {
            if (this.targetMuxFormats[mf] == null || mux.setInputFormat(this.targetMuxFormats[mf], mf) == null) {
                Log.comment("Failed to set input format on the multiplexer.");
                failed = true;
                break;
            }
            ++mf;
        }
        if (failed) {
            return false;
        }
        if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify(mux, this.targetMuxFormats)) {
            return false;
        }
        BasicMuxModule bmm = new BasicMuxModule(mux, this.targetMuxFormats);
        if (PlaybackEngine.DEBUG) {
            bmm.setJMD(this.jmd);
        }
        int j = 0;
        while (j < this.targetMuxFormats.length) {
            InputConnector ic = bmm.getInputConnector(BasicMuxModule.ConnectorNamePrefix + j);
            if (ic == null) {
                Log.comment("BasicMuxModule: connector mismatched.");
                return false;
            }
            ic.setFormat(this.targetMuxFormats[j]);
            tcs[j].lastOC.setProtocol(ic.getProtocol());
            tcs[j].lastOC.connectTo(ic, this.targetMuxFormats[j]);
            ++j;
        }
        if (!bmm.doRealize()) {
            return false;
        }
        bmm.setModuleListener(this);
        bmm.setController(this);
        this.modules.addElement(bmm);
        this.sinks.addElement(bmm);
        this.muxModule = bmm;
        return true;
    }

    protected BasicSinkModule findMasterSink() {
        if (this.muxModule != null && this.muxModule.getClock() != null) {
            return this.muxModule;
        }
        return super.findMasterSink();
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        if (!this.doPrefetch1()) {
            return false;
        }
        if (this.muxModule != null && !this.muxModule.doPrefetch()) {
            Log.error(this.prefetchError);
            Log.error("  Cannot prefetch the multiplexer: " + this.muxModule.getMultiplexer() + "\n");
            return false;
        }
        return this.doPrefetch2();
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        if (this.muxModule != null) {
            this.muxModule.doStart();
        }
        this.doStart2();
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        if (this.muxModule != null) {
            this.muxModule.doStop();
        }
        this.doStop2();
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getTrackControls " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        return this.trackControls;
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getSupportedContentDescriptors " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        Vector names = PlugInManager.getPlugInList(null, null, 5);
        Vector<Format> fmts = new Vector<Format>();
        int i = 0;
        while (i < names.size()) {
            Format[] fs = PlugInManager.getSupportedOutputFormats((String)names.elementAt(i), 5);
            if (fs != null) {
                int j = 0;
                while (j < fs.length) {
                    if (fs[j] instanceof ContentDescriptor) {
                        boolean duplicate = false;
                        int k = 0;
                        while (k < fmts.size()) {
                            if (fmts.elementAt(k).equals(fs[j])) {
                                duplicate = true;
                                break;
                            }
                            ++k;
                        }
                        if (!duplicate) {
                            fmts.addElement(fs[j]);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        ContentDescriptor[] cds = new ContentDescriptor[fmts.size()];
        i = 0;
        while (i < fmts.size()) {
            cds[i] = (ContentDescriptor)fmts.elementAt(i);
            ++i;
        }
        return cds;
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        Vector cnames;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("setContentDescriptor " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        if (this.getState() > 180) {
            return null;
        }
        if (ocd != null && ((cnames = PlugInManager.getPlugInList(null, ocd, 5)) == null || cnames.size() == 0)) {
            return null;
        }
        this.outputContentDes = ocd;
        return this.outputContentDes;
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getContentDescriptor " + PlaybackEngine.NOT_CONFIGURED_ERROR));
        }
        return this.outputContentDes;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("getDataOutput " + PlaybackEngine.NOT_REALIZED_ERROR));
        }
        if (this.muxModule != null) {
            return this.muxModule.getDataOutput();
        }
        return null;
    }

    protected long getBitRate() {
        if (this.muxModule != null) {
            return this.muxModule.getBitsWritten();
        }
        return this.source.getBitsRead();
    }

    protected void resetBitRate() {
        if (this.muxModule != null) {
            this.muxModule.resetBitsWritten();
        } else {
            this.source.resetBitsRead();
        }
    }

    protected PlugIn getPlugIn(BasicModule m) {
        if (m instanceof BasicMuxModule) {
            return ((BasicMuxModule)m).getMultiplexer();
        }
        return super.getPlugIn(m);
    }

    class ProcGraphBuilder
    extends SimpleGraphBuilder {
        protected ProcessEngine engine;
        protected Format targetFormat;
        protected int trackID = 0;
        protected int numTracks = 1;
        protected int nodesVisited = 0;
        Codec[] codecs = null;
        Renderer rend = null;
        Format format = null;

        ProcGraphBuilder(ProcessEngine engine) {
            this.engine = engine;
        }

        public Format[] getSupportedOutputFormats(Format input) {
            long formatsTime = System.currentTimeMillis();
            Vector<Format> collected = new Vector<Format>();
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            GraphNode node = new GraphNode(null, null, input, null, 0);
            candidates.addElement(node);
            collected.addElement(input);
            ++this.nodesVisited;
            while (!candidates.isEmpty()) {
                this.doGetSupportedOutputFormats(candidates, collected);
            }
            Format[] all = new Format[collected.size()];
            int front = 0;
            int back = all.length - 1;
            AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
            boolean mpegInput = new AudioFormat("mpegaudio").matches(input) || new AudioFormat("mpeglayer3").matches(input) || new VideoFormat("mpeg").matches(input);
            int i = 0;
            while (i < all.length) {
                Object obj = collected.elementAt(i);
                if (!mpegInput && ((Format)mpegAudio).matches((Format)obj)) {
                    all[back--] = (Format)obj;
                } else {
                    all[front++] = (Format)obj;
                }
                ++i;
            }
            Log.comment("Getting the supported output formats for:");
            Log.comment("  " + input);
            Log.comment("  # of nodes visited: " + this.nodesVisited);
            Log.comment("  # of formats supported: " + all.length + "\n");
            PlaybackEngine.profile("getSupportedOutputFormats", formatsTime);
            return all;
        }

        void doGetSupportedOutputFormats(Vector candidates, Vector collected) {
            Format input;
            Format[] outs;
            GraphNode node = (GraphNode)candidates.firstElement();
            candidates.removeElementAt(0);
            if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
                Log.error("Internal error: doGetSupportedOutputFormats");
                return;
            }
            if (node.plugin != null && SimpleGraphBuilder.verifyInput(node.plugin, node.input) == null) {
                return;
            }
            if (node.plugin != null) {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return;
                }
                int j = 0;
                while (j < outs.length) {
                    int size = collected.size();
                    boolean found = false;
                    int k = 0;
                    while (k < size) {
                        Format other = (Format)collected.elementAt(k);
                        if (other == outs[j] || other.equals(outs[j])) {
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        collected.addElement(outs[j]);
                    }
                    ++j;
                }
                input = node.input;
            } else {
                outs = new Format[]{node.input};
                input = null;
            }
            if (node.level >= this.STAGES) {
                return;
            }
            int i = 0;
            while (i < outs.length) {
                Vector cnames;
                if (!(input != null && input.equals(outs[i]) || node.plugin != null && SimpleGraphBuilder.verifyOutput(node.plugin, outs[i]) == null || (cnames = PlugInManager.getPlugInList(outs[i], null, 2)) == null || cnames.size() == 0)) {
                    int j = 0;
                    while (j < cnames.size()) {
                        Format[] ins;
                        Format fmt;
                        GraphNode gn = SimpleGraphBuilder.getPlugInNode((String)cnames.elementAt(j), 2, this.plugIns);
                        if (gn != null && !gn.checkAttempted(outs[i]) && (fmt = SimpleGraphBuilder.matches(outs[i], ins = gn.getSupportedInputs(), null, gn.plugin)) != null) {
                            GraphNode n = new GraphNode(gn, fmt, node, node.level + 1);
                            candidates.addElement(n);
                            ++this.nodesVisited;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        boolean buildGraph(BasicTrackControl tc, int trackID, int numTracks) {
            this.trackID = trackID;
            this.numTracks = numTracks;
            if (tc.isCustomized()) {
                Log.comment("Input: " + tc.getOriginalFormat());
                return this.buildCustomGraph((ProcTControl)tc);
            }
            return super.buildGraph(tc);
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
            return this.engine.buildTrackFromGraph((ProcTControl)tc, node);
        }

        GraphNode findTarget(GraphNode node) {
            GraphNode n;
            Format[] outs;
            if (node.plugin == null) {
                outs = new Format[]{node.input};
            } else if (node.output != null) {
                outs = new Format[]{node.output};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return null;
                }
            }
            if (this.targetFormat != null) {
                Format matched = null;
                matched = SimpleGraphBuilder.matches(outs, this.targetFormat, node.plugin, null);
                if (matched == null) {
                    return null;
                }
                if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify((Codec)node.plugin, node.input, matched)) {
                    return null;
                }
                if (this.targetPlugins == null && ProcessEngine.this.targetMuxes == null) {
                    node.output = matched;
                    return node;
                }
                outs = new Format[]{matched};
            }
            if (this.targetPlugins != null) {
                n = this.verifyTargetPlugins(node, outs);
                if (n != null) {
                    return n;
                }
                return null;
            }
            if (ProcessEngine.this.targetMuxes != null && (n = this.verifyTargetMuxes(node, outs)) != null) {
                return n;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        GraphNode verifyTargetMuxes(GraphNode node, Format[] outs) {
            i = 0;
            while (i < ProcessEngine.this.targetMuxes.length) {
                block13: {
                    gn = ProcessEngine.this.targetMuxes[i];
                    if (gn != null) ** GOTO lbl19
                    name = (String)ProcessEngine.this.targetMuxNames.elementAt(i);
                    if (name == null) break block13;
                    gn = SimpleGraphBuilder.getPlugInNode(name, 5, this.plugIns);
                    if (gn == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                    } else {
                        mux = (Multiplexer)gn.plugin;
                        if (mux.setContentDescriptor(ProcessEngine.this.outputContentDes) == null) {
                            ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        } else if (mux.setNumTracks(this.numTracks) != this.numTracks) {
                            ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        } else {
                            ProcessEngine.this.targetMuxes[i] = gn;
lbl19:
                            // 2 sources

                            if (ProcessEngine.this.targetMux == null || gn == ProcessEngine.this.targetMux) {
                                j = 0;
                                while (j < outs.length) {
                                    fmt = ((Multiplexer)gn.plugin).setInputFormat(outs[j], this.trackID);
                                    if (fmt != null && (SimpleGraphBuilder.inspector == null || node.plugin == null || SimpleGraphBuilder.inspector.verify((Codec)node.plugin, node.input, fmt))) {
                                        ProcessEngine.this.targetMux = gn;
                                        ProcessEngine.this.targetMuxFormats[this.trackID] = fmt;
                                        node.output = fmt;
                                        return node;
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            return null;
        }

        boolean setDefaultTargets(Format in) {
            if (ProcessEngine.this.outputContentDes != null) {
                return this.setDefaultTargetMux();
            }
            return this.setDefaultTargetRenderer(in);
        }

        boolean setDefaultTargetRenderer(Format in) {
            if (!super.setDefaultTargetRenderer(in)) {
                return false;
            }
            ProcessEngine.this.targetMuxes = null;
            return true;
        }

        boolean setDefaultTargetMux() {
            if (ProcessEngine.this.targetMuxes != null) {
                return true;
            }
            Log.comment("An output content type is specified: " + ProcessEngine.this.outputContentDes);
            ProcessEngine.this.targetMuxNames = PlugInManager.getPlugInList(null, ProcessEngine.this.outputContentDes, 5);
            if (ProcessEngine.this.targetMuxNames == null || ProcessEngine.this.targetMuxNames.size() == 0) {
                Log.error("No multiplexer is found for that content type: " + ProcessEngine.this.outputContentDes);
                return false;
            }
            ProcessEngine.this.targetMuxes = new GraphNode[ProcessEngine.this.targetMuxNames.size()];
            ProcessEngine.this.targetMux = null;
            ProcessEngine.this.targetMuxFormats = new Format[this.numTracks];
            this.targetPluginNames = null;
            this.targetPlugins = null;
            return true;
        }

        void setTargetPlugin(PlugIn p, int type) {
            this.targetPlugins = new GraphNode[1];
            this.targetPlugins[0] = new GraphNode(p, null, null, 0);
            this.targetPlugins[0].custom = true;
            this.targetPlugins[0].type = type;
        }

        boolean buildCustomGraph(ProcTControl tc) {
            GraphNode failed;
            GraphNode node;
            this.codecs = tc.codecChainWanted;
            this.rend = tc.rendererWanted;
            this.format = tc.formatWanted;
            if (this.format instanceof VideoFormat && tc.getOriginalFormat() instanceof VideoFormat) {
                Dimension s1 = ((VideoFormat)tc.getOriginalFormat()).getSize();
                Dimension s2 = ((VideoFormat)this.format).getSize();
                if (s1 != null && s2 != null && !s1.equals(s2)) {
                    RGBScaler scaler = new RGBScaler(s2);
                    if (this.codecs == null || this.codecs.length == 0) {
                        this.codecs = new Codec[1];
                        this.codecs[0] = scaler;
                    } else {
                        int i;
                        this.codecs = new Codec[tc.codecChainWanted.length + 1];
                        if (!PlaybackEngine.isRawVideo(this.format)) {
                            this.codecs[0] = scaler;
                            i = 1;
                        } else {
                            this.codecs[tc.codecChainWanted.length] = scaler;
                            i = 0;
                        }
                        int j = 0;
                        while (j < tc.codecChainWanted.length) {
                            this.codecs[i++] = tc.codecChainWanted[j];
                            ++j;
                        }
                    }
                }
            }
            return (node = this.buildCustomGraph(tc.getOriginalFormat())) != null && (failed = this.buildTrackFromGraph(tc, node)) == null;
        }

        GraphNode buildCustomGraph(Format in) {
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            Object n = null;
            GraphNode node = new GraphNode(null, null, in, null, 0);
            candidates.addElement(node);
            Log.comment("Custom options specified.");
            this.indent = 1;
            Log.setIndent(this.indent);
            if (this.codecs != null) {
                this.resetTargets();
                int i = 0;
                while (i < this.codecs.length) {
                    if (this.codecs[i] != null) {
                        Log.comment("A custom codec is specified: " + this.codecs[i]);
                        this.setTargetPlugin(this.codecs[i], 2);
                        node = this.buildGraph(candidates);
                        if (node == null) {
                            Log.error("The input format is not compatible with the given codec plugin: " + this.codecs[i]);
                            this.indent = 0;
                            Log.setIndent(this.indent);
                            return null;
                        }
                        node.level = 0;
                        candidates = new Vector();
                        candidates.addElement(node);
                    }
                    ++i;
                }
            }
            if (ProcessEngine.this.outputContentDes != null) {
                this.resetTargets();
                if (this.format != null) {
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                }
                if (!this.setDefaultTargetMux()) {
                    return null;
                }
                node = this.buildGraph(candidates);
                if (node == null) {
                    Log.error("Failed to build a graph for the given custom options.");
                    this.indent = 0;
                    Log.setIndent(this.indent);
                    return null;
                }
            } else {
                if (this.format != null) {
                    this.resetTargets();
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        Log.error("The input format cannot be transcoded to the specified target format.");
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    node.level = 0;
                    candidates = new Vector();
                    candidates.addElement(node);
                    this.targetFormat = null;
                }
                if (this.rend != null) {
                    Log.comment("A custom renderer is specified: " + this.rend);
                    this.setTargetPlugin(this.rend, 4);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        if (this.format != null) {
                            Log.error("The customed transocoded format is not compatible with the given renderer plugin: " + this.rend);
                        } else {
                            Log.error("The input format is not compatible with the given renderer plugin: " + this.rend);
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                } else {
                    if (!this.setDefaultTargetRenderer(this.format == null ? in : this.format)) {
                        return null;
                    }
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        if (this.format != null) {
                            Log.error("Failed to find a renderer that supports the customed transcoded format.");
                        } else {
                            Log.error("Failed to build a graph to render the input format with the given custom options.");
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                }
            }
            this.indent = 0;
            Log.setIndent(this.indent);
            return node;
        }

        public void reset() {
            super.reset();
            this.resetTargets();
        }

        void resetTargets() {
            this.targetFormat = null;
            this.targetPlugins = null;
        }
    }

    class ProcTControl
    extends BasicTrackControl
    implements Owned {
        protected Format formatWanted = null;
        protected Codec[] codecChainWanted = null;
        protected Renderer rendererWanted = null;
        protected ProcGraphBuilder gb;
        protected Format[] supportedFormats = null;

        public ProcTControl(ProcessEngine engine, Track track, OutputConnector oc) {
            super(engine, track, oc);
        }

        public Object getOwner() {
            return ProcessEngine.this.player;
        }

        public Format getFormat() {
            return this.formatWanted == null ? this.track.getFormat() : this.formatWanted;
        }

        public Format[] getSupportedFormats() {
            if (this.supportedFormats == null && (this.supportedFormats = Resource.getDB(this.track.getFormat())) == null) {
                if (this.gb == null) {
                    this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
                } else {
                    this.gb.reset();
                }
                this.supportedFormats = this.gb.getSupportedOutputFormats(this.track.getFormat());
                this.supportedFormats = Resource.putDB(this.track.getFormat(), this.supportedFormats);
                PlaybackEngine.needSavingDB = true;
            }
            if (ProcessEngine.this.outputContentDes != null) {
                return this.verifyMuxInputs(ProcessEngine.this.outputContentDes, this.supportedFormats);
            }
            return this.supportedFormats;
        }

        Format[] verifyMuxInputs(ContentDescriptor cd, Format[] inputs) {
            if (cd == null || cd.getEncoding() == "raw") {
                return inputs;
            }
            Vector cnames = PlugInManager.getPlugInList(null, cd, 5);
            if (cnames == null || cnames.size() == 0) {
                return new Format[0];
            }
            Multiplexer[] mux = new Multiplexer[cnames.size()];
            int total = 0;
            int i = 0;
            while (i < cnames.size()) {
                block13: {
                    Multiplexer m = (Multiplexer)SimpleGraphBuilder.createPlugIn((String)cnames.elementAt(i), 5);
                    if (m != null) {
                        try {
                            m.setContentDescriptor(ProcessEngine.this.outputContentDes);
                        }
                        catch (Exception e) {
                            break block13;
                        }
                        if (m.setNumTracks(1) >= 1) {
                            mux[total++] = m;
                        }
                    }
                }
                ++i;
            }
            Format[] tmp = new Format[inputs.length];
            int vtotal = 0;
            int i2 = 0;
            while (i2 < inputs.length) {
                Format fmt;
                if (total == 1) {
                    fmt = mux[0].setInputFormat(inputs[i2], 0);
                    if (fmt != null) {
                        tmp[vtotal++] = fmt;
                    }
                } else {
                    int j = 0;
                    while (j < total) {
                        fmt = mux[j].setInputFormat(inputs[i2], 0);
                        if (fmt != null) {
                            tmp[vtotal++] = fmt;
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            Format[] verified = new Format[vtotal];
            System.arraycopy(tmp, 0, verified, 0, vtotal);
            return verified;
        }

        public Format setFormat(Format format) {
            if (this.engine.getState() > 180) {
                return this.getFormat();
            }
            if (format == null || format.matches(this.track.getFormat())) {
                return format;
            }
            this.formatWanted = this.checkSize(format);
            return this.formatWanted;
        }

        private Format checkSize(Format fmt) {
            Format ofmt;
            if (!(fmt instanceof VideoFormat)) {
                return fmt;
            }
            VideoFormat vfmt = (VideoFormat)fmt;
            Dimension size = ((VideoFormat)fmt).getSize();
            if (size == null && ((ofmt = this.getOriginalFormat()) == null || (size = ((VideoFormat)ofmt).getSize()) == null)) {
                return fmt;
            }
            int w = size.width;
            int h = size.height;
            if (fmt.matches(new VideoFormat("jpeg/rtp")) || fmt.matches(new VideoFormat("jpeg"))) {
                if (size.width % 8 != 0) {
                    w = size.width / 8 * 8;
                }
                if (size.height % 8 != 0) {
                    h = size.height / 8 * 8;
                }
                if (w == 0 || h == 0) {
                    w = size.width;
                    h = size.height;
                }
            } else if (fmt.matches(new VideoFormat("h263/rtp")) || fmt.matches(new VideoFormat("h263-1998/rtp")) || fmt.matches(new VideoFormat("h263"))) {
                if (size.width >= 352) {
                    w = 352;
                    h = 288;
                } else if (size.width >= 160) {
                    w = 176;
                    h = 144;
                } else {
                    w = 128;
                    h = 96;
                }
            }
            if (w != size.width || h != size.height) {
                Log.comment("setFormat: " + fmt.getEncoding() + ": video aspect ratio mismatched.");
                Log.comment("  Scaled from " + size.width + "x" + size.height + " to " + w + "x" + h + ".\n");
                fmt = new VideoFormat(null, new Dimension(w, h), -1, null, -1.0f).intersects(fmt);
            }
            return fmt;
        }

        public boolean buildTrack(int trackID, int numTracks) {
            if (this.gb == null) {
                this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
            } else {
                this.gb.reset();
            }
            boolean rtn = this.gb.buildGraph(this, trackID, numTracks);
            this.gb = null;
            return rtn;
        }

        public boolean isTimeBase() {
            int j = 0;
            while (j < this.modules.size()) {
                if (this.modules.elementAt(j) == ProcessEngine.this.masterSink) {
                    return true;
                }
                ++j;
            }
            return false;
        }

        public void setCodecChain(Codec[] codec) throws NotConfiguredError, UnsupportedPlugInException {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            if (codec.length < 1) {
                throw new UnsupportedPlugInException("No codec specified in the array.");
            }
            this.codecChainWanted = new Codec[codec.length];
            int i = 0;
            while (i < codec.length) {
                this.codecChainWanted[i] = codec[i];
                ++i;
            }
        }

        public void setRenderer(Renderer renderer) throws NotConfiguredError {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            this.rendererWanted = renderer;
            if (renderer instanceof SlowPlugIn) {
                ((SlowPlugIn)((Object)renderer)).forceToUse();
            }
        }

        public boolean isCustomized() {
            return this.formatWanted != null || this.codecChainWanted != null || this.rendererWanted != null;
        }

        public void prError() {
            if (!this.isCustomized()) {
                super.prError();
                return;
            }
            Log.error("  Cannot build a flow graph with the customized options:");
            if (this.formatWanted != null) {
                Log.error("    Unable to transcode format: " + this.getOriginalFormat());
                Log.error("      to: " + this.getFormat());
                if (ProcessEngine.this.outputContentDes != null) {
                    Log.error("      outputting to: " + ProcessEngine.this.outputContentDes);
                }
            }
            if (this.codecChainWanted != null) {
                Log.error("    Unable to add customed codecs: ");
                int i = 0;
                while (i < this.codecChainWanted.length) {
                    Log.error("      " + this.codecChainWanted[i]);
                    ++i;
                }
            }
            if (this.rendererWanted != null) {
                Log.error("    Unable to add customed renderer: " + this.rendererWanted);
            }
            Log.write("\n");
        }

        protected ProgressControl progressControl() {
            return ProcessEngine.this.progressControl;
        }

        protected FrameRateControl frameRateControl() {
            this.muxModule = ProcessEngine.this.getMuxModule();
            return ProcessEngine.this.frameRateControl;
        }
    }
}

