/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.BufferListener;
import com.sun.media.protocol.rtp.DataSource;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.util.RTPMediaThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable {
    private DataSource dsource;
    private Format format = null;
    BufferTransferHandler handler = null;
    boolean started = false;
    boolean killed = false;
    boolean replenish = true;
    PktQue pktQ;
    Object startReq = new Object();
    private RTPMediaThread thread = null;
    private boolean hasRead = false;
    private int DEFAULT_AUDIO_RATE = 8000;
    private int DEFAULT_VIDEO_RATE = 15;
    private BufferControlImpl bc = null;
    private long lastSeqRecv = -1L;
    private long lastSeqSent = -1L;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private static final int NOT_SPECIFIED = -1;
    private BufferListener listener = null;
    private int threshold = 0;
    private boolean prebuffering = false;
    private boolean prebufferNotice = false;
    private boolean bufferWhenStopped = true;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static /* synthetic */ Class class$com$sun$media$rtp$util$RTPMediaThread;

    public RTPSourceStream(DataSource dsource) {
        this.dsource = dsource;
        dsource.setSourceStream(this);
        this.pktQ = new PktQue(4);
        this.createThread();
    }

    public void setBufferControl(BufferControl b) {
        this.bc = (BufferControlImpl)b;
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public long updateBuffer(long len) {
        return len;
    }

    public long updateThreshold(long threshold) {
        return threshold;
    }

    public void setBufferListener(BufferListener listener) {
        this.listener = listener;
    }

    public void add(Buffer filled, boolean wrapped, RTPRawReceiver rtpr) {
        if (!this.started && !this.bufferWhenStopped) {
            return;
        }
        if (this.lastSeqRecv - filled.getSequenceNumber() > 256L) {
            this.pktQ.reset();
        }
        this.lastSeqRecv = filled.getSequenceNumber();
        boolean overflown = false;
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.pktQ.monitorQueueSize(filled, rtpr);
            if (this.pktQ.noMoreFree()) {
                long head = this.pktQ.getFirstSeq();
                if (head != -1L && filled.getSequenceNumber() < head) {
                    return;
                }
                this.pktQ.dropPkt();
            }
        }
        if (this.pktQ.totalFree() <= 1) {
            overflown = true;
        }
        Buffer buf = this.pktQ.getFree();
        byte[] inData = (byte[])filled.getData();
        byte[] outData = (byte[])buf.getData();
        if (outData == null || outData.length < inData.length) {
            outData = new byte[inData.length];
        }
        System.arraycopy(inData, filled.getOffset(), outData, filled.getOffset(), filled.getLength());
        buf.copy(filled);
        buf.setData(outData);
        if (overflown) {
            buf.setFlags(buf.getFlags() | 0x2000 | 0x20);
        } else {
            buf.setFlags(buf.getFlags() | 0x20);
        }
        this.pktQ.addPkt(buf);
        PktQue pktQue2 = this.pktQ;
        synchronized (pktQue2) {
            if (this.started && this.prebufferNotice && this.listener != null && this.pktQ.totalPkts() >= this.threshold) {
                this.listener.minThresholdReached(this.dsource);
                this.prebufferNotice = false;
                this.prebuffering = false;
                Object object = this.startReq;
                synchronized (object) {
                    this.startReq.notifyAll();
                }
            }
            if (this.replenish && this.format instanceof AudioFormat) {
                if (this.pktQ.totalPkts() >= this.pktQ.size / 2) {
                    this.replenish = false;
                    this.pktQ.notifyAll();
                }
            } else {
                this.pktQ.notifyAll();
            }
        }
    }

    public void read(Buffer buf) {
        if (this.pktQ.totalPkts() == 0) {
            buf.setDiscard(true);
            return;
        }
        Buffer pkt = this.pktQ.getPkt();
        this.lastSeqSent = pkt.getSequenceNumber();
        Object data = buf.getData();
        Object hdr = buf.getHeader();
        buf.copy(pkt);
        pkt.setData(data);
        pkt.setHeader(hdr);
        this.pktQ.returnFree(pkt);
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.hasRead = true;
            if (this.format instanceof AudioFormat) {
                if (this.pktQ.totalPkts() > 0) {
                    this.pktQ.notifyAll();
                } else {
                    this.replenish = true;
                }
            } else {
                this.pktQ.notifyAll();
            }
        }
    }

    public void reset() {
        this.pktQ.reset();
        this.lastSeqSent = -1L;
    }

    public Format getFormat() {
        return this.format;
    }

    protected void setFormat(Format format) {
        this.format = format;
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.handler = transferHandler;
    }

    void setContentDescriptor(String contentType) {
        this.contentDescriptor = new ContentDescriptor(contentType);
    }

    public void setBufferWhenStopped(boolean flag) {
        this.bufferWhenStopped = flag;
    }

    public void prebuffer() {
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.prebuffering = true;
            this.prebufferNotice = true;
        }
    }

    public void start() {
        Object object = this.startReq;
        synchronized (object) {
            this.started = true;
            this.startReq.notifyAll();
        }
    }

    public void stop() {
        Object object = this.startReq;
        synchronized (object) {
            this.started = false;
            this.prebuffering = false;
            if (!this.bufferWhenStopped) {
                this.reset();
            }
        }
    }

    public void connect() {
        this.killed = false;
        this.createThread();
    }

    public void close() {
        if (this.killed) {
            return;
        }
        this.stop();
        this.killed = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.pktQ.notifyAll();
        }
        this.thread = null;
        if (this.bc != null) {
            this.bc.removeSourceStream(this);
        }
    }

    public void run() {
        while (true) {
            try {
                Object object = this.startReq;
                synchronized (object) {
                    while (!(this.started && !this.prebuffering || this.killed)) {
                        this.startReq.wait();
                    }
                }
                PktQue pktQue = this.pktQ;
                synchronized (pktQue) {
                    do {
                        if (!this.hasRead && !this.killed) {
                            this.pktQ.wait();
                        }
                        this.hasRead = false;
                    } while (this.pktQ.totalPkts() <= 0 && !this.killed);
                }
                if (this.killed) break;
                if (this.handler == null) continue;
                this.handler.transferData(this);
            }
            catch (InterruptedException e) {
                Log.error("Thread " + e.getMessage());
            }
        }
    }

    private void createThread() {
        if (this.thread != null) {
            return;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12CreateThreadRunnableAction.cons;
                this.thread = (RTPMediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$rtp$util$RTPMediaThread == null ? (class$com$sun$media$rtp$util$RTPMediaThread = RTPSourceStream.class$("com.sun.media.rtp.util.RTPMediaThread")) : class$com$sun$media$rtp$util$RTPMediaThread, this));
                this.thread.setName("RTPStream");
                cons = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(this.thread, new Integer(MediaThread.getControlPriority())));
            }
            catch (Exception exception) {}
        } else {
            this.thread = new RTPMediaThread(this, "RTPStream");
            this.thread.useControlPriority();
        }
        this.thread.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ int access$200(RTPSourceStream x0) {
        return x0.DEFAULT_VIDEO_RATE;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class PktQue {
        int FUDGE = 5;
        int DEFAULT_AUD_PKT_SIZE = 256;
        int DEFAULT_MILLISECS_PER_PKT = 30;
        int DEFAULT_PKTS_TO_BUFFER = 30;
        int MIN_BUF_CHECK = 10;
        int BUF_CHECK_INTERVAL = 7;
        int pktsEst;
        int framesEst = 0;
        int fps = 15;
        int pktsPerFrame = RTPSourceStream.access$200(RTPSourceStream.this);
        int sizePerPkt = this.DEFAULT_AUD_PKT_SIZE;
        int maxPktsToBuffer = 0;
        int sockBufSize = 0;
        int tooMuchBufferingCount = 0;
        long lastPktSeq = 0L;
        long lastCheckTime = 0L;
        Buffer[] fill;
        Buffer[] free;
        int headFill;
        int tailFill;
        int headFree;
        int tailFree;
        protected int size;

        public PktQue(int n) {
            this.allocBuffers(n);
        }

        public synchronized void reset() {
            while (this.moreFilled()) {
                this.returnFree(this.get());
            }
            this.tooMuchBufferingCount = 0;
            this.notifyAll();
        }

        public int totalPkts() {
            return this.tailFill >= this.headFill ? this.tailFill - this.headFill : this.size - (this.headFill - this.tailFill);
        }

        public int totalFree() {
            return this.tailFree >= this.headFree ? this.tailFree - this.headFree : this.size - (this.headFree - this.tailFree);
        }

        public synchronized void addPkt(Buffer buf) {
            long head = -1L;
            long tail = -1L;
            long seq = buf.getSequenceNumber();
            if (this.moreFilled()) {
                head = this.fill[this.headFill].getSequenceNumber();
                int i = this.tailFill - 1;
                if (i < 0) {
                    i = this.size - 1;
                }
                tail = this.fill[i].getSequenceNumber();
            }
            if (head == -1L && tail == -1L) {
                this.append(buf);
            } else if (seq < head) {
                this.prepend(buf);
            } else if (head < seq && seq < tail) {
                this.insert(buf);
            } else if (seq > tail) {
                this.append(buf);
            } else {
                this.returnFree(buf);
            }
        }

        public void monitorQueueSize(Buffer buf, RTPRawReceiver rtpr) {
            this.sizePerPkt = (this.sizePerPkt + buf.getLength()) / 2;
            if (RTPSourceStream.this.format instanceof VideoFormat) {
                int pktsToBuffer;
                this.pktsEst = this.lastPktSeq + 1L == buf.getSequenceNumber() ? ++this.pktsEst : 1;
                this.lastPktSeq = buf.getSequenceNumber();
                if (mpegVideo.matches(RTPSourceStream.this.format)) {
                    int offset;
                    byte[] payload = (byte[])buf.getData();
                    int ptype = payload[(offset = buf.getOffset()) + 2] & 7;
                    if (ptype < 3 && (buf.getFlags() & 0x800) != 0) {
                        this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                        this.pktsEst = 0;
                    }
                    this.fps = 30;
                } else if ((buf.getFlags() & 0x800) != 0) {
                    this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                    this.pktsEst = 0;
                    ++this.framesEst;
                    long now = System.currentTimeMillis();
                    if (now - this.lastCheckTime >= 1000L) {
                        this.lastCheckTime = now;
                        this.fps = (this.fps + this.framesEst) / 2;
                        this.framesEst = 0;
                        if (this.fps > 30) {
                            this.fps = 30;
                        }
                    }
                }
                if (RTPSourceStream.this.bc != null) {
                    pktsToBuffer = (int)(RTPSourceStream.this.bc.getBufferLength() * (long)this.fps / 1000L);
                    if (pktsToBuffer <= 0) {
                        pktsToBuffer = 1;
                    }
                    pktsToBuffer = this.pktsPerFrame * pktsToBuffer;
                    RTPSourceStream.this.threshold = (int)(RTPSourceStream.this.bc.getMinimumThreshold() * (long)this.fps / 1000L * (long)this.pktsPerFrame);
                    if (RTPSourceStream.this.threshold > pktsToBuffer / 2) {
                        // empty if block
                    }
                    RTPSourceStream.this.threshold = pktsToBuffer / 2;
                } else {
                    pktsToBuffer = this.DEFAULT_PKTS_TO_BUFFER;
                }
                this.maxPktsToBuffer = this.maxPktsToBuffer > 0 ? (this.maxPktsToBuffer + pktsToBuffer) / 2 : pktsToBuffer;
                int tot = this.totalPkts();
                if (this.size > this.MIN_BUF_CHECK && tot < this.size / 4) {
                    if (!RTPSourceStream.this.prebuffering && this.tooMuchBufferingCount++ > this.pktsPerFrame * this.fps * this.BUF_CHECK_INTERVAL) {
                        this.cutByHalf();
                        this.tooMuchBufferingCount = 0;
                    }
                } else if (tot >= this.size / 2 && this.size < this.maxPktsToBuffer) {
                    pktsToBuffer = this.size + this.size / 2;
                    if (pktsToBuffer > this.maxPktsToBuffer) {
                        pktsToBuffer = this.maxPktsToBuffer;
                    }
                    this.grow(pktsToBuffer + this.FUDGE);
                    Log.comment("RTP video buffer size: " + this.size + " pkts, " + pktsToBuffer * this.sizePerPkt + " bytes.\n");
                    this.tooMuchBufferingCount = 0;
                } else {
                    this.tooMuchBufferingCount = 0;
                }
                int sizeToBuffer = pktsToBuffer * this.sizePerPkt / 2;
                if (rtpr != null && sizeToBuffer > this.sockBufSize) {
                    rtpr.setRecvBufSize(sizeToBuffer);
                    this.sockBufSize = rtpr.getRecvBufSize() < sizeToBuffer ? Integer.MAX_VALUE : sizeToBuffer;
                    Log.comment("RTP video socket buffer size: " + rtpr.getRecvBufSize() + " bytes.\n");
                }
            } else if (RTPSourceStream.this.format instanceof AudioFormat) {
                if (this.sizePerPkt <= 0) {
                    this.sizePerPkt = this.DEFAULT_AUD_PKT_SIZE;
                }
                if (RTPSourceStream.this.bc != null) {
                    int lenPerPkt = mpegAudio.matches(RTPSourceStream.this.format) ? this.sizePerPkt / 4 : this.DEFAULT_MILLISECS_PER_PKT;
                    int pktsToBuffer = (int)(RTPSourceStream.this.bc.getBufferLength() / (long)lenPerPkt);
                    RTPSourceStream.this.threshold = (int)(RTPSourceStream.this.bc.getMinimumThreshold() / (long)lenPerPkt);
                    if (RTPSourceStream.this.threshold > pktsToBuffer / 2) {
                        // empty if block
                    }
                    RTPSourceStream.this.threshold = pktsToBuffer / 2;
                    if (pktsToBuffer > this.size) {
                        this.grow(pktsToBuffer);
                        Log.comment("RTP audio buffer size: " + this.size + " pkts, " + pktsToBuffer * this.sizePerPkt + " bytes.\n");
                    }
                    int sizeToBuffer = pktsToBuffer * this.sizePerPkt / 2;
                    if (rtpr != null && sizeToBuffer > this.sockBufSize) {
                        rtpr.setRecvBufSize(sizeToBuffer);
                        this.sockBufSize = rtpr.getRecvBufSize() < sizeToBuffer ? Integer.MAX_VALUE : sizeToBuffer;
                        Log.comment("RTP audio socket buffer size: " + rtpr.getRecvBufSize() + " bytes.\n");
                    }
                }
            }
        }

        public synchronized Buffer getPkt() {
            while (!this.moreFilled()) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Buffer b = this.get();
            return b;
        }

        public void dropPkt() {
            while (!this.moreFilled()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (RTPSourceStream.this.format instanceof AudioFormat) {
                this.dropFirstPkt();
            } else if (mpegVideo.matches(RTPSourceStream.this.format)) {
                this.dropMpegPkt();
            } else {
                this.dropFirstPkt();
            }
        }

        public synchronized void dropFirstPkt() {
            Buffer buf = this.get();
            RTPSourceStream.this.lastSeqSent = buf.getSequenceNumber();
            this.returnFree(buf);
        }

        public synchronized void dropMpegPkt() {
            Buffer buf;
            int i = this.headFill;
            int firstP = -1;
            int firstB = -1;
            while (i != this.tailFill) {
                int offset;
                buf = this.fill[i];
                byte[] payload = (byte[])buf.getData();
                int ptype = payload[(offset = buf.getOffset()) + 2] & 7;
                if (ptype > 2) {
                    firstB = i;
                    break;
                }
                if (ptype == 2 && firstP == -1) {
                    firstP = i;
                }
                if (++i < this.size) continue;
                i = 0;
            }
            if (firstB == -1) {
                i = firstP == -1 ? this.headFill : firstP;
            }
            buf = this.fill[i];
            if (i == 0) {
                RTPSourceStream.this.lastSeqSent = buf.getSequenceNumber();
            }
            this.removeAt(i);
        }

        public synchronized long getFirstSeq() {
            if (!this.moreFilled()) {
                return -1L;
            }
            return this.fill[this.headFill].getSequenceNumber();
        }

        private void allocBuffers(int n) {
            this.fill = new Buffer[n];
            this.free = new Buffer[n];
            int i = 0;
            while (i < n - 1) {
                this.free[i] = new Buffer();
                ++i;
            }
            this.size = n;
            this.tailFill = 0;
            this.headFill = 0;
            this.headFree = 0;
            this.tailFree = this.size - 1;
        }

        private synchronized void grow(int newSize) {
            Buffer[] newFill = new Buffer[newSize];
            Buffer[] newFree = new Buffer[newSize];
            int totPkts = this.totalPkts();
            int totFree = this.totalFree();
            int i = this.headFill;
            int j = 0;
            while (i != this.tailFill) {
                newFill[j] = this.fill[i];
                if (++i >= this.size) {
                    i = 0;
                }
                ++j;
            }
            this.headFill = 0;
            this.tailFill = totPkts;
            this.fill = newFill;
            i = this.headFree;
            j = 0;
            while (i != this.tailFree) {
                newFree[j] = this.free[i];
                if (++i >= this.size) {
                    i = 0;
                }
                ++j;
            }
            this.headFree = 0;
            this.tailFree = totFree;
            i = newSize - this.size;
            while (i > 0) {
                newFree[this.tailFree] = new Buffer();
                ++this.tailFree;
                --i;
            }
            this.free = newFree;
            this.size = newSize;
        }

        private synchronized void cutByHalf() {
            int newSize = this.size / 2;
            if (newSize <= 0) {
                return;
            }
            Buffer[] newFill = new Buffer[this.size / 2];
            Buffer[] newFree = new Buffer[this.size / 2];
            int tot = this.totalPkts();
            int i = 0;
            while (i < newSize && i < tot) {
                newFill[i] = this.get();
                ++i;
            }
            tot = newSize - i - (this.size - tot - this.totalFree());
            this.headFill = 0;
            this.tailFill = i;
            i = 0;
            while (i <= tot) {
                newFree[i] = new Buffer();
                ++i;
            }
            this.headFree = 0;
            this.tailFree = tot;
            this.fill = newFill;
            this.free = newFree;
            this.size = newSize;
        }

        private synchronized Buffer get() {
            Buffer b = this.fill[this.headFill];
            this.fill[this.headFill] = null;
            ++this.headFill;
            if (this.headFill >= this.size) {
                this.headFill = 0;
            }
            return b;
        }

        private synchronized void append(Buffer b) {
            this.fill[this.tailFill] = b;
            ++this.tailFill;
            if (this.tailFill >= this.size) {
                this.tailFill = 0;
            }
        }

        private synchronized void prepend(Buffer b) {
            --this.headFill;
            if (this.headFill < 0) {
                this.headFill = 0;
            }
            this.fill[this.headFill] = b;
        }

        private synchronized void insert(Buffer b) {
            int i = this.headFill;
            while (i != this.tailFill) {
                if (this.fill[i].getSequenceNumber() > b.getSequenceNumber()) break;
                if (++i < this.size) continue;
                i = 0;
            }
            if (i != this.tailFill) {
                int prev;
                ++this.tailFill;
                if (this.tailFill >= this.size) {
                    this.tailFill = 0;
                }
                int j = prev = this.tailFill;
                do {
                    if (--prev < 0) {
                        prev = this.size - 1;
                    }
                    this.fill[j] = this.fill[prev];
                } while ((j = prev) != i);
                this.fill[i] = b;
            }
        }

        private void removeAt(int n) {
            Buffer buf = this.fill[n];
            if (n == this.headFill) {
                ++this.headFill;
                if (this.headFill >= this.size) {
                    this.headFill = 0;
                }
            } else if (n == this.tailFill) {
                --this.tailFill;
                if (this.tailFill < 0) {
                    this.tailFill = this.size - 1;
                }
            } else {
                int prev = n;
                do {
                    if (--prev < 0) {
                        prev = this.size - 1;
                    }
                    this.fill[n] = this.fill[prev];
                } while ((n = prev) != this.headFill);
                ++this.headFill;
                if (this.headFill >= this.size) {
                    this.headFill = 0;
                }
            }
            this.returnFree(buf);
        }

        private boolean moreFilled() {
            return this.headFill != this.tailFill;
        }

        public synchronized Buffer getFree() {
            Buffer b = this.free[this.headFree];
            this.free[this.headFree] = null;
            ++this.headFree;
            if (this.headFree >= this.size) {
                this.headFree = 0;
            }
            return b;
        }

        private synchronized void returnFree(Buffer b) {
            this.free[this.tailFree] = b;
            ++this.tailFree;
            if (this.tailFree >= this.size) {
                this.tailFree = 0;
            }
        }

        private boolean noMoreFree() {
            return this.headFree == this.tailFree;
        }
    }
}

