/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.MAC;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

abstract class HMAC
implements MAC {
    protected String name;
    protected int bsize;
    protected String algorithm;
    private Mac mac;
    private final byte[] tmp = new byte[4];

    HMAC() {
    }

    public int getBlockSize() {
        return this.bsize;
    }

    public void init(byte[] key2) throws Exception {
        if (key2.length > this.bsize) {
            byte[] tmp = new byte[this.bsize];
            System.arraycopy(key2, 0, tmp, 0, this.bsize);
            key2 = tmp;
        }
        SecretKeySpec skey = new SecretKeySpec(key2, this.algorithm);
        this.mac = Mac.getInstance(this.algorithm);
        this.mac.init(skey);
    }

    public void update(int i) {
        this.tmp[0] = (byte)(i >>> 24);
        this.tmp[1] = (byte)(i >>> 16);
        this.tmp[2] = (byte)(i >>> 8);
        this.tmp[3] = (byte)i;
        this.update(this.tmp, 0, 4);
    }

    public void update(byte[] foo, int s2, int l) {
        this.mac.update(foo, s2, l);
    }

    public void doFinal(byte[] buf, int offset) {
        try {
            this.mac.doFinal(buf, offset);
        }
        catch (ShortBufferException e2) {
            System.err.println(e2);
        }
    }

    public String getName() {
        return this.name;
    }
}

