/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;

public class RegexPathSpec
extends PathSpec {
    protected Pattern pattern;

    protected RegexPathSpec() {
    }

    public RegexPathSpec(String regex) {
        this.pathSpec = regex;
        if (regex.startsWith("regex|")) {
            this.pathSpec = regex.substring("regex|".length());
        }
        this.pathDepth = 0;
        this.specLength = this.pathSpec.length();
        boolean inGrouping = false;
        StringBuilder signature = new StringBuilder();
        block6: for (char c : this.pathSpec.toCharArray()) {
            switch (c) {
                case '[': {
                    inGrouping = true;
                    continue block6;
                }
                case ']': {
                    inGrouping = false;
                    signature.append('g');
                    continue block6;
                }
                case '*': {
                    signature.append('g');
                    continue block6;
                }
                case '/': {
                    if (inGrouping) continue block6;
                    ++this.pathDepth;
                    continue block6;
                }
                default: {
                    if (inGrouping || !Character.isLetterOrDigit(c)) continue block6;
                    signature.append('l');
                }
            }
        }
        this.pattern = Pattern.compile(this.pathSpec);
        String sig = signature.toString();
        this.group = Pattern.matches("^l*$", sig) ? PathSpecGroup.EXACT : (Pattern.matches("^l*g+", sig) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^g+l+$", sig) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
    }

    public Matcher getMatcher(String path2) {
        return this.pattern.matcher(path2);
    }

    @Override
    public String getPathInfo(String path2) {
        Matcher matcher;
        if (this.group == PathSpecGroup.PREFIX_GLOB && (matcher = this.getMatcher(path2)).matches() && matcher.groupCount() >= 1) {
            String pathInfo = matcher.group(1);
            if ("".equals(pathInfo)) {
                return "/";
            }
            return pathInfo;
        }
        return null;
    }

    @Override
    public String getPathMatch(String path2) {
        Matcher matcher = this.getMatcher(path2);
        if (matcher.matches()) {
            int idx;
            if (matcher.groupCount() >= 1 && (idx = matcher.start(1)) > 0) {
                if (path2.charAt(idx - 1) == '/') {
                    --idx;
                }
                return path2.substring(0, idx);
            }
            return path2;
        }
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getRelativePath(String base, String path2) {
        return null;
    }

    @Override
    public boolean matches(String path2) {
        int idx = path2.indexOf(63);
        if (idx >= 0) {
            return this.getMatcher(path2.substring(0, idx)).matches();
        }
        return this.getMatcher(path2).matches();
    }
}

