/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;
import org.openstreetmap.josm.gui.autofilter.AutoFilterRule;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DrawingPreference
implements SubPreferenceSetting {
    public static final BooleanProperty SOURCE_BOUNDS_PROP = new BooleanProperty("draw.data.downloaded_area", true);
    private GPXSettingsPanel gpxPanel;
    private final JCheckBox directionHint = new JCheckBox(I18n.tr("Draw Direction Arrows", new Object[0]));
    private final JCheckBox headArrow = new JCheckBox(I18n.tr("Only on the head of a way.", new Object[0]));
    private final JCheckBox onewayArrow = new JCheckBox(I18n.tr("Draw oneway arrows.", new Object[0]));
    private final JCheckBox segmentOrderNumber = new JCheckBox(I18n.tr("Draw segment order numbers", new Object[0]));
    private final JCheckBox segmentOrderNumberOnSelectedWay = new JCheckBox(I18n.tr("Draw segment order numbers on selected way", new Object[0]));
    private final JCheckBox sourceBounds = new JCheckBox(I18n.tr("Draw boundaries of downloaded data", new Object[0]));
    private final JCheckBox virtualNodes = new JCheckBox(I18n.tr("Draw virtual nodes in select mode", new Object[0]));
    private final JCheckBox inactive = new JCheckBox(I18n.tr("Draw inactive layers in other color", new Object[0]));
    private final JCheckBox discardableKeys = new JCheckBox(I18n.tr("Display discardable keys", new Object[0]));
    private final JCheckBox autoFilters = new JCheckBox(I18n.tr("Use auto filters", new Object[0]));
    private final JLabel lblRule = new JLabel(I18n.tr("Rule", new Object[0]));
    private final JosmComboBox<AutoFilterRule> autoFilterRules = new JosmComboBox<AutoFilterRule>(AutoFilterManager.getInstance().getAutoFilterRules().toArray(new AutoFilterRule[0]));
    private final JCheckBox useHighlighting = new JCheckBox(I18n.tr("Highlight target ways and nodes", new Object[0]));
    private final JCheckBox drawHelperLine = new JCheckBox(I18n.tr("Draw rubber-band helper line", new Object[0]));
    private final JCheckBox useAntialiasing = new JCheckBox(I18n.tr("Smooth map graphics (antialiasing)", new Object[0]));
    private final JCheckBox useWireframeAntialiasing = new JCheckBox(I18n.tr("Smooth map graphics in wireframe mode (antialiasing)", new Object[0]));
    private final JCheckBox outlineOnly = new JCheckBox(I18n.tr("Draw only outlines of areas", new Object[0]));
    private final JCheckBox hideLabelsWhileDragging = new JCheckBox(I18n.tr("Hide labels while dragging the map", new Object[0]));

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.addOsmPane(gui);
        this.addGpxPane(gui);
    }

    private void addGpxPane(PreferenceTabbedPane gui) {
        this.gpxPanel = new GPXSettingsPanel();
        gui.addValidationListener(this.gpxPanel);
        GPXSettingsPanel panel = this.gpxPanel;
        JScrollPane scrollpane = new JScrollPane(panel);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GuiHelper.setDefaultIncrement(scrollpane);
        gui.getDisplayPreference().addSubTab(this, I18n.tr("GPS Points", new Object[0]), scrollpane);
    }

    private void addOsmPane(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.directionHint.addActionListener(e -> {
            if (this.directionHint.isSelected()) {
                this.headArrow.setSelected(Config.getPref().getBoolean("draw.segment.head_only", false));
            } else {
                this.headArrow.setSelected(false);
            }
            this.headArrow.setEnabled(this.directionHint.isSelected());
        });
        this.directionHint.setToolTipText(I18n.tr("Draw direction hints for way segments.", new Object[0]));
        this.directionHint.setSelected(Config.getPref().getBoolean("draw.segment.direction", false));
        this.headArrow.setToolTipText(I18n.tr("Only on the head of a way.", new Object[0]));
        this.headArrow.setSelected(Config.getPref().getBoolean("draw.segment.head_only", false));
        this.headArrow.setEnabled(this.directionHint.isSelected());
        this.onewayArrow.setToolTipText(I18n.tr("Draw arrows in the direction of oneways and other directed features.", new Object[0]));
        this.onewayArrow.setSelected(Config.getPref().getBoolean("draw.oneway", true));
        this.segmentOrderNumber.setToolTipText(I18n.tr("Draw the order numbers of all segments within their way.", new Object[0]));
        this.segmentOrderNumber.setSelected(Config.getPref().getBoolean("draw.segment.order_number", false));
        this.segmentOrderNumberOnSelectedWay.setToolTipText(I18n.tr("Draw the order numbers of all segments within their way.", new Object[0]));
        this.segmentOrderNumberOnSelectedWay.setSelected(Config.getPref().getBoolean("draw.segment.order_number.on_selected", false));
        this.sourceBounds.setToolTipText(I18n.tr("Draw the boundaries of data loaded from the server.", new Object[0]));
        this.sourceBounds.setSelected(SOURCE_BOUNDS_PROP.get());
        this.virtualNodes.setToolTipText(I18n.tr("Draw virtual nodes in select mode for easy way modification.", new Object[0]));
        this.virtualNodes.setSelected(Config.getPref().getInt("mappaint.node.virtual-size", 8) != 0);
        this.inactive.setToolTipText(I18n.tr("Draw the inactive data layers in a different color.", new Object[0]));
        this.inactive.setSelected(Config.getPref().getBoolean("draw.data.inactive_color", true));
        this.useAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the map view resulting in a smoother appearance.", new Object[0]));
        this.useAntialiasing.setSelected(Config.getPref().getBoolean("mappaint.use-antialiasing", true));
        this.useWireframeAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the map view in wireframe mode resulting in a smoother appearance.", new Object[0]));
        this.useWireframeAntialiasing.setSelected(Config.getPref().getBoolean("mappaint.wireframe.use-antialiasing", false));
        this.useHighlighting.setToolTipText(I18n.tr("Hightlight target nodes and ways while drawing or selecting", new Object[0]));
        this.useHighlighting.setSelected(Config.getPref().getBoolean("draw.target-highlight", true));
        this.drawHelperLine.setToolTipText(I18n.tr("Draw rubber-band helper line", new Object[0]));
        this.drawHelperLine.setSelected(Config.getPref().getBoolean("draw.helper-line", true));
        this.outlineOnly.setToolTipText(I18n.tr("This option suppresses the filling of areas, overriding anything specified in the selected style.", new Object[0]));
        this.outlineOnly.setSelected(Config.getPref().getBoolean("draw.data.area_outline_only", false));
        this.hideLabelsWhileDragging.setToolTipText(I18n.tr("This option hides the textual labels of OSM objects while dragging the map.", new Object[0]));
        this.hideLabelsWhileDragging.setSelected(OsmDataLayer.PROPERTY_HIDE_LABELS_WHILE_DRAGGING.get());
        this.discardableKeys.setToolTipText(I18n.tr("Display keys which have been deemed uninteresting to the point that they can be silently removed.", new Object[0]));
        this.discardableKeys.setSelected(Config.getPref().getBoolean("display.discardable-keys", false));
        this.autoFilters.setToolTipText(I18n.tr("Display buttons to automatically filter numeric values of a predefined tag", new Object[0]));
        this.autoFilters.setSelected(AutoFilterManager.PROP_AUTO_FILTER_ENABLED.get());
        this.autoFilters.addActionListener(e -> {
            this.lblRule.setEnabled(this.autoFilters.isSelected());
            this.autoFilterRules.setEnabled(this.autoFilters.isSelected());
        });
        this.autoFilterRules.setToolTipText("Rule defining which tag will provide automatic filters, below a certain zoom level");
        this.autoFilterRules.setSelectedItem(AutoFilterManager.getInstance().getAutoFilterRule(AutoFilterManager.PROP_AUTO_FILTER_RULE.get()));
        JLabel performanceLabel = new JLabel(I18n.tr("Options that affect drawing performance", new Object[0]));
        panel.add((Component)new JLabel(I18n.tr("Segment drawing options", new Object[0])), GBC.eop().insets(5, 10, 0, 0));
        panel.add((Component)this.directionHint, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.headArrow, GBC.eop().insets(40, 0, 0, 0));
        panel.add((Component)this.onewayArrow, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.segmentOrderNumber, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.segmentOrderNumberOnSelectedWay, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)new JLabel(I18n.tr("Select and draw mode options", new Object[0])), GBC.eop().insets(5, 10, 0, 0));
        panel.add((Component)this.virtualNodes, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.drawHelperLine, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)performanceLabel, GBC.eop().insets(5, 10, 0, 0));
        panel.add((Component)this.useAntialiasing, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.useWireframeAntialiasing, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.useHighlighting, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.outlineOnly, GBC.eol().insets(20, 0, 0, 0));
        panel.add((Component)this.hideLabelsWhileDragging, GBC.eol().insets(20, 0, 0, 0));
        panel.add((Component)new JLabel(I18n.tr("Other options", new Object[0])), GBC.eop().insets(5, 10, 0, 0));
        panel.add((Component)this.sourceBounds, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.inactive, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.discardableKeys, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.autoFilters, GBC.eop().insets(20, 0, 0, 0));
        panel.add((Component)this.lblRule, GBC.std().insets(40, 0, 0, 0));
        panel.add(this.autoFilterRules, GBC.eop().fill(2).insets(5, 0, 0, 0));
        ExpertToggleAction.addVisibilitySwitcher(performanceLabel);
        ExpertToggleAction.addVisibilitySwitcher(this.useAntialiasing);
        ExpertToggleAction.addVisibilitySwitcher(this.useWireframeAntialiasing);
        ExpertToggleAction.addVisibilitySwitcher(this.useHighlighting);
        ExpertToggleAction.addVisibilitySwitcher(this.outlineOnly);
        ExpertToggleAction.addVisibilitySwitcher(this.hideLabelsWhileDragging);
        ExpertToggleAction.addVisibilitySwitcher(this.discardableKeys);
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        JScrollPane scrollpane = new JScrollPane(panel);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GuiHelper.setDefaultIncrement(scrollpane);
        gui.getDisplayPreference().addSubTab(this, I18n.tr("OSM Data", new Object[0]), scrollpane);
    }

    @Override
    public boolean ok() {
        boolean restart = this.gpxPanel.savePreferences();
        OsmDataLayer.PROPERTY_HIDE_LABELS_WHILE_DRAGGING.put(this.hideLabelsWhileDragging.isSelected());
        Config.getPref().putBoolean("draw.data.area_outline_only", this.outlineOnly.isSelected());
        Config.getPref().putBoolean("draw.segment.direction", this.directionHint.isSelected());
        Config.getPref().putBoolean("draw.segment.head_only", this.headArrow.isSelected());
        Config.getPref().putBoolean("draw.oneway", this.onewayArrow.isSelected());
        Config.getPref().putBoolean("draw.segment.order_number", this.segmentOrderNumber.isSelected());
        Config.getPref().putBoolean("draw.segment.order_number.on_selected", this.segmentOrderNumberOnSelectedWay.isSelected());
        SOURCE_BOUNDS_PROP.put(this.sourceBounds.isSelected());
        Config.getPref().putBoolean("draw.data.inactive_color", this.inactive.isSelected());
        Config.getPref().putBoolean("mappaint.use-antialiasing", this.useAntialiasing.isSelected());
        Config.getPref().putBoolean("mappaint.wireframe.use-antialiasing", this.useWireframeAntialiasing.isSelected());
        Config.getPref().putBoolean("draw.target-highlight", this.useHighlighting.isSelected());
        Config.getPref().putBoolean("draw.helper-line", this.drawHelperLine.isSelected());
        Config.getPref().putBoolean("display.discardable-keys", this.discardableKeys.isSelected());
        AutoFilterManager.PROP_AUTO_FILTER_ENABLED.put(this.autoFilters.isSelected());
        AutoFilterManager.PROP_AUTO_FILTER_RULE.put(((AutoFilterRule)this.autoFilterRules.getSelectedItem()).getKey());
        int vn = Config.getPref().getInt("mappaint.node.virtual-size", 8);
        if (this.virtualNodes.isSelected()) {
            if (vn < 1) {
                vn = 8;
            }
        } else {
            vn = 0;
        }
        Config.getPref().putInt("mappaint.node.virtual-size", vn);
        return restart;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new DrawingPreference();
        }
    }
}

