/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Application
extends ComponentManager {
    public void runReadAction(@NotNull Runnable var1);

    public <T> T runReadAction(@NotNull Computable<T> var1);

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> var1) throws E;

    public void runWriteAction(@NotNull Runnable var1);

    public boolean hasWriteAction(@NotNull Class<?> var1);

    public void assertReadAccessAllowed();

    public void assertWriteAccessAllowed();

    public void assertIsDispatchThread();

    public void addApplicationListener(@NotNull ApplicationListener var1, @NotNull Disposable var2);

    @Contract(pure=true)
    public boolean isWriteAccessAllowed();

    @Contract(pure=true)
    public boolean isReadAccessAllowed();

    @Contract(pure=true)
    public boolean isDispatchThread();

    public void invokeLater(@NotNull Runnable var1);

    public void invokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public void invokeLater(@NotNull Runnable var1, @NotNull ModalityState var2, @NotNull Condition<?> var3);

    public void invokeAndWait(@NotNull Runnable var1, @NotNull ModalityState var2) throws ProcessCanceledException;

    public void invokeAndWait(@NotNull Runnable var1) throws ProcessCanceledException;

    @NotNull
    public ModalityState getCurrentModalityState();

    @NotNull
    public ModalityState getDefaultModalityState();

    @NotNull
    public ModalityState getAnyModalityState();

    public boolean isUnitTestMode();

    public boolean isHeadlessEnvironment();

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable var1);

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public AccessToken acquireWriteActionLock(@NotNull Class<?> var1);

    public boolean isInternal();

    public boolean isEAP();
}

