/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenMediaPath;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.gui.messages.ReplaceListChangedEvent;
import mediathek.tool.ReplaceList;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IoXmlLesen {
    private static final Logger logger = LogManager.getLogger(IoXmlLesen.class);
    private final XMLInputFactory inFactory = XMLInputFactory.newInstance();
    private final Daten daten;

    public IoXmlLesen() {
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.daten = Daten.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableTriple<Integer, Integer, Integer> importAboBlacklist(String datei, boolean abo, boolean black, boolean replace) throws IOException, XMLStreamException {
        int foundAbos = 0;
        int foundBlacklistEntries = 0;
        int foundReplaceListEntries = 0;
        XMLStreamReader parser = null;
        try (FileInputStream fis = new FileInputStream(datei);
             InputStreamReader in = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
            parser = this.inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                String[] sa;
                int event = parser.next();
                if (event != 1) continue;
                if (abo && parser.getLocalName().equals("Abonnement")) {
                    DatenAbo datenAbo = new DatenAbo();
                    if (!this.get(parser, "Abonnement", DatenAbo.XML_NAMES, datenAbo.arr)) continue;
                    ++foundAbos;
                    this.daten.getListeAbo().addAbo(datenAbo);
                    continue;
                }
                if (black && parser.getLocalName().equals("Blacklist")) {
                    ListeBlacklist blacklist = this.daten.getListeBlacklist();
                    BlacklistRule blacklistRule = new BlacklistRule();
                    if (!this.get(parser, "Blacklist", BlacklistRule.XML_NAMES, blacklistRule.arr)) continue;
                    ++foundBlacklistEntries;
                    blacklist.addWithoutNotification(blacklistRule);
                    continue;
                }
                if (!replace || !parser.getLocalName().equals("Ersetzungstabelle") || !this.get(parser, "Ersetzungstabelle", ReplaceList.COLUMN_NAMES, sa = new String[2])) continue;
                ++foundReplaceListEntries;
                ReplaceList.list.add(sa);
            }
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        if (foundAbos > 0) {
            this.daten.getListeAbo().aenderungMelden();
        }
        if (foundBlacklistEntries > 0) {
            this.daten.getListeBlacklist().filterListAndNotifyListeners();
        }
        if (foundReplaceListEntries > 0) {
            this.daten.getMessageBus().publishAsync(new ReplaceListChangedEvent());
        }
        return new ImmutableTriple<Integer, Integer, Integer>(foundAbos, foundBlacklistEntries, foundReplaceListEntries);
    }

    private boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            if (strRet[i] != null) continue;
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            logger.error("get", (Throwable)ex);
        }
        return ret;
    }

    private void readSystemConfiguration(XMLStreamReader parser) {
        try {
            int event;
            while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals("system"))) {
                if (event != 1) continue;
                String s2 = parser.getLocalName();
                String n = parser.getElementText();
                MVConfig.add(s2, n);
            }
        }
        catch (Exception ex) {
            logger.error("readSystemConfiguration", (Throwable)ex);
        }
    }

    private void readReplacementList(XMLStreamReader parser) {
        String[] sa = new String[2];
        if (this.get(parser, "Ersetzungstabelle", ReplaceList.COLUMN_NAMES, sa)) {
            ReplaceList.list.add(sa);
        }
    }

    private void readAbos(XMLStreamReader parser) {
        DatenAbo datenAbo = new DatenAbo();
        if (this.get(parser, "Abonnement", DatenAbo.XML_NAMES, datenAbo.arr)) {
            this.daten.getListeAbo().addAbo(datenAbo);
        }
    }

    private void readDownloads(XMLStreamReader parser) {
        DatenDownload d = new DatenDownload();
        if (this.get(parser, "Downlad", DatenDownload.XML_NAMES, d.arr)) {
            d.init();
            this.daten.getListeDownloads().add(d);
        }
    }

    private void readBlacklist(XMLStreamReader parser) {
        BlacklistRule blacklistRule = new BlacklistRule();
        if (this.get(parser, "Blacklist", BlacklistRule.XML_NAMES, blacklistRule.arr)) {
            this.daten.getListeBlacklist().addWithoutNotification(blacklistRule);
        }
    }

    private void readMediaPath(XMLStreamReader parser) {
        DatenMediaPath mp = new DatenMediaPath();
        if (this.get(parser, "MediaPath", DatenMediaPath.XML_NAMES, mp.arr)) {
            this.daten.getListeMediaPath().add(mp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean datenLesen(Path xmlFilePath) {
        boolean ret = false;
        if (Files.exists(xmlFilePath, new LinkOption[0])) {
            DatenPset datenPset = null;
            XMLStreamReader parser = null;
            try (InputStream is = Files.newInputStream(xmlFilePath, new OpenOption[0]);
                 InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
                parser = this.inFactory.createXMLStreamReader(in);
                while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    switch (parser.getLocalName()) {
                        case "system": {
                            this.readSystemConfiguration(parser);
                            break;
                        }
                        case "Programmset": {
                            datenPset = new DatenPset();
                            if (!this.get(parser, "Programmset", DatenPset.XML_NAMES, datenPset.arr)) break;
                            Daten.listePset.add(datenPset);
                            break;
                        }
                        case "Programm": {
                            DatenProg datenProg = new DatenProg();
                            if (!this.get(parser, "Programm", DatenProg.XML_NAMES, datenProg.arr) || datenPset == null) break;
                            datenPset.addProg(datenProg);
                            break;
                        }
                        case "Ersetzungstabelle": {
                            this.readReplacementList(parser);
                            break;
                        }
                        case "Abonnement": {
                            this.readAbos(parser);
                            break;
                        }
                        case "Downlad": {
                            this.readDownloads(parser);
                            break;
                        }
                        case "Blacklist": {
                            this.readBlacklist(parser);
                            break;
                        }
                        case "MediaPath": {
                            this.readMediaPath(parser);
                        }
                    }
                }
                ret = true;
            }
            catch (Exception ex) {
                ret = false;
                logger.error("datenLesen", (Throwable)ex);
            }
            finally {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
            this.sortLists();
            MVConfig.loadSystemParameter();
        }
        return ret;
    }

    private void sortLists() {
        this.daten.getListeDownloads().listeNummerieren();
        this.daten.getListeAbo().sort();
    }
}

