/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.logging.Level;
import net.posick.mDNS.net.NetworkProcessor;
import net.posick.mDNS.net.Packet;
import net.posick.mDNS.net.PacketListener;
import org.xbill.DNS.Options;

public class DatagramProcessor
extends NetworkProcessor {
    protected int maxPayloadSize = 512;
    protected boolean isMulticast = false;
    protected boolean loopbackModeDisabled = false;
    protected boolean reuseAddress = true;
    protected int ttl = 255;
    protected DatagramSocket socket;
    private long lastPacket;

    public DatagramProcessor(InetAddress ifaceAddress, InetAddress address, int port, PacketListener listener) throws IOException {
        super(ifaceAddress, address, port, listener);
        InetAddress addr;
        if (address != null) {
            this.isMulticast = address.isMulticastAddress();
        }
        NetworkInterface netIface = null;
        if (this.isMulticast) {
            MulticastSocket socket = new MulticastSocket(port);
            String temp = Options.value("mdns_multicast_loopback");
            if (temp != null && temp.length() > 0) {
                boolean bl = this.loopbackModeDisabled = "true".equalsIgnoreCase(temp) || "t".equalsIgnoreCase(temp) || "yes".equalsIgnoreCase(temp) || "y".equalsIgnoreCase(temp);
            }
            if ((temp = Options.value("mdns_socket_ttl")) != null && temp.length() > 0) {
                try {
                    this.ttl = Integer.valueOf(temp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.reuseAddress = true;
            socket.setLoopbackMode(this.loopbackModeDisabled);
            socket.setReuseAddress(this.reuseAddress);
            socket.setTimeToLive(this.ttl);
            socket.setInterface(ifaceAddress);
            socket.joinGroup(address);
            this.socket = socket;
        } else {
            this.socket = new DatagramSocket(new InetSocketAddress(ifaceAddress, port));
        }
        netIface = NetworkInterface.getByInetAddress(ifaceAddress);
        if (netIface == null && (netIface = NetworkInterface.getByInetAddress(this.socket.getLocalAddress())) == null && (addr = this.socket.getInetAddress()) != null) {
            netIface = NetworkInterface.getByInetAddress(addr);
        }
        if (netIface != null) {
            try {
                this.mtu = netIface.getMTU();
            }
            catch (SocketException e) {
                netIface = null;
                logger.logp(Level.WARNING, this.getClass().getName(), "DatagramProcessor.<init>", "Error getting MTU from Network Interface " + netIface + ". Using default MTU.");
            }
        }
        if (netIface == null) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            int smallestMtu = 1500;
            while (ifaces.hasMoreElements()) {
                int mtu;
                NetworkInterface iface = ifaces.nextElement();
                if (iface.isLoopback() || iface.isVirtual() || !iface.isUp() || (mtu = iface.getMTU()) >= smallestMtu) continue;
                smallestMtu = mtu;
            }
            this.mtu = smallestMtu;
        }
        this.maxPayloadSize = this.mtu - 40 - 8;
    }

    public void close() throws IOException {
        super.close();
        if (this.isMulticast) {
            try {
                ((MulticastSocket)this.socket).leaveGroup(this.address);
            }
            catch (SecurityException e) {
                logger.log(Level.WARNING, "A Security error occurred while leaving Multicast Group \"" + this.address.getAddress() + "\" - " + e.getMessage(), e);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error leaving Multicast Group \"" + this.address.getAddress() + "\" - " + e.getMessage(), e);
            }
        }
        this.socket.close();
    }

    public boolean isLoopbackModeDisabled() {
        return this.loopbackModeDisabled;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public boolean isOperational() {
        return super.isOperational() && this.socket.isBound() && !this.socket.isClosed() && this.lastPacket <= System.currentTimeMillis() + 120000L;
    }

    public void run() {
        this.lastPacket = System.currentTimeMillis();
        while (!this.exit) {
            try {
                byte[] buffer = new byte[this.mtu];
                DatagramPacket datagram = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(datagram);
                this.lastPacket = System.currentTimeMillis();
                if (datagram.getLength() <= 0) continue;
                Packet packet = new Packet(datagram);
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, this.getClass().getName(), "run", "-----> Received packet " + packet.id + " <-----");
                    packet.timer.start();
                }
                this.executors.executeNetworkTask(new NetworkProcessor.PacketRunner(this.listener, packet));
            }
            catch (SecurityException e) {
                logger.log(Level.WARNING, "Security issue receiving data from \"" + this.address + "\" - " + e.getMessage(), e);
            }
            catch (Exception e) {
                if (this.exit && !logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.WARNING, "Error receiving data from \"" + this.address + "\" - " + e.getMessage(), e);
            }
        }
    }

    public void send(byte[] data) throws IOException {
        if (this.exit) {
            return;
        }
        DatagramPacket packet = new DatagramPacket(data, data.length, this.address, this.port);
        try {
            if (this.isMulticast) {
                ((MulticastSocket)this.socket).setTimeToLive(255);
            }
            this.socket.send(packet);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error sending datagram to \"" + packet.getSocketAddress() + "\".", e);
            if ("no route to host".equalsIgnoreCase(e.getMessage())) {
                this.close();
            }
            IOException ioe = new IOException("Exception \"" + e.getMessage() + "\" occured while sending datagram to \"" + packet.getSocketAddress() + "\".", e);
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

