/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.SubjectPattern;
import net.sourceforge.plantuml.project.lang.VerbEnds;
import net.sourceforge.plantuml.project.lang.VerbHappens;
import net.sourceforge.plantuml.project.lang.VerbIsColored;
import net.sourceforge.plantuml.project.lang.VerbIsDeleted;
import net.sourceforge.plantuml.project.lang.VerbIsForTask;
import net.sourceforge.plantuml.project.lang.VerbLasts;
import net.sourceforge.plantuml.project.lang.VerbLinksTo;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.lang.VerbTaskEndsAbsolute;
import net.sourceforge.plantuml.project.lang.VerbTaskStarts;
import net.sourceforge.plantuml.project.lang.VerbTaskStartsAbsolute;

public class SubjectTask
implements SubjectPattern {
    @Override
    public Collection<VerbPattern> getVerbs() {
        return Arrays.asList(new VerbLasts(), new VerbTaskStarts(), new VerbTaskStartsAbsolute(), new VerbHappens(), new VerbEnds(), new VerbTaskEndsAbsolute(), new VerbIsColored(), new VerbIsDeleted(), new VerbIsForTask(), new VerbLinksTo());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("THEN", "(then[%s]+)?"), new RegexLeaf("SUBJECT", "\\[([^\\[\\]]+?)\\](?:[%s]+as[%s]+\\[([^\\[\\]]+?)\\])?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("on"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("RESOURCE", "((?:\\{[^{}]+\\}[%s]*)+)"))));
    }

    @Override
    public Subject getSubject(GanttDiagram project, RegexResult arg) {
        String s = arg.get("SUBJECT", 0);
        String shortName = arg.get("SUBJECT", 1);
        String then = arg.get("THEN", 0);
        String resource = arg.get("RESOURCE", 0);
        Task result = project.getOrCreateTask(s, shortName, then != null);
        if (result == null) {
            throw new IllegalStateException();
        }
        if (resource != null) {
            StringTokenizer st = new StringTokenizer(resource, "{}");
            while (st.hasMoreTokens()) {
                String part = st.nextToken().trim();
                if (part.length() <= 0) continue;
                project.affectResource(result, part);
            }
        }
        return result;
    }
}

