/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Node;

public class Bibliotekon {
    private final List<Cluster> allCluster = new ArrayList<Cluster>();
    private final Map<ILeaf, Node> nodeMap = new LinkedHashMap<ILeaf, Node>();
    private final List<Line> lines0 = new ArrayList<Line>();
    private final List<Line> lines1 = new ArrayList<Line>();
    private final List<Line> allLines = new ArrayList<Line>();

    public Node createNode(ILeaf ent, IEntityImage image, ColorSequence colorSequence, StringBounder stringBounder) {
        Node node = new Node(ent, image, colorSequence, stringBounder);
        this.nodeMap.put(ent, node);
        return node;
    }

    public Cluster getCluster(IGroup ent) {
        for (Cluster cl : this.allCluster) {
            if (!cl.getGroups().contains(ent)) continue;
            return cl;
        }
        return null;
    }

    public void addLine(Line line) {
        this.allLines.add(line);
        if (Bibliotekon.first(line)) {
            if (line.hasNoteLabelText()) {
                for (int i = 0; i < this.lines0.size(); ++i) {
                    Line other = this.lines0.get(i);
                    if (other.hasNoteLabelText() || !line.sameConnections(other)) continue;
                    this.lines0.add(i, line);
                    return;
                }
                this.lines0.add(line);
            } else {
                this.lines0.add(line);
            }
        } else {
            this.lines1.add(line);
        }
    }

    private static boolean first(Line line) {
        int length = line.getLength();
        return length == 1;
    }

    public void addCluster(Cluster current) {
        this.allCluster.add(current);
    }

    public Node getNode(IEntity ent) {
        return this.nodeMap.get(ent);
    }

    public String getNodeUid(ILeaf ent) {
        Node result = this.getNode(ent);
        if (result != null) {
            String uid = result.getUid();
            if (result.isShielded()) {
                uid = uid + ":h";
            }
            return uid;
        }
        assert (result == null);
        if (ent.isGroup()) {
            for (IEntity iEntity : this.nodeMap.keySet()) {
                if (!ent.getCodeGetName().equals(iEntity.getCodeGetName())) continue;
                return this.getNode(iEntity).getUid();
            }
            return Cluster.getSpecialPointId(ent);
        }
        throw new IllegalStateException();
    }

    public String getWarningOrError(int warningOrError) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ILeaf, Node> ent : this.nodeMap.entrySet()) {
            Node sh = ent.getValue();
            double maxX = sh.getMinX() + sh.getWidth();
            if (!(maxX > (double)warningOrError)) continue;
            IEntity entity = ent.getKey();
            sb.append(entity.getCodeGetName() + " is overpassing the width limit.");
            sb.append("\n");
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    public Map<String, Double> getMaxX() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry<ILeaf, Node> ent : this.nodeMap.entrySet()) {
            Node sh = ent.getValue();
            double maxX = sh.getMinX() + sh.getWidth();
            IEntity entity = ent.getKey();
            result.put(entity.getCodeGetName(), maxX);
        }
        return Collections.unmodifiableMap(result);
    }

    public List<Line> allLines() {
        return Collections.unmodifiableList(this.allLines);
    }

    public List<Line> lines0() {
        return Collections.unmodifiableList(this.lines0);
    }

    public List<Line> lines1() {
        return Collections.unmodifiableList(this.lines1);
    }

    public List<Cluster> allCluster() {
        return Collections.unmodifiableList(this.allCluster);
    }

    public Collection<Node> allNodes() {
        return Collections.unmodifiableCollection(this.nodeMap.values());
    }

    public List<Line> getAllLineConnectedTo(IEntity leaf) {
        ArrayList<Line> result = new ArrayList<Line>();
        for (Line line : this.allLines) {
            if (!line.isLinkFromOrTo(leaf)) continue;
            result.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    public Line getLine(Link link) {
        for (Line line : this.allLines) {
            if (!line.isLink(link)) continue;
            return line;
        }
        throw new IllegalArgumentException();
    }

    public IEntity getOnlyOther(IEntity entity) {
        for (Line line : this.allLines) {
            IEntity other = line.getOther(entity);
            if (other == null) continue;
            return other;
        }
        return null;
    }

    public ILeaf getLeaf(Node node) {
        for (Map.Entry<ILeaf, Node> ent : this.nodeMap.entrySet()) {
            if (ent.getValue() != node) continue;
            return ent.getKey();
        }
        throw new IllegalArgumentException();
    }
}

