/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.selection;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLEntitySelectionModel {
    private final OWLSelectionModel selectionModel;

    public OWLEntitySelectionModel(@Nonnull OWLSelectionModel selectionModel) {
        this.selectionModel = (OWLSelectionModel)Preconditions.checkNotNull((Object)selectionModel);
    }

    @Nonnull
    public Optional<OWLClass> getSelectedClass() {
        return this.getSelection(OWLClass.class);
    }

    @Nonnull
    public Optional<OWLObjectProperty> getSelectedObjectProperty() {
        return this.getSelection(OWLObjectProperty.class);
    }

    @Nonnull
    public Optional<OWLDataProperty> getSelectedDataProperty() {
        return this.getSelection(OWLDataProperty.class);
    }

    @Nonnull
    public Optional<OWLAnnotationProperty> getSelectedAnnotationProperty() {
        return this.getSelection(OWLAnnotationProperty.class);
    }

    @Nonnull
    public Optional<OWLNamedIndividual> getSelectedNamedIndividual() {
        return this.getSelection(OWLNamedIndividual.class);
    }

    @Nonnull
    public Optional<OWLDatatype> getSelectedDatatype() {
        return this.getSelection(OWLDatatype.class);
    }

    private <T extends OWLEntity> Optional<T> getSelection(Class<T> theClass) {
        OWLObject selObject = this.selectionModel.getSelectedObject();
        if (selObject == null) {
            return Optional.empty();
        }
        if (theClass.isInstance(selObject)) {
            return Optional.of((OWLEntity)selObject);
        }
        if (OWLEntity.class.isInstance(selObject)) {
            return Optional.empty();
        }
        OWLEntity lastSelectedEntity = this.selectionModel.getSelectedEntity();
        if (theClass.isInstance(lastSelectedEntity)) {
            return Optional.of(lastSelectedEntity);
        }
        return Optional.empty();
    }
}

