/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.api.templates.CreateFromTemplateDecorator;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.templates.ScriptingCreateFromTemplateHandler;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.Parameters;

final class CreateFromTemplateImpl {
    private static final String PROP_TEMPLATE = "template";
    private static final String NEWLINE = "\n";
    private final FileBuilder builder;
    private final CreateDescriptor desc;
    private Map<String, ?> originalParams;
    private List<CreateFromTemplateDecorator> decorators;

    private CreateFromTemplateImpl(FileBuilder fileBuilder) {
        this.builder = fileBuilder;
        this.desc = fileBuilder.getDescriptor();
    }

    static List<FileObject> build(FileBuilder fileBuilder) throws IOException {
        CreateFromTemplateImpl createFromTemplateImpl = new CreateFromTemplateImpl(fileBuilder);
        return createFromTemplateImpl.build();
    }

    static void collectAttributes(FileBuilder fileBuilder) {
        CreateFromTemplateImpl createFromTemplateImpl = new CreateFromTemplateImpl(fileBuilder);
        fileBuilder.withParameters(createFromTemplateImpl.findTemplateParameters());
    }

    private void setupDecorators() {
        this.decorators = new ArrayList<CreateFromTemplateDecorator>(Lookup.getDefault().lookupAll(CreateFromTemplateDecorator.class));
        Iterator<CreateFromTemplateDecorator> iterator = this.decorators.iterator();
        while (iterator.hasNext()) {
            CreateFromTemplateDecorator createFromTemplateDecorator = iterator.next();
            if (createFromTemplateDecorator.accept(this.desc)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FileObject> build() throws IOException {
        try {
            Object object;
            Object object22;
            FileObject fileObject = this.desc.getTemplate();
            FileObject fileObject2 = this.desc.getTarget();
            FileBuilder.Mode mode = this.builder.defaultMode;
            Format format = this.builder.format;
            Parameters.notNull((CharSequence)"f", (Object)fileObject);
            Parameters.notNull((CharSequence)"folder", (Object)fileObject2);
            assert (mode != FileBuilder.Mode.FORMAT || format != null) : "Format must be provided for Mode.FORMAT";
            if (!fileObject2.isFolder()) {
                throw new IllegalArgumentException("Not a folder: " + fileObject2);
            }
            this.findTemplateParameters();
            this.setupDecorators();
            CreateFromTemplateImpl.computeEffectiveName(this.desc);
            List<FileObject> list = this.callDecorators(true, new ArrayList<FileObject>());
            List<FileObject> list2 = null;
            for (Object object22 : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
                if (!((CreateFromTemplateHandler)object22).accept(this.desc)) continue;
                list2 = ((CreateFromTemplateHandler)object22).createFromTemplate(this.desc);
                assert (list2 != null && !list2.isEmpty());
                break;
            }
            if (list2 == null && mode != FileBuilder.Mode.FAIL) {
                list2 = Collections.singletonList(this.defaultCreate());
            }
            if (list2 == null) {
                object = list2;
                return object;
            }
            object = new ArrayList<FileObject>(list2);
            object.addAll(list);
            this.callDecorators(false, (List<FileObject>)object);
            object22 = object;
            return object22;
        }
        finally {
            this.builder.getDescriptor().parameters = this.originalParams;
        }
    }

    private List<FileObject> callDecorators(boolean bl, List<FileObject> list) throws IOException {
        for (CreateFromTemplateDecorator createFromTemplateDecorator : this.decorators) {
            List<FileObject> list2;
            if (!(bl ? createFromTemplateDecorator.isBeforeCreation() : createFromTemplateDecorator.isAfterCreation()) || (list2 = createFromTemplateDecorator.decorate(this.desc, list)) == null) continue;
            list2.removeAll(list);
            list.addAll(list2);
        }
        return list;
    }

    static void computeEffectiveName(CreateDescriptor createDescriptor) {
        String string = createDescriptor.getName();
        if (string == null) {
            Object object = createDescriptor.getParameters().get("name");
            string = object instanceof String ? (String)object : FileUtil.findFreeFileName((FileObject)createDescriptor.getTarget(), (String)createDescriptor.getTemplate().getName(), (String)createDescriptor.getTemplate().getExt());
        }
        createDescriptor.proposedName = string;
    }

    public Map<String, Object> findTemplateParameters() {
        Map<String, ?> map;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.desc.getParameters());
        this.originalParams = this.desc.parameters;
        this.desc.parameters = hashMap;
        for (Object object2 : Lookup.getDefault().lookupAll(CreateFromTemplateAttributes.class)) {
            map = object2.attributesFor(this.desc);
            if (map == null) continue;
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (this.originalParams != null && this.originalParams.containsKey(entry.getKey())) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        String string = this.desc.getName();
        if (!hashMap.containsKey("name") && string != null) {
            object2 = string;
            if (this.desc.hasFreeExtension()) {
                object2 = string.replaceFirst("[.].*", "");
            }
            hashMap.put("name", object2);
        }
        object2 = new Date();
        if (!hashMap.containsKey("dateTime")) {
            hashMap.put("dateTime", object2);
        }
        map = this.desc.getTemplate().getExt();
        if (!hashMap.containsKey("nameAndExt") && string != null) {
            if (!(map == null || ((String)((Object)map)).length() <= 0 || this.originalParams == null || this.desc.hasFreeExtension() && string.indexOf(46) != -1)) {
                hashMap.put("nameAndExt", (String)string + '.' + (String)((Object)map));
            } else {
                hashMap.put("nameAndExt", string);
            }
        }
        return hashMap;
    }

    private FileObject defaultCreate() throws IOException {
        Object object2;
        Object object3;
        FileObject fileObject;
        Map<String, Object> map = this.desc.getParameters();
        FileBuilder.Mode mode = this.builder.defaultMode;
        Format format = this.builder.format;
        if (mode != FileBuilder.Mode.COPY && format instanceof MapFormat) {
            fileObject = (MapFormat)format;
            object3 = fileObject.getMap();
            object2 = null;
            for (String object4 : map.keySet()) {
                if (object3.containsKey(object4)) continue;
                if (object2 == null) {
                    object2 = new HashMap(object3);
                }
                object2.put(object4, map.get(object4));
            }
            if (object2 != null) {
                fileObject.setMap((Map)object2);
            }
        }
        fileObject = this.desc.getTemplate();
        object3 = this.desc.getTemplate().getExt();
        object2 = this.desc.getTarget().createData(this.desc.getProposedName(), (String)object3);
        boolean bl = false;
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        boolean bl2 = false;
        FileLock fileLock = object2.lock();
        try (InputStream scriptException = fileObject.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(scriptException, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            bl = this.desc.isPreformatted();
            Charset charset2 = FileEncodingQuery.getEncoding((FileObject)object2);
            ScriptEngine scriptEngine = this.desc.isPreformatted() ? null : ScriptingCreateFromTemplateHandler.indentEngine();
            StringWriter stringWriter = new StringWriter();
            try (OutputStream outputStream = object2.getOutputStream(fileLock);
                 OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset2);
                 Writer writer = bl || scriptEngine == null ? outputStreamWriter : stringWriter;){
                String string;
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string2 != null) {
                        writer.append(NEWLINE);
                    }
                    string2 = format != null ? format.format(string) : string;
                    writer.append(string2);
                }
                writer.append(NEWLINE);
                writer.flush();
                if (scriptEngine != null) {
                    scriptEngine.getContext().setAttribute("mimeType", fileObject.getMIMEType(), 100);
                    scriptEngine.getContext().setWriter(outputStreamWriter);
                    scriptEngine.eval(new StringReader(stringWriter.toString()));
                }
            }
            FileUtil.copyAttributes((FileObject)fileObject, (FileObject)object2);
            object2.setAttribute(PROP_TEMPLATE, null);
            bl2 = true;
        }
        catch (IOException iOException) {
            try {
                object2.delete(fileLock);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        catch (ScriptException scriptException2) {
            IOException iOException = scriptException2.getCause() instanceof IOException ? (IOException)scriptException2.getCause() : null;
            try {
                object2.delete(fileLock);
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw iOException == null ? new IOException(scriptException2) : iOException;
        }
        finally {
            if (!bl2) {
                object2.delete(fileLock);
            }
            fileLock.releaseLock();
        }
        return object2;
    }
}

