/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.netbeans.beaninfo.editors.PropertiesCustomEditor;
import org.netbeans.core.UIExceptions;
import org.openide.util.NbBundle;

public class PropertiesEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof Properties) {
            Properties properties = (Properties)object;
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                Object object2 = enumeration.nextElement();
                stringBuilder.append(object2).append('=').append(properties.get(object2));
            }
            return stringBuilder.toString();
        }
        return String.valueOf(object);
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        try {
            if (string == null) {
                throw new IllegalArgumentException("Inserted value can't be null.");
            }
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.replace(';', '\n').getBytes("ISO8859_1"));
            properties.load(byteArrayInputStream);
            this.setValue(properties);
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
            String string2 = iOException.getLocalizedMessage();
            if (string2 == null) {
                string2 = MessageFormat.format(NbBundle.getMessage(PropertiesEditor.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), string);
            }
            UIExceptions.annotateUser(illegalArgumentException, illegalArgumentException.getMessage(), string2, iOException, new Date());
            throw illegalArgumentException;
        }
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new PropertiesCustomEditor(this);
    }
}

