/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.JavaTypeFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.api.project.ProjectContentsSupport;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.impl.ClassMethodList;
import org.netbeans.modules.profiler.v2.impl.ClassMethodSelector;
import org.netbeans.modules.profiler.v2.impl.FilterSelector;
import org.netbeans.modules.profiler.v2.impl.ProjectsSelector;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

final class MethodsFeatureModes {
    MethodsFeatureModes() {
    }

    private static String getFlatValues(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            if (i != stringArray.length - 1 && !string.endsWith(",")) {
                string = string + ",";
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static Component createStrut(JComponent jComponent, int n, boolean bl) {
        Insets insets;
        Border border = jComponent.getBorder();
        Insets insets2 = insets = border != null ? border.getBorderInsets(jComponent) : null;
        int n2 = insets == null ? n : Math.max(n - (bl ? insets.left : insets.right), 0);
        return Box.createHorizontalStrut(n2);
    }

    static abstract class CustomClassesMode
    extends MethodsMode {
        private static final String CLASSES_FLAG = "CLASSES_FLAG";
        private static final String FILTER_FLAG = "FILTER_FLAG";
        private static final String FILTER_MODE_FLAG = "FILTER_MODE_FLAG";
        private static final int MIN_ROWS = 2;
        private static final int MAX_ROWS = 15;
        private static final int DEFAULT_ROWS = 3;
        private static final int MIN_COLUMNS = 10;
        private static final int MAX_COLUMNS = 100;
        private static final int DEFAULT_COLUMNS = 40;
        private JComponent ui;
        private TextArea classesArea;
        private TextArea filterArea;
        private JRadioButton includeChoice;
        private JRadioButton excludeChoice;

        CustomClassesMode() {
        }

        @Override
        String getID() {
            return "CustomMethodsMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_definedClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(profilingSettings);
            profilingSettings.setProfilingType(16);
            profilingSettings.setCPUProfilingType(profilingSettings.getSamplingInterval() <= 0 ? 0 : 1);
            String[] stringArray = this.readFlag(CLASSES_FLAG, "").split("\\n");
            String[] stringArray2 = GenericFilter.values((String)MethodsFeatureModes.getFlatValues(stringArray));
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = stringArray2.length == 1 && stringArray2[0].isEmpty() ? new ClientUtils.SourceCodeSelection[]{} : new ClientUtils.SourceCodeSelection[stringArray2.length];
            for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
                sourceCodeSelectionArray[i] = new ClientUtils.SourceCodeSelection(stringArray2[i], "*", null);
            }
            profilingSettings.addRootMethods(sourceCodeSelectionArray);
            String string = this.readFlag(FILTER_FLAG, "");
            if (string.isEmpty() || "*".equals(string) || "**".equals(string)) {
                profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
            } else {
                int n = Boolean.parseBoolean(this.readFlag(FILTER_MODE_FLAG, Boolean.TRUE.toString())) ? 10 : 20;
                String string2 = MethodsFeatureModes.getFlatValues(string.split("\\n"));
                profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(string2, n));
            }
            profilingSettings.setStackDepthLimit(Integer.MAX_VALUE);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                String string = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                this.storeFlag(CLASSES_FLAG, string.isEmpty() ? null : string);
                String string2 = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                this.storeFlag(FILTER_FLAG, string2.isEmpty() ? null : string2);
                boolean bl = this.includeChoice.isSelected();
                this.storeFlag(FILTER_MODE_FLAG, bl ? null : Boolean.FALSE.toString());
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                String string;
                String string2;
                assert (SwingUtilities.isEventDispatchThread());
                String string3 = string2 = this.classesArea.showsHint() ? "" : this.classesArea.getText().trim();
                if (!string2.equals(this.readFlag(CLASSES_FLAG, ""))) {
                    return true;
                }
                String string4 = string = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                if (!string.equals(this.readFlag(FILTER_FLAG, ""))) {
                    return true;
                }
                if (Boolean.parseBoolean(this.readFlag(FILTER_MODE_FLAG, Boolean.TRUE.toString())) != this.includeChoice.isSelected()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !(this.ui != null ? this.classesArea.showsHint() || this.classesArea.getText().trim().isEmpty() : this.readFlag(CLASSES_FLAG, "").isEmpty());
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setOpaque(false);
                SettingsPanel settingsPanel = new SettingsPanel();
                settingsPanel.add(new JLabel(Bundle.MethodsFeatureModes_classesLbl()));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)settingsPanel, gridBagConstraints);
                class Resizer {
                    private TextArea area1;
                    private TextArea area2;
                    private JComponent container1;
                    private JComponent container2;

                    Resizer() {
                    }

                    void setContext(TextArea textArea, TextArea textArea2, JComponent jComponent, JComponent jComponent2) {
                        this.area1 = textArea;
                        this.area2 = textArea2;
                        this.container1 = jComponent;
                        this.container2 = jComponent2;
                    }

                    void resize() {
                        this.area1.setColumns(CustomClassesMode.this.readColumns1());
                        this.area2.setColumns(CustomClassesMode.this.readColumns2());
                        int n = CustomClassesMode.this.readRows();
                        this.area1.setRows(n);
                        this.area2.setRows(n);
                        this.area1.invalidate();
                        this.area2.invalidate();
                        this.container1.setPreferredSize(null);
                        this.container1.setPreferredSize(this.container1.getPreferredSize());
                        this.container1.setMinimumSize(this.container1.getPreferredSize());
                        this.container2.setPreferredSize(null);
                        this.container2.setPreferredSize(this.container2.getPreferredSize());
                        this.container2.setMinimumSize(this.container2.getPreferredSize());
                        JRootPane jRootPane = SwingUtilities.getRootPane(this.container1);
                        jRootPane.doLayout();
                        jRootPane.repaint();
                        this.area1.setColumns(0);
                        this.area2.setColumns(0);
                    }
                }
                final Resizer resizer = new Resizer();
                this.classesArea = new TextArea(this.readFlag(CLASSES_FLAG, "")){
                    {
                        super(string);
                    }

                    protected void changed() {
                        CustomClassesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean bl, boolean bl2) {
                        if (bl) {
                            int n = CustomClassesMode.this.readRows();
                            n = bl2 ? Math.min(n + 1, 15) : Math.max(n - 1, 2);
                            CustomClassesMode.this.storeRows(n);
                        } else {
                            int n = CustomClassesMode.this.readColumns1();
                            n = bl2 ? Math.min(n + 3, 100) : Math.max(n - 3, 10);
                            CustomClassesMode.this.storeColumns1(n);
                        }
                        resizer.resize();
                        return true;
                    }

                    protected boolean resetSize() {
                        CustomClassesMode.this.storeRows(3);
                        CustomClassesMode.this.storeColumns1(40);
                        resizer.resize();
                        return true;
                    }

                    protected void customizePopup(JPopupMenu jPopupMenu) {
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent mouseEvent) {
                        Container container = this.getParent().getParent();
                        return SwingUtilities.convertPoint(container, 0, container.getHeight(), (Component)((Object)this));
                    }
                };
                this.classesArea.setFont(new Font("Monospaced", 0, this.classesArea.getFont().getSize()));
                this.classesArea.setRows(this.readRows());
                this.classesArea.setColumns(this.readColumns1());
                JScrollPane jScrollPane = new JScrollPane((Component)this.classesArea);
                jScrollPane.setPreferredSize(jScrollPane.getPreferredSize());
                jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
                this.classesArea.setColumns(0);
                this.classesArea.setHint(Bundle.MethodsFeatureModes_classesHint());
                this.classesArea.setToolTipText(Bundle.MethodsFeatureModes_classesTooltip());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.weightx = 0.5;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 3;
                gridBagConstraints.insets = new Insets(0, 0, 0, 10);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)jScrollPane, gridBagConstraints);
                boolean bl = Boolean.TRUE.toString().equals(this.readFlag(FILTER_MODE_FLAG, Boolean.TRUE.toString()));
                ButtonGroup buttonGroup = new ButtonGroup();
                SettingsPanel settingsPanel2 = new SettingsPanel();
                this.includeChoice = new JRadioButton(Bundle.MethodsFeatureModes_includeCalls()){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CustomClassesMode.this.settingsChanged();
                    }
                };
                this.includeChoice.setToolTipText(Bundle.MethodsFeatureModes_includeTooltip());
                Border border = this.includeChoice.getBorder();
                Insets insets = border != null ? border.getBorderInsets(this.includeChoice) : null;
                this.includeChoice.setOpaque(false);
                buttonGroup.add(this.includeChoice);
                this.includeChoice.setSelected(bl);
                settingsPanel2.add(this.includeChoice);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : new Insets(0, 1 - insets.left, 0, 1 - insets.right);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)settingsPanel2, gridBagConstraints);
                this.excludeChoice = new JRadioButton(Bundle.MethodsFeatureModes_excludeCalls()){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CustomClassesMode.this.settingsChanged();
                    }
                };
                this.excludeChoice.setToolTipText(Bundle.MethodsFeatureModes_excludeTooltip());
                border = this.excludeChoice.getBorder();
                insets = border != null ? border.getBorderInsets(this.excludeChoice) : null;
                this.excludeChoice.setOpaque(false);
                buttonGroup.add(this.excludeChoice);
                this.excludeChoice.setSelected(!bl);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = insets == null ? new Insets(0, 0, 0, 0) : new Insets(1 - insets.top, 1 - insets.left, 0, 1 - insets.right);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)this.excludeChoice, gridBagConstraints);
                this.filterArea = new TextArea(this.readFlag(FILTER_FLAG, "")){
                    {
                        super(string);
                    }

                    protected void changed() {
                        CustomClassesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean bl, boolean bl2) {
                        if (bl) {
                            int n = CustomClassesMode.this.readRows();
                            n = bl2 ? Math.min(n + 1, 15) : Math.max(n - 1, 2);
                            CustomClassesMode.this.storeRows(n);
                        } else {
                            int n = CustomClassesMode.this.readColumns2();
                            n = bl2 ? Math.min(n + 3, 100) : Math.max(n - 3, 10);
                            CustomClassesMode.this.storeColumns2(n);
                        }
                        resizer.resize();
                        return true;
                    }

                    protected boolean resetSize() {
                        CustomClassesMode.this.storeRows(3);
                        CustomClassesMode.this.storeColumns2(40);
                        resizer.resize();
                        return true;
                    }

                    protected void customizePopup(JPopupMenu jPopupMenu) {
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent mouseEvent) {
                        Container container = this.getParent().getParent();
                        return SwingUtilities.convertPoint(container, 0, container.getHeight(), (Component)((Object)this));
                    }
                };
                this.filterArea.setFont(new Font("Monospaced", 0, this.classesArea.getFont().getSize()));
                this.filterArea.setRows(this.readRows());
                this.filterArea.setColumns(this.readColumns2());
                JScrollPane jScrollPane2 = new JScrollPane((Component)this.filterArea);
                jScrollPane2.setPreferredSize(jScrollPane2.getPreferredSize());
                jScrollPane2.setMinimumSize(jScrollPane2.getPreferredSize());
                this.filterArea.setColumns(0);
                this.filterArea.setHint(Bundle.MethodsFeatureModes_filterHint());
                this.filterArea.setToolTipText(Bundle.MethodsFeatureModes_filterTooltip());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.weightx = 0.5;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 3;
                gridBagConstraints.insets = new Insets(0, 4, 0, 1);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)jScrollPane2, gridBagConstraints);
                resizer.setContext(this.classesArea, this.filterArea, jScrollPane, jScrollPane2);
                this.ui = jPanel;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomClassesMode.this.settingsChanged();
                    }
                });
            }
            return this.ui;
        }

        private int readRows() {
            return NbPreferences.forModule(MethodsFeatureModes.class).getInt("MethodsFeatureModes.rows", 3);
        }

        private void storeRows(int n) {
            NbPreferences.forModule(MethodsFeatureModes.class).putInt("MethodsFeatureModes.rows", n);
        }

        private int readColumns1() {
            return NbPreferences.forModule(MethodsFeatureModes.class).getInt("MethodsFeatureModes.columns1", 40);
        }

        private void storeColumns1(int n) {
            NbPreferences.forModule(MethodsFeatureModes.class).putInt("MethodsFeatureModes.columns1", n);
        }

        private int readColumns2() {
            return NbPreferences.forModule(MethodsFeatureModes.class).getInt("MethodsFeatureModes.columns2", 40);
        }

        private void storeColumns2(int n) {
            NbPreferences.forModule(MethodsFeatureModes.class).putInt("MethodsFeatureModes.columns2", n);
        }
    }

    static abstract class SelectedMethodsMode
    extends InstrMethodsMode {
        SelectedMethodsMode() {
        }

        abstract void selectForProfiling(Collection<SourceMethodInfo> var1);

        @Override
        String getID() {
            return "SelectedMethodsMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_selectedMethods();
        }

        @Override
        protected int getOutgoingCallsMaximum() {
            return 99;
        }

        @Override
        protected String noSelectionString() {
            return Bundle.MethodsFeatureModes_noMethodSelected();
        }

        @Override
        protected String oneSelectionString() {
            return Bundle.MethodsFeatureModes_oneMethodSelected();
        }

        @Override
        protected String multipleSelectionsString(int n) {
            return Bundle.MethodsFeatureModes_multipleMethodsSelected(n);
        }

        @Override
        protected Icon getAddIcon() {
            String string = "LanguageIcons.Method";
            Image image = Icons.getImage((String)string);
            Image image2 = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image image3 = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)0);
            return ImageUtilities.image2Icon((Image)image3);
        }

        @Override
        protected String getAddTooltip() {
            return Bundle.MethodsFeatureModes_addMethod();
        }

        @Override
        protected void performAddSelection() {
            this.selectForProfiling(ClassMethodSelector.selectMethods(this.getSession()));
        }

        @Override
        protected void performEditSelection(Component component) {
            ClassMethodList.showMethods(this.getSession(), this.getSelection(), component);
        }
    }

    static abstract class SelectedClassesMode
    extends InstrMethodsMode {
        SelectedClassesMode() {
        }

        abstract void selectForProfiling(Collection<SourceClassInfo> var1);

        @Override
        String getID() {
            return "SelectedClassesMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_selectedClasses();
        }

        @Override
        protected int getOutgoingCallsMaximum() {
            return 10;
        }

        @Override
        protected String noSelectionString() {
            return Bundle.MethodsFeatureModes_noClassSelected();
        }

        @Override
        protected String oneSelectionString() {
            return Bundle.MethodsFeatureModes_oneClassSelected();
        }

        @Override
        protected String multipleSelectionsString(int n) {
            return Bundle.MethodsFeatureModes_multipleClassesSelected(n);
        }

        @Override
        protected Icon getAddIcon() {
            String string = "LanguageIcons.Class";
            Image image = Icons.getImage((String)string);
            Image image2 = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image image3 = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)0);
            return ImageUtilities.image2Icon((Image)image3);
        }

        @Override
        protected String getAddTooltip() {
            return Bundle.MethodsFeatureModes_addClass();
        }

        @Override
        protected void performAddSelection() {
            this.selectForProfiling(ClassMethodSelector.selectClasses(this.getSession()));
        }

        @Override
        protected void performEditSelection(Component component) {
            ClassMethodList.showClasses(this.getSession(), this.getSelection(), component);
        }
    }

    private static abstract class InstrMethodsMode
    extends MethodsMode {
        private static final String CORE_JAVA_FILTER = "apple.laf.**, apple.awt.**, com.apple.**, com.sun.**, java.**, javax.**, jdk.**, sun.**, sunw.**, org.omg.CORBA.**, org.omg.CosNaming.**, COM.rsa.**";
        private static final String OUTGOING_CALLS_ENABLED_FLAG = "OUTGOING_CALLS_ENABLED_FLAG";
        private static final String OUTGOING_CALLS_FLAG = "OUTGOING_CALLS_FLAG";
        private static final String SKIP_JAVA_FLAG = "SKIP_JAVA_FLAG";
        private static final String FILTER_CALLS_FLAG = "FILTER_CALLS_FLAG";
        private static final String FILTER_CALLS_VALUE_FLAG = "FILTER_CALLS_VALUE_FLAG";
        private static final String SELECTION_FLAG = "SELECTION_FLAG";
        private static final Integer OUTGOING_CALLS_DEFAULT = 5;
        private FeatureMode.Selection selection;
        private FilterSelector.FilterName filterName;
        private String filterValue;
        private boolean lastOutgoingSelected;
        private JComponent ui;
        private JPanel selectionContent;
        private JPanel noSelectionContent;
        private JLabel outgoingLabel;
        private JCheckBox outgoingChoice;
        private JLabel outgoingHint;
        private JSpinner outgoingSpinner;
        private JButton addSelectionButton;
        private JButton editSelectionLink;
        private JButton filterLink;

        private InstrMethodsMode() {
        }

        abstract void selectionChanging();

        abstract void selectionChanged();

        abstract ProfilerSession getSession();

        @Override
        void initialize() {
            String string;
            String string2 = this.readFlag(SKIP_JAVA_FLAG, null);
            if (string2 != null) {
                boolean bl = Boolean.TRUE.toString().equals(string2);
                this.storeFlag(SKIP_JAVA_FLAG, null);
                if (!bl) {
                    this.storeFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.NO_FILTER.name());
                }
            }
            if ((string = this.readFlag(FILTER_CALLS_FLAG, null)) != null) {
                this.filterName = FilterSelector.FilterName.valueOf(string);
            }
            if (this.filterName == null) {
                this.filterName = FilterSelector.FilterName.EXCLUDE_JAVA_FILTER;
            }
            this.filterValue = this.readFlag(FILTER_CALLS_VALUE_FLAG, "");
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            Object object;
            assert (SwingUtilities.isEventDispatchThread());
            super.configureSettings(profilingSettings);
            profilingSettings.setProfilingType(16);
            profilingSettings.setCPUProfilingType(profilingSettings.getSamplingInterval() <= 0 ? 0 : 1);
            String string = this.readFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name());
            if (FilterSelector.FilterName.NO_FILTER.name().equals(string)) {
                profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
            } else if (FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name().equals(string)) {
                profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(CORE_JAVA_FILTER, 20));
            } else {
                object = this.readFlag(FILTER_CALLS_VALUE_FLAG, CORE_JAVA_FILTER);
                if (((String)object).isEmpty() || "*".equals(object) || "**".equals(object)) {
                    profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
                } else {
                    object = MethodsFeatureModes.getFlatValues(((String)object).split("\\n"));
                    if (FilterSelector.FilterName.EXCLUDE_CUSTOM_FILTER.name().equals(string)) {
                        profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter((String)object, 20));
                    } else if (FilterSelector.FilterName.INCLUDE_CUSTOM_FILTER.name().equals(string)) {
                        profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter((String)object, 10));
                    }
                }
            }
            object = this.getSelection();
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = ((HashSet)object).toArray(new ClientUtils.SourceCodeSelection[0]);
            profilingSettings.addRootMethods(sourceCodeSelectionArray);
            if (Boolean.parseBoolean(this.readFlag(OUTGOING_CALLS_ENABLED_FLAG, Boolean.TRUE.toString()))) {
                profilingSettings.setStackDepthLimit(Integer.parseInt(this.readFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString())));
            } else {
                profilingSettings.setStackDepthLimit(Integer.MAX_VALUE);
            }
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.storeFlag(OUTGOING_CALLS_ENABLED_FLAG, this.lastOutgoingSelected ? null : Boolean.FALSE.toString());
                String string = this.outgoingSpinner.getValue().toString();
                this.storeFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString().equals(string) ? null : string);
                String string2 = FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.equals((Object)this.filterName) ? null : this.filterName.name();
                this.storeFlag(FILTER_CALLS_FLAG, string2);
                this.storeFlag(FILTER_CALLS_VALUE_FLAG, this.filterValue.isEmpty() ? null : this.filterValue);
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                if (Boolean.parseBoolean(this.readFlag(OUTGOING_CALLS_ENABLED_FLAG, Boolean.TRUE.toString())) != this.lastOutgoingSelected) {
                    return true;
                }
                if (!this.outgoingSpinner.getValue().toString().equals(this.readFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString()))) {
                    return true;
                }
                String string = this.readFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name());
                if (!string.equals(this.filterName.name())) {
                    return true;
                }
                if (!this.readFlag(FILTER_CALLS_VALUE_FLAG, "").equals(this.filterValue)) {
                    return true;
                }
                if (!this.initSelection(false).equals(this.getSelection())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.ui != null) {
                if ((FilterSelector.FilterName.EXCLUDE_CUSTOM_FILTER.equals((Object)this.filterName) || FilterSelector.FilterName.INCLUDE_CUSTOM_FILTER.equals((Object)this.filterName)) && this.filterValue.isEmpty()) {
                    return false;
                }
            } else {
                String string = this.readFlag(FILTER_CALLS_FLAG, FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.name());
                if ((FilterSelector.FilterName.EXCLUDE_CUSTOM_FILTER.name().equals(string) || FilterSelector.FilterName.INCLUDE_CUSTOM_FILTER.name().equals(string)) && this.readFlag(FILTER_CALLS_VALUE_FLAG, "").isEmpty()) {
                    return false;
                }
            }
            return !this.getSelection().isEmpty();
        }

        HashSet<ClientUtils.SourceCodeSelection> getSelection() {
            if (this.selection == null) {
                this.selection = this.initSelection(true);
            }
            return this.selection;
        }

        private FeatureMode.Selection initSelection(boolean bl) {
            FeatureMode.Selection selection = new FeatureMode.Selection(){

                @Override
                protected void changing() {
                    InstrMethodsMode.this.selectionChanging();
                }

                @Override
                protected void changed() {
                    InstrMethodsMode.this.selectionChanged();
                    InstrMethodsMode.this.updateSelectionCustomizer();
                }
            };
            selection.disableEvents();
            String string = this.readFlag(SELECTION_FLAG, null);
            if (string != null) {
                for (String string2 : string.split(" ")) {
                    selection.add(ClientUtils.stringToSelection((String)string2));
                }
            }
            if (bl) {
                selection.enableEvents();
            }
            return selection;
        }

        private void saveSelection() {
            if (this.selection != null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (ClientUtils.SourceCodeSelection sourceCodeSelection : this.selection) {
                    stringBuilder.append(ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)sourceCodeSelection));
                    stringBuilder.append(" ");
                }
                String string = stringBuilder.toString();
                this.storeFlag(SELECTION_FLAG, string.isEmpty() ? null : string);
            }
        }

        protected abstract int getOutgoingCallsMaximum();

        protected abstract String noSelectionString();

        protected abstract String oneSelectionString();

        protected abstract String multipleSelectionsString(int var1);

        protected abstract Icon getAddIcon();

        protected abstract String getAddTooltip();

        protected abstract void performAddSelection();

        protected abstract void performEditSelection(Component var1);

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                this.ui = new SettingsPanel();
                this.selectionContent = new SettingsPanel();
                this.editSelectionLink = new JButton(){

                    @Override
                    public void setText(String string) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(string));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        InstrMethodsMode.this.performEditSelection(InstrMethodsMode.this.ui);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editSelectionLink.setContentAreaFilled(false);
                this.editSelectionLink.setBorderPainted(true);
                this.editSelectionLink.setMargin(new Insets(0, 0, 0, 0));
                this.editSelectionLink.setBorder(BorderFactory.createEmptyBorder());
                this.editSelectionLink.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionContent.add(this.editSelectionLink);
                this.selectionContent.add(Box.createHorizontalStrut(8));
                Component component = Box.createHorizontalStrut(1);
                component.setBackground(Color.GRAY);
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(true);
                }
                Dimension dimension = component.getMaximumSize();
                dimension.height = 20;
                component.setMaximumSize(dimension);
                this.selectionContent.add(component);
                this.outgoingLabel = new JLabel(Bundle.MethodsFeatureModes_outgoingCalls());
                this.lastOutgoingSelected = Boolean.parseBoolean(this.readFlag(OUTGOING_CALLS_ENABLED_FLAG, Boolean.TRUE.toString()));
                this.outgoingChoice = new JCheckBox(Bundle.MethodsFeatureModes_outgoingCalls(), this.lastOutgoingSelected){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        InstrMethodsMode.this.lastOutgoingSelected = this.isSelected();
                        InstrMethodsMode.this.updateControls();
                        InstrMethodsMode.this.settingsChanged();
                    }
                };
                this.outgoingChoice.setToolTipText(Bundle.MethodsFeatureModes_limitCallTreeToolTip());
                this.outgoingChoice.setOpaque(false);
                this.selectionContent.add(MethodsFeatureModes.createStrut(this.outgoingChoice, 8, true));
                this.selectionContent.add(this.outgoingLabel);
                this.selectionContent.add(this.outgoingChoice);
                Insets insets = this.outgoingChoice.getBorder().getBorderInsets(this.outgoingChoice);
                this.outgoingLabel.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
                this.selectionContent.add(MethodsFeatureModes.createStrut(this.outgoingChoice, 5, false));
                this.outgoingHint = new GrayLabel(Bundle.MethodsFeatureModes_unlimitedCalls());
                this.outgoingHint.setEnabled(false);
                this.outgoingHint.setVisible(!this.outgoingChoice.isSelected());
                this.selectionContent.add(this.outgoingHint);
                int n = Integer.parseInt(this.readFlag(OUTGOING_CALLS_FLAG, OUTGOING_CALLS_DEFAULT.toString()));
                this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(n, 1, this.getOutgoingCallsMaximum(), 1)){

                    public Dimension getPreferredSize() {
                        return this.getMinimumSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getMinimumSize();
                    }

                    protected void fireStateChanged() {
                        InstrMethodsMode.this.settingsChanged();
                        super.fireStateChanged();
                    }
                };
                this.outgoingSpinner.setToolTipText(Bundle.MethodsFeatureModes_limitCallTreeToolTip());
                this.outgoingSpinner.setVisible(this.outgoingChoice.isSelected());
                this.selectionContent.add(this.outgoingSpinner);
                this.selectionContent.add(Box.createHorizontalStrut(10));
                if (UIUtils.isOracleLookAndFeel()) {
                    this.selectionContent.add(Box.createHorizontalStrut(4));
                }
                JLabel jLabel = new JLabel(Bundle.MethodsFeatureModes_filterOutgoingCalls());
                jLabel.setToolTipText(Bundle.MethodsFeatureModes_filterOutgoingTooltip());
                this.selectionContent.add(jLabel);
                this.selectionContent.add(MethodsFeatureModes.createStrut(jLabel, 5, false));
                this.filterLink = new JButton(){

                    @Override
                    public void setText(String string) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(string));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        InstrMethodsMode.this.performEditFilter(this);
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.filterLink.setContentAreaFilled(false);
                this.filterLink.setBorderPainted(true);
                this.filterLink.setMargin(new Insets(0, 0, 0, 0));
                this.filterLink.setBorder(BorderFactory.createEmptyBorder());
                this.filterLink.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionContent.add(this.filterLink);
                this.updateControls();
                this.noSelectionContent = new SettingsPanel();
                GrayLabel grayLabel = new GrayLabel(this.noSelectionString());
                grayLabel.setEnabled(false);
                this.noSelectionContent.add((Component)grayLabel);
                this.noSelectionContent.add(Box.createHorizontalStrut(5));
                this.addSelectionButton = new SmallButton(this.getAddIcon()){

                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        InstrMethodsMode.this.performAddSelection();
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.addSelectionButton.setToolTipText(this.getAddTooltip());
                this.noSelectionContent.add(this.addSelectionButton);
                this.updateSelectionCustomizer();
            }
            return this.ui;
        }

        private void updateSelectionCustomizer() {
            if (this.ui != null) {
                JPanel jPanel;
                int n = this.getSelection().size();
                JPanel jPanel2 = jPanel = n == 0 ? this.noSelectionContent : this.selectionContent;
                if (this.ui.getComponentCount() > 0 && jPanel == this.ui.getComponent(0)) {
                    jPanel = null;
                }
                if (n > 0) {
                    this.editSelectionLink.setText(n == 1 ? this.oneSelectionString() : this.multipleSelectionsString(n));
                }
                if (jPanel != null) {
                    this.ui.removeAll();
                    this.ui.add(jPanel);
                    this.ui.doLayout();
                    this.ui.repaint();
                }
            }
        }

        private void updateControls() {
            boolean bl = FilterSelector.FilterName.NO_FILTER.equals((Object)this.filterName) || FilterSelector.FilterName.EXCLUDE_JAVA_FILTER.equals((Object)this.filterName);
            this.outgoingLabel.setVisible(bl);
            this.outgoingChoice.setVisible(!bl);
            if (bl) {
                this.outgoingChoice.setSelected(true);
            } else {
                this.outgoingChoice.setSelected(this.lastOutgoingSelected);
            }
            boolean bl2 = this.outgoingChoice.isSelected();
            this.outgoingSpinner.setVisible(bl2);
            this.outgoingHint.setVisible(!bl2);
            this.filterLink.setText(this.filterName.toString());
        }

        private void performEditFilter(Component component) {
            new FilterSelector(){

                @Override
                protected void filterChanged(FilterSelector.FilterName filterName, String string) {
                    InstrMethodsMode.this.filterName = filterName;
                    InstrMethodsMode.this.filterValue = string;
                    InstrMethodsMode.this.updateControls();
                    InstrMethodsMode.this.settingsChanged();
                }
            }.show(component.getParent(), this.filterName, this.filterValue);
        }
    }

    static abstract class ProjectClassesMode
    extends SampledMethodsMode {
        private final Collection<Lookup.Provider> selectedProjects = new HashSet<Lookup.Provider>();
        private static final String PROJECTS_FLAG = "PROJECTS_FLAG";
        private JComponent ui;
        private JButton editProjectLink;

        abstract Lookup.Provider getProject();

        ProjectClassesMode() {
            Collection<File> collection = this.createFilesFromStorage();
            if (collection.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            } else {
                for (File file : collection) {
                    Lookup.Provider provider;
                    if (!file.exists()) continue;
                    FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    Lookup.Provider provider2 = provider = fileObject == null ? null : ProjectUtilities.getProject((FileObject)fileObject);
                    if (fileObject == null) continue;
                    this.selectedProjects.add(provider);
                }
                this.verifySelectedProjects(false);
            }
        }

        @Override
        String getID() {
            return "ProjectClassesMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_projectClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            Lookup.Provider provider2;
            super.configureSettings(profilingSettings);
            StringBuilder stringBuilder = new StringBuilder();
            for (Lookup.Provider provider2 : this.selectedProjects) {
                ProjectContentsSupport projectContentsSupport = ProjectContentsSupport.get((Lookup.Provider)provider2);
                stringBuilder.append(projectContentsSupport.getInstrumentationFilter(false));
                stringBuilder.append(" ");
                projectContentsSupport.reset();
            }
            String string = stringBuilder.toString().replace(". ", ".* ").replace(".,", ".*,").trim();
            provider2 = new JavaTypeFilter(string, 10);
            profilingSettings.setInstrumentationFilter((GenericFilter)provider2);
        }

        @Override
        void confirmSettings() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.saveSelection();
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                assert (SwingUtilities.isEventDispatchThread());
                if (!this.filesEquals(this.createFilesFromSelection(), this.createFilesFromStorage())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !this.selectedProjects.isEmpty();
        }

        private void saveSelection() {
            Collection<File> collection = this.createFilesFromSelection();
            if (collection.isEmpty()) {
                this.storeFlag(PROJECTS_FLAG, null);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (File file : collection) {
                    try {
                        stringBuilder.append(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        stringBuilder.append(file.getAbsolutePath());
                    }
                    stringBuilder.append(File.pathSeparatorChar);
                }
                this.storeFlag(PROJECTS_FLAG, stringBuilder.toString());
            }
        }

        private Collection<File> createFilesFromStorage() {
            HashSet<File> hashSet = new HashSet<File>();
            String string = this.readFlag(PROJECTS_FLAG, null);
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(File.pathSeparator)) {
                    hashSet.add(new File(string2));
                }
            }
            return hashSet;
        }

        private Collection<File> createFilesFromSelection() {
            HashSet<File> hashSet = new HashSet<File>();
            if (this.selectedProjects.size() > 1 || !this.selectedProjects.contains(this.getProject())) {
                for (Lookup.Provider provider : this.selectedProjects) {
                    hashSet.add(FileUtil.toFile((FileObject)ProjectUtilities.getProjectDirectory((Lookup.Provider)provider)));
                }
            }
            return hashSet;
        }

        private boolean filesEquals(Collection<File> collection, Collection<File> collection2) {
            if (collection.size() != collection2.size()) {
                return false;
            }
            for (File file : collection) {
                if (collection2.contains(file)) continue;
                return false;
            }
            return true;
        }

        private void verifySelectedProjects(boolean bl) {
            if (this.selectedProjects.size() == 1 && this.selectedProjects.contains(this.getProject())) {
                return;
            }
            List<Lookup.Provider> list = Arrays.asList(ProjectUtilities.getOpenedProjects());
            Iterator<Lookup.Provider> iterator = this.selectedProjects.iterator();
            while (iterator.hasNext()) {
                if (list.contains(iterator.next())) continue;
                iterator.remove();
            }
            if (this.selectedProjects.isEmpty()) {
                this.selectedProjects.add(this.getProject());
            }
            if (bl) {
                this.refreshProjectsLink();
            }
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                final ChangeListener changeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectClassesMode.this.verifySelectedProjects(true);
                            }
                        });
                    }
                };
                this.ui = new SettingsPanel(){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        ProjectUtilities.addOpenProjectsListener((ChangeListener)changeListener);
                    }

                    @Override
                    public void removeNotify() {
                        ProjectUtilities.removeOpenProjectsListener((ChangeListener)changeListener);
                        super.removeNotify();
                    }
                };
                this.editProjectLink = new JButton(){

                    @Override
                    public void setText(String string) {
                        super.setText(Bundle.MethodsFeatureModes_editLink(string));
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ProjectClassesMode.this.performEditProject();
                    }

                    @Override
                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.editProjectLink.setContentAreaFilled(false);
                this.editProjectLink.setBorderPainted(true);
                this.editProjectLink.setMargin(new Insets(0, 0, 0, 0));
                this.editProjectLink.setBorder(BorderFactory.createEmptyBorder());
                this.editProjectLink.setCursor(Cursor.getPredefinedCursor(12));
                this.refreshProjectsLink();
                this.ui.add(this.editProjectLink);
            }
            return this.ui;
        }

        private void performEditProject() {
            new ProjectsSelector(this.selectedProjects){

                @Override
                protected void selectionChanged(Collection<Lookup.Provider> collection) {
                    ProjectClassesMode.this.selectedProjects.clear();
                    ProjectClassesMode.this.selectedProjects.addAll(collection);
                    ProjectClassesMode.this.refreshProjectsLink();
                    ProjectClassesMode.this.settingsChanged();
                }
            }.show(this.ui);
        }

        private void refreshProjectsLink() {
            if (this.editProjectLink == null) {
                return;
            }
            if (this.selectedProjects.size() == 1) {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProject(ProjectUtilities.getDisplayName((Lookup.Provider)this.selectedProjects.iterator().next())));
            } else {
                this.editProjectLink.setText(Bundle.MethodsFeatureModes_selectedProjects(this.selectedProjects.size()));
            }
        }
    }

    static abstract class AllClassesMode
    extends SampledMethodsMode {
        AllClassesMode() {
        }

        @Override
        String getID() {
            return "AllClassesMode";
        }

        @Override
        String getName() {
            return Bundle.MethodsFeatureModes_allClasses();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            super.configureSettings(profilingSettings);
            profilingSettings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
        }
    }

    private static abstract class SampledMethodsMode
    extends MethodsMode {
        private SampledMethodsMode() {
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            super.configureSettings(profilingSettings);
            profilingSettings.setProfilingType(64);
            profilingSettings.setCPUProfilingType(2);
        }

        @Override
        void confirmSettings() {
        }

        @Override
        boolean pendingChanges() {
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            return true;
        }

        @Override
        JComponent getUI() {
            return null;
        }
    }

    private static abstract class MethodsMode
    extends FeatureMode {
        private MethodsMode() {
        }

        void initialize() {
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
        }
    }
}

