/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import org.netbeans.modules.masterfs.providers.Notifier;
import org.netbeans.modules.masterfs.watcher.NotifierAccessor;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileObject;

class NotifierKeyRef<KEY>
extends WeakReference<FileObject> {
    private final KEY key;
    private final int hash;
    private final Notifier<KEY> outer;

    public NotifierKeyRef(FileObject fileObject, KEY KEY, ReferenceQueue<FileObject> referenceQueue, Notifier<KEY> notifier) {
        super(fileObject, referenceQueue);
        this.outer = notifier;
        this.key = KEY;
        this.hash = fileObject.hashCode();
        if (KEY != null) {
            Watcher.LOG.log(Level.FINE, "Adding watch for {0}", KEY);
        }
    }

    @Override
    public FileObject get() {
        return (FileObject)super.get();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            NotifierKeyRef notifierKeyRef = (NotifierKeyRef)object;
            FileObject fileObject = this.get();
            FileObject fileObject2 = notifierKeyRef.get();
            if (fileObject == null) {
                return fileObject2 == null;
            }
            return fileObject.equals(fileObject2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    final void removeWatch() throws IOException {
        Watcher.LOG.log(Level.FINE, "Removing watch for {0}", this.key);
        NotifierAccessor.getDefault().removeWatch(this.outer, this.key);
    }

    public int hashCode() {
        return this.hash;
    }
}

