/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_br extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "eur c\u02bchoa\u00f1v Moskov",
               "",
               "eur ha\u00f1v Moskov",
               "",
               "eur Moskov",
               "",
            };
        final String[] Pakistan = new String[] {
               "eur c\u02bchoa\u00f1v Pakistan",
               "",
               "eur ha\u00f1v Pakistan",
               "",
               "eur Pakistan",
               "",
            };
        final String[] Magadan = new String[] {
               "eur c\u02bchoa\u00f1v Magadan",
               "",
               "eur ha\u00f1v Magadan",
               "",
               "eur Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "eur c\u02bchoa\u00f1v Kreizeuropa",
               "",
               "eur ha\u00f1v Kreizeuropa",
               "",
               "eur Kreizeuropa",
               "",
            };
        final String[] America_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v ar Reter",
               "",
               "eur ha\u00f1v ar Reter",
               "",
               "eur ar Reter",
               "",
            };
        final String[] New_Zealand = new String[] {
               "eur c\u02bchoa\u00f1v Zeland-Nevez",
               "",
               "eur ha\u00f1v Zeland-Nevez",
               "",
               "eur Zeland-Nevez",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "eur Meurvor Indez",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "eur c\u02bchoa\u00f1v Yakutsk",
               "",
               "eur ha\u00f1v Yakutsk",
               "",
               "eur Yakutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "eur Timor ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "eur Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Europa ar Reter",
               "",
               "eur ha\u00f1v Europa ar Reter",
               "",
               "eur Europa ar Reter",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "eur c\u02bchoa\u00f1v Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "",
               "eur Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Bolivia = new String[] {
               "eur Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "eur c\u02bchoa\u00f1v Sant-P\u00ear-ha-Mikelon",
               "",
               "eur ha\u00f1v Sant-P\u00ear-ha-Mikelon",
               "",
               "eur Sant-P\u00ear-ha-Mikelon",
               "",
            };
        final String[] Indochina = new String[] {
               "eur Indez-Sina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "eur c\u02bchoa\u00f1v Yekaterinbourg",
               "",
               "eur ha\u00f1v Yekaterinbourg",
               "",
               "eur Yekaterinbourg",
               "",
            };
        final String[] Maldives = new String[] {
               "eur ar Maldivez",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "eur Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "eur Wallis ha Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "eur c\u02bchoa\u00f1v Suafrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "eur Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "eur Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "eur c\u02bchoa\u00f1v Ouzbekistan",
               "",
               "eur ha\u00f1v Ouzbekistan",
               "",
               "eur Ouzbekistan",
               "",
            };
        final String[] Mongolia = new String[] {
               "eur c\u02bchoa\u00f1v Ulaanbaatar",
               "",
               "eur ha\u00f1v Ulaanbaatar",
               "",
               "eur Ulaanbaatar",
               "",
            };
        final String[] America_Central = new String[] {
               "eur c\u02bchoa\u00f1v ar C\u02bchreiz",
               "",
               "eur ha\u00f1v ar C\u02bchreiz",
               "",
               "eur ar C\u02bchreiz",
               "",
            };
        final String[] Niue = new String[] {
               "eur Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "eur Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "eur c\u02bchoa\u00f1v Inizi Falkland",
               "",
               "eur ha\u00f1v Inizi Falkland",
               "",
               "eur Inizi Falkland",
               "",
            };
        final String[] Apia = new String[] {
               "eur c\u02bchoa\u00f1v Apia",
               "",
               "eur ha\u00f1v Apia",
               "",
               "eur Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "eur Bhoutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "eur Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "eur Kazakstan ar C\u02bchorn\u00f4g",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "eur Enez Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "eur ar Re\u00fcnion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "eur Inizi Kokoz",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "eur c\u02bchoa\u00f1v Chatham",
               "",
               "eur ha\u00f1v Chatham",
               "",
               "eur Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "eur Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "eur c\u02bchoa\u00f1v Arc\u02bchantina",
               "",
               "eur ha\u00f1v Arc\u02bchantina",
               "",
               "eur Arc\u02bchantina",
               "",
            };
        final String[] Gambier = new String[] {
               "eur Inizi Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "eur Inizi Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "eur Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "eur Inizi Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "eur c\u02bchoa\u00f1v ar C\u02bchab-Glas",
               "",
               "eur ha\u00f1v ar C\u02bchab-Glas",
               "",
               "eur ar C\u02bchab-Glas",
               "",
            };
        final String[] Norfolk = new String[] {
               "eur Enez Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "eur c\u02bchoa\u00f1v Samoa",
               "",
               "eur ha\u00f1v Samoa",
               "",
               "eur Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "eur Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "eur c\u02bchoa\u00f1v Kuba",
               "",
               "eur ha\u00f1v Kuba",
               "",
               "eur Kuba",
               "",
            };
        final String[] GMT = new String[] {
               "Amzer keitat Greenwich (AKG)",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "eur c\u02bchoa\u00f1v ar Filipinez",
               "",
               "eur ha\u00f1v ar Filipinez",
               "",
               "eur ar Filipinez",
               "",
            };
        final String[] French_Southern = new String[] {
               "eur Douaro\u00f9 aostral Fra\u00f1s hag Antarktika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "eur c\u02bchoa\u00f1v Kaledonia Nevez",
               "",
               "eur ha\u00f1v Kaledonia Nevez",
               "",
               "eur Kaledonia Nevez",
               "",
            };
        final String[] Brunei = new String[] {
               "eur Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "eur c\u02bchoa\u00f1v Iran",
               "",
               "eur ha\u00f1v Iran",
               "",
               "eur Iran",
               "",
            };
        final String[] Tajikistan = new String[] {
               "eur Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "eur c\u02bchoa\u00f1v Tonga",
               "",
               "eur ha\u00f1v Tonga",
               "",
               "eur Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "eur c\u02bchoa\u00f1v Bangladesh",
               "",
               "eur ha\u00f1v Bangladesh",
               "",
               "eur Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "eur c\u02bchoa\u00f1v Perou",
               "",
               "eur ha\u00f1v Perou",
               "",
               "eur Perou",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Greunland ar Reter",
               "",
               "eur ha\u00f1v Greunland ar Reter",
               "",
               "eur Greunland ar Reter",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "eur Indonezia ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "eur Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Aostralia ar Reter",
               "",
               "eur ha\u00f1v Aostralia ar Reter",
               "",
               "eur Aostralia ar Reter",
               "",
            };
        final String[] French_Guiana = new String[] {
               "eur Gwiana c\u02bchall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "eur c\u02bchoa\u00f1v Kolombia",
               "",
               "eur ha\u00f1v Kolombia",
               "",
               "eur Kolombia",
               "",
            };
        final String[] Chile = new String[] {
               "eur c\u02bchoa\u00f1v Chile",
               "",
               "eur ha\u00f1v Chile",
               "",
               "eur Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "eur Inizi Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "eur c\u02bchoa\u00f1v Irkutsk",
               "",
               "eur ha\u00f1v Irkutsk",
               "",
               "eur Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "eur c\u02bchoa\u00f1v Jorjia",
               "",
               "eur ha\u00f1v Jorjia",
               "",
               "eur Jorjia",
               "",
            };
        final String[] Choibalsan = new String[] {
               "eur c\u02bchoa\u00f1v Choibalsan",
               "",
               "eur ha\u00f1v Choibalsan",
               "",
               "eur Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "eur c\u02bchoa\u00f1v Sina",
               "",
               "eur ha\u00f1v Sina",
               "",
               "eur Sina",
               "",
            };
        final String[] Armenia = new String[] {
               "eur c\u02bchoa\u00f1v Armenia",
               "",
               "eur ha\u00f1v Armenia",
               "",
               "eur Armenia",
               "",
            };
        final String[] Africa_Central = new String[] {
               "eur Kreizafrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "eur c\u02bchoa\u00f1v Japan",
               "",
               "eur ha\u00f1v Japan",
               "",
               "eur Japan",
               "",
            };
        final String[] Taipei = new String[] {
               "eur c\u02bchoa\u00f1v Taipei",
               "",
               "eur ha\u00f1v Taipei",
               "",
               "eur Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "eur c\u02bchoa\u00f1v Hovd",
               "",
               "eur ha\u00f1v Hovd",
               "",
               "eur Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "eur c\u02bchoa\u00f1v Kreizaostralia ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Kreizaostralia ar C\u02bchorn\u00f4g",
               "",
               "eur Kreizaostralia ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Sakhalin = new String[] {
               "eur c\u02bchoa\u00f1v Sakhalin",
               "",
               "eur ha\u00f1v Sakhalin",
               "",
               "eur Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "eur c\u02bchoa\u00f1v Paraguay",
               "",
               "eur ha\u00f1v Paraguay",
               "",
               "eur Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "eur Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "eur c\u02bchoa\u00f1v Moris",
               "",
               "eur ha\u00f1v Moris",
               "",
               "eur Moris",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "eur Afrika ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "eur Inizi Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "eur Inizi Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "eur c\u02bchoa\u00f1v Newfoundland",
               "",
               "eur ha\u00f1v Newfoundland",
               "",
               "eur Newfoundland",
               "",
            };
        final String[] Afghanistan = new String[] {
               "eur Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "eur c\u02bchoa\u00f1v Hong Kong",
               "",
               "eur ha\u00f1v Hong Kong",
               "",
               "eur Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "eur c\u02bchoa\u00f1v an Atlantel",
               "",
               "eur ha\u00f1v an Atlantel",
               "",
               "eur an Atlantel",
               "",
            };
        final String[] Israel = new String[] {
               "eur c\u02bchoa\u00f1v Israel",
               "",
               "eur ha\u00f1v Israel",
               "",
               "eur Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "eur Kreiz Indonezia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "eur c\u02bchoa\u00f1v Omsk",
               "",
               "eur ha\u00f1v Omsk",
               "",
               "eur Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "eur Sechelez",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "eur c\u02bchoa\u00f1v Uruguay",
               "",
               "eur ha\u00f1v Uruguay",
               "",
               "eur Uruguay",
               "",
            };
        final String[] Nepal = new String[] {
               "eur Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "eur Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "eur c\u02bchoa\u00f1v Vanuatu",
               "",
               "eur ha\u00f1v Vanuatu",
               "",
               "eur Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "eur c\u02bchoa\u00f1v Novosibirsk",
               "",
               "eur ha\u00f1v Novosibirsk",
               "",
               "eur Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "eur c\u02bchoa\u00f1v Singapour",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "eur c\u02bchoa\u00f1v an Azorez",
               "",
               "eur ha\u00f1v an Azorez",
               "",
               "eur an Azorez",
               "",
            };
        final String[] Suriname = new String[] {
               "eur Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "eur c\u02bchoa\u00f1v Krasnoyarsk",
               "",
               "eur ha\u00f1v Krasnoyarsk",
               "",
               "eur Krasnoyarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "eur Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "eur c\u02bchoa\u00f1v an Amazon",
               "",
               "eur ha\u00f1v an Amazon",
               "",
               "eur an Amazon",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "eur Kazakstan ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "eur c\u02bchoa\u00f1v Fidji",
               "",
               "eur ha\u00f1v Fidji",
               "",
               "eur Fidji",
               "",
            };
        final String[] Tuvalu = new String[] {
               "eur Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "eur Enez Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "eur c\u02bchoa\u00f1v Kreizaostralia",
               "",
               "eur ha\u00f1v Kreizaostralia",
               "",
               "eur Kreizaostralia",
               "",
            };
        final String[] America_Pacific = new String[] {
               "eur c\u02bchoa\u00f1v an Habask",
               "",
               "eur ha\u00f1v an Habask",
               "",
               "eur an Habask",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "eur c\u02bchoa\u00f1v Turkmenistan",
               "",
               "eur ha\u00f1v Turkmenistan",
               "",
               "eur Turkmenistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "eur c\u02bchoa\u00f1v Europa ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Europa ar C\u02bchorn\u00f4g",
               "",
               "eur Europa ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Guyana = new String[] {
               "eur Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "eur Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "eur Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "eur Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "eur c\u02bchoa\u00f1v Azerbaidjan",
               "",
               "eur ha\u00f1v Azerbaidjan",
               "",
               "eur Azerbaidjan",
               "",
            };
        final String[] Mawson = new String[] {
               "eur Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "eur c\u02bchoa\u00f1v Afrika ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Afrika ar C\u02bchorn\u00f4g",
               "",
               "eur Afrika ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] South_Georgia = new String[] {
               "eur Georgia ar Su",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "eur c\u02bchoa\u00f1v Volgograd",
               "",
               "eur ha\u00f1v Volgograd",
               "",
               "eur Volgograd",
               "",
            };
        final String[] Easter = new String[] {
               "eur c\u02bchoa\u00f1v Enez Pask",
               "",
               "eur ha\u00f1v Enez Pask",
               "",
               "eur Enez Pask",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "eur c\u02bchoa\u00f1v Gwalarn Mec\u02bchiko",
               "",
               "eur ha\u00f1v Gwalarn Mec\u02bchiko",
               "",
               "eur Gwalarn Mec\u02bchiko",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "eur Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "eur c\u02bchoa\u00f1v Greunland ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Greunland ar C\u02bchorn\u00f4g",
               "",
               "eur Greunland ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Ecuador = new String[] {
               "eur Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "eur c\u02bchoa\u00f1v ar Pleg-mor Arab-ha-Pers",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "eur c\u02bchoa\u00f1v Korea",
               "",
               "eur ha\u00f1v Korea",
               "",
               "eur Korea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "eur c\u02bchoa\u00f1v Aostralia ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Aostralia ar C\u02bchorn\u00f4g",
               "",
               "eur Aostralia ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "eur Indonezia ar C\u02bchorn\u00f4g",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "eur c\u02bchoa\u00f1v ar Menezio\u00f9",
               "",
               "eur ha\u00f1v ar Menezio\u00f9",
               "",
               "eur ar Menezio\u00f9",
               "",
            };
        final String[] Marquesas = new String[] {
               "eur Inizi Markiz",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "eur c\u02bchoa\u00f1v Arabia",
               "",
               "eur ha\u00f1v Arabia",
               "",
               "eur Arabia",
               "",
            };
        final String[] Alaska = new String[] {
               "eur c\u02bchoa\u00f1v Alaska",
               "",
               "eur ha\u00f1v Alaska",
               "",
               "eur Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "eur c\u02bchoa\u00f1v Vladivostok",
               "",
               "eur ha\u00f1v Vladivostok",
               "",
               "eur Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "eur Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "eur Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "eur Papoua-Ginea-Nevez",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "eur c\u02bchoa\u00f1v Fernando de Noronha",
               "",
               "eur ha\u00f1v Fernando de Noronha",
               "",
               "eur Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "eur c\u02bchoa\u00f1v Bras\u00edlia",
               "",
               "eur ha\u00f1v Bras\u00edlia",
               "",
               "eur Bras\u00edlia",
               "",
            };
        final String[] Anadyr = new String[] {
               "eur c\u02bchoa\u00f1v Anadyr\u02bc",
               "",
               "eur ha\u00f1v Anadyr\u02bc",
               "",
               "eur Anadyr\u02bc",
               "",
            };
        final String[] India = new String[] {
               "eur c\u02bchoa\u00f1v India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "eur c\u02bchoa\u00f1v Inizi Cook",
               "",
               "eur ha\u00f1v Inizi Cook",
               "",
               "eur Inizi Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Markiz" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "",
                    "eur ha\u00f1v Breizh-Veur",
                    "",
                    "",
                    "",
                }
            },
            { "America/Panama", America_Eastern },
            { "timezone.excity.Pacific/Fiji", "Fidji" },
            { "timezone.excity.Europe/Gibraltar", "Jibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londrez" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Godthab", "Nuuk (Godth\u00e5b)" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jerzenez" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia ar Su" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnum P\u00e9nh" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Masqat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "La\u02bcYoun" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "k\u00ear dianav" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Q\u00e2n\u00e2q" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Bakou" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.Africa/Algiers", "Aljer" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "Africa/Accra", GMT },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Europe/Dublin",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "",
                    "eur c\u02bchoa\u00f1v Iwerzhon",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luksembourg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Manav" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Tchita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr\u02bc" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Muqdisho" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Koweit" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskov" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "",
                    "eur ha\u00f1v Breizh-Veur",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dulenn" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kab Glas" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Azorez" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Viangchan" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tiran\u00eb" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "amzer hollvedel kenurzhiet",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kamtchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Asia/Tashkent", "Toshkent" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Enez Pask" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Atlantic/Canary", "Kanariez" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.Africa/Casablanca", "Dar el Beida (Casablanca)" },
            { "Etc/GMT", GMT },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Africa/Cairo", "Kaero" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Gwadeloup" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Mensk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Asia/Beirut", "Bayrut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Baghdad" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Sant Visant" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.Indian/Kerguelen", "Kergelenn" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tarabulus (Tripoli)" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Asia/Pyongyang", "P\u02bcyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Aten" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "Pacific/Pitcairn", Pitcairn },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "K\u00ear H\u00f4-Chi-Minh" },
            { "America/North_Dakota/Beulah", America_Central },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinbourg" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.America/Mexico_City", "K\u00ear Vec\u02bchiko" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolamba" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.Europe/Guernsey", "Gwernenez" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "SystemV/EST5", America_Eastern },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Moris" },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Marjehamn" },
            { "timezone.excity.America/St_Johns", "Saint John\u02bcs" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u02bcDjamena" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tuniz" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapour" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vienna" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Levkos\u00eda" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "Faero" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Re\u00fcnion" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kaboul" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudez" },
            { "timezone.excity.Indian/Cocos", "Kokoz" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komorez" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Indian/Maldives", "Maldivez" },
        };
        return data;
    }
}
