/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.xml.SAXAdapter;
import org.objectweb.asm.xml.SAXClassAdapter;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXAnnotationAdapter
extends AnnotationVisitor {
    SAXAdapter sa;
    private final String elementName;

    public SAXAnnotationAdapter(SAXAdapter sAXAdapter, String string2, int n, String string3, String string4) {
        this(262144, sAXAdapter, string2, n, string4, string3, -1);
    }

    public SAXAnnotationAdapter(SAXAdapter sAXAdapter, String string2, int n, int n2, String string3) {
        this(262144, sAXAdapter, string2, n, string3, null, n2);
    }

    protected SAXAnnotationAdapter(int n, SAXAdapter sAXAdapter, String string2, int n2, String string3, String string4, int n3) {
        super(n);
        this.sa = sAXAdapter;
        this.elementName = string2;
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string4 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string4);
        }
        if (n2 != 0) {
            attributesImpl.addAttribute("", "visible", "visible", "", n2 > 0 ? "true" : "false");
        }
        if (n3 != -1) {
            attributesImpl.addAttribute("", "parameter", "parameter", "", Integer.toString(n3));
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string3);
        }
        sAXAdapter.addStart(string2, attributesImpl);
    }

    public void visit(String string2, Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            AnnotationVisitor annotationVisitor = this.visitArray(string2);
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    annotationVisitor.visit(null, new Byte(byArray[i]));
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    annotationVisitor.visit(null, new Character(cArray[i]));
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    annotationVisitor.visit(null, new Short(sArray[i]));
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    annotationVisitor.visit(null, blArray[i]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    annotationVisitor.visit(null, new Integer(nArray[i]));
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    annotationVisitor.visit(null, new Long(lArray[i]));
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    annotationVisitor.visit(null, new Float(fArray[i]));
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    annotationVisitor.visit(null, new Double(dArray[i]));
                }
            }
            annotationVisitor.visitEnd();
        } else {
            this.addValueElement("annotationValue", string2, Type.getDescriptor(clazz), object.toString());
        }
    }

    public void visitEnum(String string2, String string3, String string4) {
        this.addValueElement("annotationValueEnum", string2, string3, string4);
    }

    public AnnotationVisitor visitAnnotation(String string2, String string3) {
        return new SAXAnnotationAdapter(this.sa, "annotationValueAnnotation", 0, string2, string3);
    }

    public AnnotationVisitor visitArray(String string2) {
        return new SAXAnnotationAdapter(this.sa, "annotationValueArray", 0, string2, null);
    }

    public void visitEnd() {
        this.sa.addEnd(this.elementName);
    }

    private void addValueElement(String string2, String string3, String string4, String string5) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string3 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string3);
        }
        if (string4 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string4);
        }
        if (string5 != null) {
            attributesImpl.addAttribute("", "value", "value", "", SAXClassAdapter.encode(string5));
        }
        this.sa.addElement(string2, attributesImpl);
    }
}

