/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    protected boolean clockwise;
    private boolean _rotateIcon = true;
    private static Rectangle s_oPaintIconRectangle;
    private static Rectangle s_oPaintTextRectangle;
    private static Rectangle s_oPaintViewRectangle;
    private static Insets s_oPaintViewInsets;

    public VerticalLabelUI(boolean bl) {
        this.clockwise = bl;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        s_oPaintViewInsets = jComponent.getInsets(s_oPaintViewInsets);
        VerticalLabelUI.s_oPaintViewRectangle.x = VerticalLabelUI.s_oPaintViewInsets.left;
        VerticalLabelUI.s_oPaintViewRectangle.y = VerticalLabelUI.s_oPaintViewInsets.top;
        VerticalLabelUI.s_oPaintViewRectangle.height = jComponent.getWidth() - (VerticalLabelUI.s_oPaintViewInsets.left + VerticalLabelUI.s_oPaintViewInsets.right);
        VerticalLabelUI.s_oPaintViewRectangle.width = jComponent.getHeight() - (VerticalLabelUI.s_oPaintViewInsets.top + VerticalLabelUI.s_oPaintViewInsets.bottom);
        VerticalLabelUI.s_oPaintIconRectangle.height = 0;
        VerticalLabelUI.s_oPaintIconRectangle.width = 0;
        VerticalLabelUI.s_oPaintIconRectangle.y = 0;
        VerticalLabelUI.s_oPaintIconRectangle.x = 0;
        VerticalLabelUI.s_oPaintTextRectangle.height = 0;
        VerticalLabelUI.s_oPaintTextRectangle.width = 0;
        VerticalLabelUI.s_oPaintTextRectangle.y = 0;
        VerticalLabelUI.s_oPaintTextRectangle.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, s_oPaintViewRectangle, s_oPaintIconRectangle, s_oPaintTextRectangle);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (!this.isRotateIcon() && icon != null) {
            icon.paintIcon(jComponent, graphics, VerticalLabelUI.s_oPaintIconRectangle.x, VerticalLabelUI.s_oPaintIconRectangle.y);
        }
        if (this.clockwise) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -jComponent.getWidth());
        } else {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-jComponent.getHeight(), 0);
        }
        if (this.isRotateIcon() && icon != null) {
            icon.paintIcon(jComponent, graphics, VerticalLabelUI.s_oPaintIconRectangle.x, VerticalLabelUI.s_oPaintIconRectangle.y);
        }
        if (string != null) {
            int n = VerticalLabelUI.s_oPaintTextRectangle.x;
            int n2 = VerticalLabelUI.s_oPaintTextRectangle.y + fontMetrics.getAscent();
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string2, n, n2);
            } else {
                this.paintDisabledText(jLabel, graphics, string2, n, n2);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    public boolean isRotateIcon() {
        return this._rotateIcon;
    }

    public void setRotateIcon(boolean bl) {
        this._rotateIcon = bl;
    }

    static {
        labelUI = new VerticalLabelUI(false);
        s_oPaintIconRectangle = new Rectangle();
        s_oPaintTextRectangle = new Rectangle();
        s_oPaintViewRectangle = new Rectangle();
        s_oPaintViewInsets = new Insets(0, 0, 0, 0);
    }
}

