/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialogEinstellungen.PanelBlacklist;
import mediathek.gui.dialogEinstellungen.PanelDateinamen;
import mediathek.gui.dialogEinstellungen.PanelDownload;
import mediathek.gui.dialogEinstellungen.PanelEinstellungenColor;
import mediathek.gui.dialogEinstellungen.PanelEinstellungenErweitert;
import mediathek.gui.dialogEinstellungen.PanelEinstellungenGeo;
import mediathek.gui.dialogEinstellungen.PanelFilmlisteLaden;
import mediathek.gui.dialogEinstellungen.PanelMediaDB;
import mediathek.gui.dialogEinstellungen.PanelNotifications;
import mediathek.gui.dialogEinstellungen.PanelPowerManagement;
import mediathek.gui.dialogEinstellungen.PanelPset;
import mediathek.gui.dialogEinstellungen.PanelPsetImport;
import mediathek.gui.dialogEinstellungen.allgemein.PanelEinstellungen;
import mediathek.mainwindow.MediathekGui;
import mediathek.res.GetIcon;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GuiFunktionen;

public class DialogEinstellungen
extends JFrame {
    private final Daten daten;
    public boolean ok;
    private PanelEinstellungen panelEinstellungen;
    private PanelDownload panelDownload;
    private PanelMediaDB panelMediaDB;
    private PanelEinstellungenErweitert panelEinstellungenErweitert;
    private PanelEinstellungenGeo panelEinstellungenGeo;
    private PanelEinstellungenColor panelEinstellungenColor;
    private PanelFilmlisteLaden panelImportFilme;
    private PanelBlacklist panelBlacklist;
    private PanelDateinamen panelDateinamen;
    private PanelVorlage panelPset;
    private PanelPsetImport panelPsetVorlagen;
    private JPanel panelNotifications;
    private final JPanel panelLeer = new JPanel();
    private JPanel panelPowerManagement;
    private static final String NAME_einstellungen = "Einstellungen";
    private static final String NAME_allgemeineEinstellungen = "Allgemein";
    private static final String NAME_notifications = "Benachrichtigungen";
    private static final String NAME_bandwidth = "Download";
    private static final String NAME_mediaDB = "Mediensammlung";
    private static final String NAME_allgemeineEinstellungenErweitert = "Erweitert";
    private static final String NAME_allgemeineEinstellungenGeo = "Standort & Geoblocking";
    private static final String NAME_allgemeineEinstellungenColor = "Farben";
    private static final String NAME_filmListe = "Filmliste";
    private static final String NAME_filmListeLaden = "Filmliste laden";
    private static final String NAME_blacklist = "Blacklist";
    private static final String NAME_aufzeichnen = "Aufzeichnen und Abspielen";
    private static final String NAME_dateiname = "Datei- und Pfadnamen";
    private static final String NAME_programmset = "Set bearbeiten";
    private static final String NAME_programmsetImportieren = "Set importieren";
    private static final String NAME_power_management = "Power Management";
    private final DefaultMutableTreeNode treeNodeEinstellungen = new DefaultMutableTreeNode("Einstellungen");
    private final DefaultMutableTreeNode treeNodeAllgemeineEinstellungen = new DefaultMutableTreeNode("Allgemein");
    private final DefaultMutableTreeNode treeNodeNotifications = new DefaultMutableTreeNode("Benachrichtigungen");
    private final DefaultMutableTreeNode treeNodeAllgemeineEinstellungenEreweitert = new DefaultMutableTreeNode("Erweitert");
    private final DefaultMutableTreeNode treeNodeAllgemeineEinstellungenGeo = new DefaultMutableTreeNode("Standort & Geoblocking");
    private final DefaultMutableTreeNode treeNodeAllgemeineEinstellungenColor = new DefaultMutableTreeNode("Farben");
    private final DefaultMutableTreeNode treeNodeFilme = new DefaultMutableTreeNode("Filmliste");
    private final DefaultMutableTreeNode treeNodeFilmliste = new DefaultMutableTreeNode("Filmliste laden");
    private final DefaultMutableTreeNode treeNodeBlacklist = new DefaultMutableTreeNode("Blacklist");
    private final DefaultMutableTreeNode treeNodeDownload = new DefaultMutableTreeNode("Aufzeichnen und Abspielen");
    private final DefaultMutableTreeNode treeNodeBandwidth = new DefaultMutableTreeNode("Download");
    private final DefaultMutableTreeNode treeNodeMediaDB = new DefaultMutableTreeNode("Mediensammlung");
    private final DefaultMutableTreeNode treeNodeDateinamen = new DefaultMutableTreeNode("Datei- und Pfadnamen");
    private final DefaultMutableTreeNode treeNodeProgramme = new DefaultMutableTreeNode("Set bearbeiten");
    private final DefaultMutableTreeNode treeNodeImportProgramme = new DefaultMutableTreeNode("Set importieren");
    private final DefaultMutableTreeNode treeNodePowerManagement = new DefaultMutableTreeNode("Power Management");
    private JButton jButtonBeenden;
    private JPanel jPanelExtra;
    private JTree jTree1;

    public DialogEinstellungen() {
        this.initComponents();
        this.setTitle(NAME_einstellungen);
        this.daten = Daten.getInstance();
        this.initPanels();
        this.initTree();
        this.restoreSizeFromConfig();
        this.setIconImage(GetIcon.getIcon("MediathekView.png", "/mediathek/res/", 58, 58).getImage());
        this.jButtonBeenden.addActionListener(e -> this.beenden());
        EscapeKeyHandler.installHandler(this, this::beenden);
    }

    private void restoreSizeFromConfig() {
        int breite = 0;
        int hoehe = 0;
        int posX = 0;
        int posY = 0;
        String[] arr = MVConfig.get(MVConfig.Configs.SYSTEM_GROESSE_EINSTELLUNGEN).split(":");
        try {
            if (arr.length == 4) {
                breite = Integer.parseInt(arr[0]);
                hoehe = Integer.parseInt(arr[1]);
                posX = Integer.parseInt(arr[2]);
                posY = Integer.parseInt(arr[3]);
            }
        }
        catch (Exception ex) {
            breite = 0;
            hoehe = 0;
            posX = 0;
            posY = 0;
        }
        if (breite > 0 && hoehe > 0) {
            this.setSize(breite, hoehe);
        }
        if (posX > 0 && posY > 0) {
            this.setLocation(posX, posY);
        } else {
            MediathekGui parentFrame = MediathekGui.ui();
            if (parentFrame != null) {
                this.setLocationRelativeTo(parentFrame);
            }
        }
    }

    private void initPanels() {
        this.panelEinstellungen = new PanelEinstellungen(this.daten);
        this.panelDownload = new PanelDownload();
        this.panelMediaDB = new PanelMediaDB(this.daten, this);
        this.panelEinstellungenErweitert = new PanelEinstellungenErweitert(this.daten, this);
        this.panelEinstellungenGeo = new PanelEinstellungenGeo(this);
        this.panelEinstellungenColor = new PanelEinstellungenColor();
        this.panelImportFilme = new PanelFilmlisteLaden();
        this.panelBlacklist = new PanelBlacklist(this.daten, this, PanelBlacklist.class.getName());
        this.panelDateinamen = new PanelDateinamen(this.daten, this);
        this.panelPset = new PanelPset(this.daten, this);
        this.panelPsetVorlagen = new PanelPsetImport(this.daten, this);
        this.panelNotifications = new PanelNotifications();
        this.panelPowerManagement = new PanelPowerManagement();
    }

    private void initTree() {
        DefaultMutableTreeNode treeNodeStart = new DefaultMutableTreeNode("MediathekView");
        this.treeNodeEinstellungen.add(this.treeNodeAllgemeineEinstellungen);
        this.treeNodeEinstellungen.add(this.treeNodeNotifications);
        this.treeNodeEinstellungen.add(this.treeNodeAllgemeineEinstellungenEreweitert);
        this.treeNodeEinstellungen.add(this.treeNodeAllgemeineEinstellungenGeo);
        this.treeNodeEinstellungen.add(this.treeNodeAllgemeineEinstellungenColor);
        this.treeNodeEinstellungen.add(this.treeNodeMediaDB);
        this.treeNodeEinstellungen.add(this.treeNodePowerManagement);
        treeNodeStart.add(this.treeNodeEinstellungen);
        this.treeNodeFilme.add(this.treeNodeFilmliste);
        this.treeNodeFilme.add(this.treeNodeBlacklist);
        treeNodeStart.add(this.treeNodeFilme);
        this.treeNodeDownload.add(this.treeNodeDateinamen);
        this.treeNodeDownload.add(this.treeNodeBandwidth);
        this.treeNodeDownload.add(this.treeNodeProgramme);
        this.treeNodeDownload.add(this.treeNodeImportProgramme);
        treeNodeStart.add(this.treeNodeDownload);
        this.jTree1.setModel(new DefaultTreeModel(treeNodeStart));
        this.jTree1.getSelectionModel().setSelectionMode(1);
        this.jTree1.setRootVisible(false);
        this.jTree1.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
            if (node == null) {
                this.jPanelExtra.removeAll();
                this.jPanelExtra.add(this.panelLeer);
            } else {
                String name1 = node.getUserObject().toString();
                this.setTitle(name1);
                switch (name1) {
                    case "Einstellungen": {
                        this.jTree1.setSelectionPath(new TreePath(this.treeNodeAllgemeineEinstellungen.getPath()));
                        break;
                    }
                    case "Benachrichtigungen": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelNotifications);
                        break;
                    }
                    case "Download": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelDownload);
                        break;
                    }
                    case "Mediensammlung": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelMediaDB);
                        break;
                    }
                    case "Allgemein": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelEinstellungen);
                        break;
                    }
                    case "Erweitert": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelEinstellungenErweitert);
                        break;
                    }
                    case "Standort & Geoblocking": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelEinstellungenGeo);
                        break;
                    }
                    case "Farben": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelEinstellungenColor);
                        break;
                    }
                    case "Power Management": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelPowerManagement);
                        break;
                    }
                    case "Filmliste": {
                        this.jTree1.setSelectionPath(new TreePath(this.treeNodeFilmliste.getPath()));
                        break;
                    }
                    case "Filmliste laden": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelImportFilme);
                        break;
                    }
                    case "Blacklist": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelBlacklist);
                        break;
                    }
                    case "Aufzeichnen und Abspielen": {
                        this.jTree1.setSelectionPath(new TreePath(this.treeNodeDateinamen.getPath()));
                        break;
                    }
                    case "Datei- und Pfadnamen": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelDateinamen);
                        break;
                    }
                    case "Set bearbeiten": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelPset);
                        break;
                    }
                    case "Set importieren": {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelPsetVorlagen);
                        break;
                    }
                    default: {
                        this.jPanelExtra.removeAll();
                        this.jPanelExtra.add(this.panelLeer);
                        this.setTitle("Programmeinstellungen");
                    }
                }
            }
            this.jPanelExtra.updateUI();
        });
        for (int i = 0; i < this.jTree1.getRowCount(); ++i) {
            this.jTree1.expandRow(i);
        }
        TreePath tp = new TreePath(this.treeNodeAllgemeineEinstellungen.getPath());
        this.jTree1.setSelectionPath(tp);
    }

    private void beenden() {
        GuiFunktionen.getSize(MVConfig.Configs.SYSTEM_GROESSE_EINSTELLUNGEN, this);
        this.daten.allesSpeichern();
        this.dispose();
    }

    private void initComponents() {
        this.jButtonBeenden = new JButton();
        JSplitPane jSplitPane1 = new JSplitPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Schlie\u00dfen");
        jSplitPane1.setBorder(BorderFactory.createEtchedBorder());
        jSplitPane1.setDividerLocation(250);
        jSplitPane1.setContinuousLayout(true);
        jSplitPane1.setOneTouchExpandable(true);
        this.jPanelExtra.setLayout(new BorderLayout());
        jScrollPane2.setViewportView(this.jPanelExtra);
        jSplitPane1.setRightComponent(jScrollPane2);
        this.jTree1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jTree1.setRootVisible(false);
        jScrollPane1.setViewportView(this.jTree1);
        jSplitPane1.setLeftComponent(jScrollPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jSplitPane1, -1, 1068, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 965, Short.MAX_VALUE).addComponent(this.jButtonBeenden))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jSplitPane1, -1, 620, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBeenden).addGap(6, 6, 6)));
        this.pack();
    }
}

