/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.ErrorCode;
import com.gitlab.pdftk_java.TK_Session;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class pdftk {
    static final String PDFTK_VER = "3.1.3";
    static final boolean ASK_ABOUT_WARNINGS = false;

    static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int readBytes;
        int bufferSize = 8192;
        byte[] buffer = new byte[8192];
        while ((readBytes = inputStream.read(buffer, 0, 8192)) >= 0) {
            outputStream.write(buffer, 0, readBytes);
        }
    }

    static byte[] readAllBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        pdftk.copyStream(inputStream, outputStream);
        return outputStream.toByteArray();
    }

    static String prompt_for_password(String pass_name, String pass_app) {
        System.out.println("Please enter the " + pass_name + " password to use on " + pass_app + ".");
        System.out.println("   It can be empty, or have a maximum of 32 characters:");
        Scanner s = new Scanner(System.in);
        String password = s.nextLine();
        if (32 < password.length()) {
            System.out.println("The password you entered was over 32 characters long,");
            System.out.println("   so I am dropping: \"" + password.substring(32) + "\"");
            password = password.substring(0, 32);
        }
        return password;
    }

    static String prompt_for_filename(String message) {
        System.out.println(message);
        Scanner s = new Scanner(System.in);
        return s.nextLine();
    }

    static boolean confirm_overwrite(String filename) {
        System.out.println("Warning: the output file: " + filename + " already exists.  Overwrite? (y/n)");
        Scanner s = new Scanner(System.in);
        String buff = s.nextLine();
        return buff.startsWith("y") || buff.startsWith("Y");
    }

    static boolean file_exists(String filename) {
        try {
            FileInputStream fp = new FileInputStream(filename);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    static OutputStream get_output_stream(String output_filename, boolean ask_about_warnings_b) {
        if (output_filename.isEmpty() || output_filename.equals("PROMPT")) {
            output_filename = pdftk.prompt_for_filename("Please enter a name for the output:");
            return pdftk.get_output_stream(output_filename, ask_about_warnings_b);
        }
        if (output_filename.equals("-")) {
            return System.out;
        }
        if (ask_about_warnings_b) {
            boolean output_exists_b = false;
            if (pdftk.file_exists(output_filename) && !pdftk.confirm_overwrite(output_filename)) {
                return pdftk.get_output_stream("PROMPT", ask_about_warnings_b);
            }
        }
        return pdftk.get_output_stream_file(output_filename);
    }

    static OutputStream get_output_stream_file(String output_filename) {
        FileOutputStream os_p = null;
        try {
            os_p = new FileOutputStream(output_filename);
        }
        catch (IOException ioe_p) {
            System.err.println("Error: Failed to open output file: ");
            System.err.println("   " + output_filename);
            System.err.println("   No output created.");
            os_p = null;
        }
        return os_p;
    }

    static PrintStream get_print_stream(String output_filename, boolean output_utf8_b) throws IOException {
        Charset encoding;
        Charset charset = encoding = output_utf8_b ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII;
        if (output_filename.isEmpty() || output_filename.equals("-")) {
            return new PrintStream((OutputStream)System.out, true, encoding.name());
        }
        return new PrintStream(output_filename, encoding.name());
    }

    public static void main(String[] args) {
        System.exit(pdftk.main_noexit(args));
    }

    public static int main_noexit(String[] args) {
        boolean help_b = false;
        boolean version_b = false;
        boolean synopsis_b = args.length == 0;
        ErrorCode ret_val = ErrorCode.NO_ERROR;
        for (String argv : args) {
            version_b = version_b || argv.equals("--version") || argv.equals("-version");
            help_b = help_b || argv.equals("--help") || argv.equals("-help") || argv.equals("-h");
        }
        if (help_b) {
            pdftk.describe_full();
        } else if (version_b) {
            pdftk.describe_header();
        } else if (synopsis_b) {
            pdftk.describe_synopsis();
        } else {
            try {
                TK_Session tk_session = new TK_Session(args);
                tk_session.dump_session_data();
                if (tk_session.is_valid()) {
                    ret_val = tk_session.create_output();
                } else {
                    System.err.println("Done.  Input errors, so no output created.");
                    ret_val = ErrorCode.ERROR;
                }
            }
            catch (ClassCastException c_p) {
                String message = c_p.getMessage();
                if (message.indexOf("com.lowagie.text.pdf.PdfDictionary") >= 0 && message.indexOf("com.lowagie.text.pdf.PRIndirectReference") >= 0) {
                    System.err.println("Error: One input PDF seems to not conform to the PDF standard.");
                    System.err.println("Perhaps the document information dictionary is a direct object");
                    System.err.println("   instead of an indirect reference.");
                    System.err.println("Please report this bug to the program which produced the PDF.");
                    System.err.println();
                }
                System.err.println("Java Exception:");
                c_p.printStackTrace();
                ret_val = ErrorCode.ERROR;
            }
            catch (NoClassDefFoundError error) {
                pdftk.describe_missing_library(error);
                ret_val = ErrorCode.ERROR;
            }
            catch (Throwable t_p) {
                System.err.println("Unhandled Java Exception in main():");
                t_p.printStackTrace();
                ret_val = ErrorCode.BUG;
            }
        }
        if (ret_val == ErrorCode.BUG) {
            pdftk.describe_bug_report();
        }
        return ret_val.code;
    }

    static void describe_header() {
        System.out.println("pdftk port to java 3.1.3 a Handy Tool for Manipulating PDF Documents");
        System.out.println("Copyright (c) 2017-2018 Marc Vinyals - https://gitlab.com/pdftk-java/pdftk");
        System.out.println("Copyright (c) 2003-2013 Steward and Lee, LLC.");
        System.out.println("pdftk includes a modified version of the iText library.");
        System.out.println("Copyright (c) 1999-2009 Bruno Lowagie, Paulo Soares, et al.");
        System.out.println("This is free software; see the source code for copying conditions. There is");
        System.out.println("NO warranty, not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }

    static void describe_resource(String resource) {
        InputStream inputStream = pdftk.class.getResourceAsStream(resource);
        try {
            pdftk.copyStream(inputStream, System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
            pdftk.describe_bug_report();
        }
    }

    static void describe_synopsis() {
        pdftk.describe_resource("resources/synopsis.txt");
    }

    static void describe_full() {
        pdftk.describe_header();
        System.out.println();
        pdftk.describe_synopsis();
        System.out.println();
        pdftk.describe_resource("resources/description.txt");
    }

    static void describe_bug_report() {
        System.err.println("There was a problem with pdftk-java. Please report it at");
        System.err.println("https://gitlab.com/pdftk-java/pdftk/issues");
        System.err.println("including the message above, the version of pdftk-java (3.1.3), and if possible steps to reproduce the error.");
    }

    static void describe_missing_library(Throwable error) {
        System.err.println("Error: could not load a required library for this operation.");
        System.err.println(error);
        System.err.println("Make sure that bcprov and commons-lang3 are installed and included in the");
        System.err.println("classpath. See also https://gitlab.com/pdftk-java/pdftk/issues/2.");
    }
}

