/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.features.SQLFeatureModes;
import org.netbeans.modules.profiler.v2.features.SQLFeatureUI;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

final class SQLFeature
extends ProfilerFeature.Basic {
    private final WeakProcessor processor;
    private FeatureMode currentMode;
    private FeatureMode appliedMode;
    private SQLFeatureModes.AllQueriesMode allQueriesMode;
    private SQLFeatureModes.FilteredQueriesMode filteredQueriesMode;
    private static final String MODE_FLAG = "MODE_FLAG";
    private static final String SETTINGS_FLAG = "SETTINGS_FLAG";
    private JPanel settingsUI;
    private JButton modeButton;
    private JPanel settingsContainer;
    private JButton applyButton;
    private SQLFeatureUI ui;
    private Runnable refresher;
    private volatile boolean running;
    private SQLResetter resetter;

    private SQLFeature(ProfilerSession profilerSession) {
        super(Icons.getIcon((String)"ProfilerIcons.WindowSql"), Bundle.SQLFeature_name(), Bundle.SQLFeature_description(), 20, profilerSession);
        Lookup.Provider provider = profilerSession.getProject();
        String string = provider == null ? "External Process" : ProjectUtilities.getDisplayName((Lookup.Provider)provider);
        this.processor = new WeakProcessor("SQLFeature Processor for " + string);
        this.initModes();
    }

    private void initModes() {
        this.allQueriesMode = new SQLFeatureModes.AllQueriesMode(){

            @Override
            String readFlag(String string, String string2) {
                return SQLFeature.this.readFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void storeFlag(String string, String string2) {
                SQLFeature.this.storeFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void settingsChanged() {
                SQLFeature.this.settingsChanged();
            }
        };
        this.filteredQueriesMode = new SQLFeatureModes.FilteredQueriesMode(){

            @Override
            String readFlag(String string, String string2) {
                return SQLFeature.this.readFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void storeFlag(String string, String string2) {
                SQLFeature.this.storeFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void settingsChanged() {
                SQLFeature.this.settingsChanged();
            }
        };
        String string = this.readFlag(MODE_FLAG, this.allQueriesMode.getID());
        this.currentMode = string.equals(this.filteredQueriesMode.getID()) ? this.filteredQueriesMode : this.allQueriesMode;
        this.appliedMode = this.currentMode;
    }

    private void saveMode() {
        this.storeFlag(MODE_FLAG, this.currentMode.getID());
    }

    private void setMode(FeatureMode featureMode) {
        if (this.currentMode == featureMode) {
            return;
        }
        this.currentMode = featureMode;
        this.modeChanged();
    }

    private void confirmMode() {
        this.appliedMode = this.currentMode;
    }

    private void modeChanged() {
        this.updateModeName();
        this.updateModeUI();
        this.configurationChanged();
        this.saveMode();
    }

    @Override
    public boolean supportsSettings(ProfilingSettings profilingSettings) {
        return !ProfilingSettings.isCPUSettings((ProfilingSettings)profilingSettings) && !ProfilingSettings.isMemorySettings((ProfilingSettings)profilingSettings);
    }

    @Override
    public void configureSettings(ProfilingSettings profilingSettings) {
        this.currentMode.configureSettings(profilingSettings);
    }

    @Override
    public boolean currentSettingsValid() {
        return this.currentMode.currentSettingsValid();
    }

    private void submitChanges() {
        this.confirmMode();
        this.confirmSettings();
        this.fireChange();
    }

    private boolean pendingChanges() {
        if (this.appliedMode != this.currentMode) {
            return true;
        }
        return this.currentMode.pendingChanges();
    }

    private void configurationChanged() {
        assert (this.isActivated());
        ProfilerSession profilerSession = this.getSession();
        if (!profilerSession.inProgress()) {
            this.submitChanges();
        } else {
            this.updateApplyButton(profilerSession.getState());
        }
    }

    private void confirmSettings() {
        this.currentMode.confirmSettings();
    }

    private void confirmAllSettings() {
        if (this.allQueriesMode != null) {
            this.allQueriesMode.confirmSettings();
        }
        if (this.filteredQueriesMode != null) {
            this.filteredQueriesMode.confirmSettings();
        }
    }

    private void settingsChanged() {
        this.configurationChanged();
    }

    private void selectionChanged() {
        this.configurationChanged();
    }

    @Override
    public JPanel getSettingsUI() {
        if (this.settingsUI == null) {
            this.settingsUI = new JPanel(new GridBagLayout()){

                @Override
                public void setVisible(boolean bl) {
                    if (bl && this.getComponentCount() == 0) {
                        SQLFeature.this.populateSettingsUI();
                    }
                    super.setVisible(bl);
                    SQLFeature.this.storeFlag(SQLFeature.SETTINGS_FLAG, bl ? Boolean.TRUE.toString() : null);
                }

                @Override
                public Dimension getPreferredSize() {
                    if (this.getComponentCount() == 0) {
                        return new Dimension();
                    }
                    return super.getPreferredSize();
                }
            };
            String string = this.readFlag(SETTINGS_FLAG, null);
            boolean bl = string == null ? false : Boolean.parseBoolean(string);
            this.settingsUI.setVisible(bl || this.currentMode != this.allQueriesMode);
        }
        return this.settingsUI;
    }

    private void populateSettingsUI() {
        this.settingsUI.setOpaque(false);
        this.settingsUI.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SettingsPanel settingsPanel = new SettingsPanel();
        settingsPanel.add(new JLabel(Bundle.ObjectsFeature_profileMode()));
        settingsPanel.add(Box.createHorizontalStrut(5));
        this.modeButton = new PopupButton(this.currentMode.getName()){

            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JRadioButtonMenuItem(SQLFeature.this.allQueriesMode.getName(), SQLFeature.this.currentMode == SQLFeature.this.allQueriesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        SQLFeature.this.setMode(SQLFeature.this.allQueriesMode);
                    }
                });
                jPopupMenu.add(new JRadioButtonMenuItem(SQLFeature.this.filteredQueriesMode.getName(), SQLFeature.this.currentMode == SQLFeature.this.filteredQueriesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        SQLFeature.this.setMode(SQLFeature.this.filteredQueriesMode);
                    }
                });
            }
        };
        settingsPanel.add(this.modeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.settingsUI.add((Component)settingsPanel, gridBagConstraints);
        this.settingsContainer = new JPanel(new BorderLayout());
        this.settingsContainer.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 18;
        this.settingsUI.add((Component)this.settingsContainer, gridBagConstraints);
        SettingsPanel settingsPanel2 = new SettingsPanel();
        final Component component = Box.createHorizontalStrut(10);
        settingsPanel2.add(component);
        this.applyButton = new SmallButton(Bundle.ObjectsFeature_applyButton()){

            protected void fireActionPerformed(ActionEvent actionEvent) {
                SQLFeature.this.stopResults();
                SQLFeature.this.resetResults();
                SQLFeature.this.submitChanges();
                SQLFeature.this.unpauseResults();
            }

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                component.setVisible(bl);
            }
        };
        settingsPanel2.add(this.applyButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.settingsUI.add((Component)settingsPanel2, gridBagConstraints);
        this.updateModeUI();
        this.updateApplyButton(this.getSession().getState());
    }

    private void updateModeName() {
        if (this.modeButton != null) {
            this.modeButton.setText(this.currentMode.getName());
        }
    }

    private void updateModeUI() {
        if (this.settingsContainer != null) {
            this.settingsContainer.removeAll();
            JComponent jComponent = this.currentMode.getUI();
            if (jComponent != null) {
                this.settingsContainer.add(jComponent);
            }
            this.settingsContainer.doLayout();
            this.settingsContainer.repaint();
        }
    }

    private void updateApplyButton(int n) {
        if (this.applyButton != null) {
            boolean bl = n != 1;
            this.applyButton.setVisible(bl);
            if (bl) {
                this.applyButton.setEnabled(this.currentSettingsValid() && this.pendingChanges());
            }
        }
    }

    @Override
    public JPanel getResultsUI() {
        return this.getUI().getResultsUI();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return this.getUI().getToolbar();
    }

    private SQLFeatureUI getUI() {
        if (this.ui == null) {
            this.ui = new SQLFeatureUI(){

                @Override
                void selectForProfiling(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            String string = "*".equals(sourceCodeSelection.getMethodName()) ? Bundle.SQLFeature_profileClass() : Bundle.SQLFeature_profileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{sourceCodeSelection}), this.getProject(), string);
                        }
                    });
                }

                @Override
                Lookup.Provider getProject() {
                    return SQLFeature.this.getSession().getProject();
                }

                @Override
                ProfilerClient getProfilerClient() {
                    Profiler profiler = SQLFeature.this.getSession().getProfiler();
                    return profiler.getTargetAppRunner().getProfilerClient();
                }

                @Override
                int getSessionState() {
                    return SQLFeature.this.getSessionState();
                }

                @Override
                void refreshResults() {
                    SQLFeature.this.refreshResults();
                }
            };
        }
        return this.ui;
    }

    private void startResults() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.refresher = new Runnable(){

            @Override
            public void run() {
                if (SQLFeature.this.running) {
                    SQLFeature.this.refreshView();
                    SQLFeature.this.refreshResults(1500);
                }
            }
        };
        this.refreshResults(1000);
    }

    private void refreshView() {
        if (this.ui != null && ResultsManager.getDefault().resultsAvailable()) {
            try {
                this.ui.refreshData();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                this.stopResults();
            }
        }
    }

    private void refreshResults() {
        if (this.running) {
            this.processor.post(new Runnable(){

                @Override
                public void run() {
                    if (SQLFeature.this.ui != null) {
                        SQLFeature.this.ui.setForceRefresh();
                    }
                    SQLFeature.this.refreshView();
                }
            });
        }
    }

    private void refreshResults(int n) {
        if (this.running && this.refresher != null) {
            this.processor.post(this.refresher, n);
        }
    }

    private void resetResults() {
        if (this.ui != null) {
            this.ui.resetData();
        }
    }

    private void stopResults() {
        if (this.refresher != null) {
            this.running = false;
            this.refresher = null;
        }
    }

    private void unpauseResults() {
        if (this.ui != null) {
            this.ui.resetPause();
        }
    }

    @Override
    public void notifyActivated() {
        this.resetResults();
        this.resetter = (SQLResetter)Lookup.getDefault().lookup(SQLResetter.class);
        this.resetter.controller = this;
    }

    @Override
    public void notifyDeactivated() {
        this.resetResults();
        if (this.resetter != null) {
            this.resetter.controller = null;
            this.resetter = null;
        }
        if (this.ui != null) {
            this.ui.cleanup();
            this.ui = null;
        }
    }

    @Override
    protected void profilingStateChanged(int n, int n2) {
        if (n2 == 1 || n2 == 128) {
            this.stopResults();
            this.confirmAllSettings();
        } else if (this.isActivated() && n2 == 4) {
            this.startResults();
        } else if (n2 == 2) {
            this.resetResults();
            this.unpauseResults();
        }
        if (this.ui != null) {
            this.ui.sessionStateChanged(this.getSessionState());
        }
        this.updateApplyButton(n2);
    }

    public static final class Provider
    extends ProfilerFeature.Provider {
        @Override
        public ProfilerFeature getFeature(ProfilerSession profilerSession) {
            return new SQLFeature(profilerSession);
        }
    }

    public static final class SQLResetter
    implements ResultsListener {
        private SQLFeature controller;

        @Override
        public void resultsAvailable() {
        }

        @Override
        public void resultsReset() {
            if (this.controller != null && this.controller.ui != null) {
                this.controller.ui.resetData();
            }
        }
    }
}

