/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.ctreber.acearth.scandot;

import ext.plantuml.com.ctreber.acearth.projection.Projection;
import ext.plantuml.com.ctreber.acearth.scandot.ScanDot;
import ext.plantuml.com.ctreber.acearth.scandot.ScanDotGenerator;
import ext.plantuml.com.ctreber.acearth.util.Coordinate;
import ext.plantuml.com.ctreber.acearth.util.Point2D;
import ext.plantuml.com.ctreber.acearth.util.Point3D;

public class DotGeneratorLines
extends ScanDotGenerator {
    private Projection fProjection;
    private int fLineDivider;
    private int fPointDivider;
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;
    private static final double HALFPI = 1.5707963267948966;

    public DotGeneratorLines(Projection pProjection, int pLineDevider, int pPointDivider) {
        this.fProjection = pProjection;
        this.fLineDivider = pLineDevider;
        this.fPointDivider = pPointDivider;
    }

    @Override
    public void generateScanDots() {
        double lLonStep = Math.PI * 2 / (double)(this.fLineDivider * 4);
        double lLatStep = Math.PI / (double)(this.fLineDivider * 2 * this.fPointDivider);
        for (double lLon = -Math.PI; lLon <= Math.PI; lLon += lLonStep) {
            for (double lLat = -1.5707963267948966; lLat <= 1.5707963267948966; lLat += lLatStep) {
                this.transformAndAddDot(new Coordinate(lLat, lLon));
            }
        }
        lLatStep = Math.PI * 2 / (double)(this.fLineDivider * 4);
        lLonStep = Math.PI / (double)(this.fLineDivider * 2 * this.fPointDivider);
        for (double lLat = -1.5707963267948966; lLat <= 1.5707963267948966; lLat += lLatStep) {
            for (double lLon = -Math.PI; lLon <= Math.PI; lLon += lLonStep) {
                this.transformAndAddDot(new Coordinate(lLat, lLon));
            }
        }
    }

    private void transformAndAddDot(Coordinate pPos) {
        Point2D lPoint;
        Point3D lPointRotated = this.fProjection.rotate(pPos.getPoint3DRads());
        if (this.fProjection.isVisible(lPointRotated) && this.fProjection.isWithinImage(lPoint = this.fProjection.finalize(this.fProjection.project2D(lPointRotated)))) {
            this.fDots.add(new ScanDot(1, lPoint));
        }
    }
}

