/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileHeightFixedMarged
extends AbstractFtile {
    private final Ftile tile;
    private final double ymargin1;
    private final double ymargin2;

    public FtileHeightFixedMarged(double ymargin1, Ftile tile, double ymargin2) {
        super(tile.skinParam());
        this.tile = tile;
        this.ymargin1 = ymargin1;
        this.ymargin2 = ymargin2;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dim = this.tile.calculateDimension(stringBounder);
        return dim.translate(this.getTranslate(stringBounder)).fixedHeight(this.ymargin1 + dim.getHeight() + this.ymargin2);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        return UTranslate.dy(this.ymargin1);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.getTranslate(ug.getStringBounder())).draw(this.tile);
    }
}

