/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleFontFamilyChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*?)\\</font\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*)$)");
    }

    private CommandCreoleFontFamilyChange(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        String family = m.group(2);
        FontConfiguration fc2 = fc1.changeFamily(family);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

