/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolFile
extends USymbol {
    private final HorizontalAlignment stereotypeAlignement = HorizontalAlignment.CENTER;

    USymbolFile() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.FILE;
    }

    private void drawFile(UGraphic ug, double width, double height, boolean shadowing, double roundCorner) {
        UPath path;
        AbstractShadowable out;
        int cornersize = 10;
        if (roundCorner == 0.0) {
            UPolygon polygon = new UPolygon();
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(0.0, height);
            polygon.addPoint(width, height);
            polygon.addPoint(width, 10.0);
            polygon.addPoint(width - 10.0, 0.0);
            polygon.addPoint(0.0, 0.0);
            out = polygon;
        } else {
            path = new UPath();
            path.moveTo(0.0, roundCorner / 2.0);
            path.lineTo(0.0, height - roundCorner / 2.0);
            path.arcTo(new Point2D.Double(roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width - roundCorner / 2.0, height);
            path.arcTo(new Point2D.Double(width, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width, 10.0);
            path.lineTo(width - 10.0, 0.0);
            path.lineTo(roundCorner / 2.0, 0.0);
            path.arcTo(new Point2D.Double(0.0, roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            out = path;
        }
        if (shadowing) {
            out.setDeltaShadow(3.0);
        }
        ug.draw(out);
        path = new UPath();
        path.moveTo(width - 10.0, 0.0);
        if (roundCorner == 0.0) {
            path.lineTo(width - 10.0, 10.0);
        } else {
            path.lineTo(width - 10.0, 10.0 - roundCorner / 2.0);
            path.arcTo(new Point2D.Double(width - 10.0 + roundCorner / 2.0, 10.0), roundCorner / 2.0, 0.0, 0.0);
        }
        path.lineTo(width, 10.0);
        ug.draw(path);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolFile.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolFile.this.drawFile(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolFile.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolFile.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolFile.this.drawFile(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (USymbolFile.this.stereotypeAlignement == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolFile.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolFile.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

