/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jcckit;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import jcckit.GraphicsPlotCanvas;
import jcckit.data.DataPlot;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.security.ImageIO;

public class PSystemJcckit
extends AbstractPSystem {
    private final PropertiesBasedConfigData prop;
    private final int width;
    private final int height;

    public PSystemJcckit(Properties p, int width, int height) {
        this.width = width;
        this.height = height;
        this.prop = new PropertiesBasedConfigData(p);
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        ConfigParameters config = new ConfigParameters(this.prop);
        GraphicsPlotCanvas plotCanvas = new GraphicsPlotCanvas(config, image);
        plotCanvas.connect(DataPlot.create(config));
        plotCanvas.paint();
        ImageIO.write((RenderedImage)image, "png", os);
        return new ImageDataSimple(this.width, this.height);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(JCCKit)");
    }
}

